/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.config.json.BiomeData;
import sereneseasons.util.biome.BiomeUtil;
import sereneseasons.util.config.JsonUtil;

public class BiomeConfig {
    public static final Map<ResourceLocation, BiomeData> biomeDataMap = Maps.newHashMap();

    public static void init(File configDir) {
        HashMap defaultBiomeData = Maps.newHashMap();
        BiomeConfig.addBlacklistedBiomes(defaultBiomeData);
        BiomeConfig.addTropicalBiomes(defaultBiomeData);
        biomeDataMap.clear();
        Map tmpBiomeDataMap = JsonUtil.getOrCreateConfigFile(configDir, "biome_info.json", defaultBiomeData, new TypeToken<Map<String, BiomeData>>(){}.getType());
        if (tmpBiomeDataMap != null && !tmpBiomeDataMap.isEmpty()) {
            for (Map.Entry entry : tmpBiomeDataMap.entrySet()) {
                biomeDataMap.put(new ResourceLocation((String)entry.getKey()), (BiomeData)entry.getValue());
            }
        }
    }

    public static boolean enablesSeasonalEffects(ResourceKey<Biome> biome) {
        ResourceLocation name = biome.m_135782_();
        if (biomeDataMap.containsKey(name)) {
            return BiomeConfig.biomeDataMap.get((Object)name).enableSeasonalEffects;
        }
        return true;
    }

    public static boolean usesTropicalSeasons(ResourceKey<Biome> key) {
        ResourceLocation name = key.m_135782_();
        Biome biome = BiomeUtil.getBiome(key);
        if (biomeDataMap.containsKey(name)) {
            return BiomeConfig.biomeDataMap.get((Object)name).useTropicalSeasons;
        }
        return biome.m_47554_() > 0.8f;
    }

    public static boolean infertileBiome(ResourceKey<Biome> biome) {
        String name;
        ArrayList infertileBiomes = Lists.newArrayList((Object[])new String[]{"biomesoplenty:wasteland"});
        return infertileBiomes.contains(name = biome.m_135782_().toString());
    }

    public static boolean lessColorChange(ResourceKey<Biome> biome) {
        String name;
        ArrayList lessColorChangeBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:swamp", "minecraft:swamp_hills", "biomesoplenty:mystic_grove", "biomesoplenty:mystic_plains", "biomesoplenty:tundra", "biomesoplenty:tundra_basin", "biomesoplenty:tundra_bog", "biomesoplenty:ominous_woods", "biomesoplenty:ominous_mire"});
        return lessColorChangeBiomes.contains(name = biome.m_135782_().toString());
    }

    private static void addBlacklistedBiomes(Map<String, BiomeData> map) {
        ArrayList blacklistedBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:mushroom_fields", "minecraft:mushroom_fields_shore", "minecraft:ocean", "minecraft:deep_ocean", "minecraft:frozen_ocean", "minecraft:deep_frozen_ocean", "minecraft:cold_ocean", "minecraft:deep_cold_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:warm_ocean", "minecraft:deep_warm_ocean", "minecraft:river", "minecraft:the_void", "biomesoplenty:origin_valley", "biomesoplenty:rainbow_hills"});
        for (String biomeName : blacklistedBiomes) {
            if (!map.containsKey(biomeName)) {
                map.put(biomeName, new BiomeData(false, false));
                continue;
            }
            map.get((Object)biomeName).enableSeasonalEffects = false;
        }
    }

    private static void addTropicalBiomes(Map<String, BiomeData> map) {
        ArrayList tropicalBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:swamp", "minecraft:swamp_hills", "minecraft:warm_ocean", "minecraft:deep_warm_ocean"});
        for (String biomeName : tropicalBiomes) {
            if (!map.containsKey(biomeName)) {
                map.put(biomeName, new BiomeData(true, true));
                continue;
            }
            map.get((Object)biomeName).useTropicalSeasons = true;
        }
    }
}

