/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import sereneseasons.network.message.MessageSyncConfigs;
import sereneseasons.network.message.MessageSyncSeasonCycle;

public class PacketHandler {
    public static final String PROTOCOL_VERSION = Integer.toString(0);
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("sereneseasons", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private static int nextFreeIndex;

    public static void init() {
        PacketHandler.registerMessage(MessageSyncSeasonCycle.class, MessageSyncSeasonCycle::encode, MessageSyncSeasonCycle::decode, MessageSyncSeasonCycle.Handler::handle);
        PacketHandler.registerMessage(MessageSyncConfigs.class, MessageSyncConfigs::encode, MessageSyncConfigs::decode, MessageSyncConfigs.Handler::handle);
    }

    private static <T> void registerMessage(Class<T> type, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> consumer) {
        HANDLER.registerMessage(nextFreeIndex++, type, encoder, decoder, consumer);
    }
}

