/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.season.SeasonHooks;

@Mod.EventBusSubscriber
public class RandomUpdateHandler {
    private void adjustWeatherFrequency(Level world, Season season) {
        if (!((Boolean)SeasonsConfig.changeWeatherFrequency.get()).booleanValue()) {
            return;
        }
        ServerLevelData serverLevelData = (ServerLevelData)world.m_6106_();
        if (season == Season.WINTER) {
            if (serverLevelData.m_6534_()) {
                serverLevelData.m_5557_(false);
            }
            if (!world.m_6106_().m_6533_() && serverLevelData.m_6531_() > 36000) {
                serverLevelData.m_6399_(world.f_46441_.nextInt(24000) + 12000);
            }
        } else if (season == Season.SPRING) {
            if (!world.m_6106_().m_6533_() && serverLevelData.m_6531_() > 96000) {
                serverLevelData.m_6399_(world.f_46441_.nextInt(84000) + 12000);
            }
        } else if (season == Season.SUMMER && !world.m_6106_().m_6534_() && serverLevelData.m_6558_() > 36000) {
            serverLevelData.m_6398_(world.f_46441_.nextInt(24000) + 12000);
        }
    }

    private void meltInChunk(ChunkMap chunkManager, LevelChunk chunkIn, Season.SubSeason subSeason) {
        ServerLevel world = chunkManager.f_140133_;
        ChunkPos chunkpos = chunkIn.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        if (world.f_46441_.nextInt(switch (subSeason) {
            case Season.SubSeason.EARLY_SPRING -> 16;
            case Season.SubSeason.MID_SPRING -> 12;
            case Season.SubSeason.LATE_SPRING -> 8;
            default -> 4;
        }) == 0) {
            BlockPos topAirPos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, world.m_46496_(i, 0, j, 15));
            BlockPos topGroundPos = topAirPos.m_7495_();
            BlockState aboveGroundState = world.m_8055_(topAirPos);
            BlockState groundState = world.m_8055_(topGroundPos);
            ResourceKey biome = world.m_45837_(topAirPos).orElse(null);
            if (!BiomeConfig.enablesSeasonalEffects((ResourceKey<Biome>)biome)) {
                return;
            }
            if (aboveGroundState.m_60734_() == Blocks.f_50125_) {
                if (SeasonHooks.getBiomeTemperature((Level)world, (ResourceKey<Biome>)biome, topGroundPos) >= 0.15f) {
                    world.m_46597_(topAirPos, Blocks.f_50016_.m_49966_());
                }
            } else if (groundState.m_60734_() == Blocks.f_50126_ && SeasonHooks.getBiomeTemperature((Level)world, (ResourceKey<Biome>)biome, topGroundPos) >= 0.15f) {
                ((IceBlock)Blocks.f_50126_).m_54168_(groundState, (Level)world, topGroundPos);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            Season.SubSeason subSeason = SeasonHelper.getSeasonState(event.world).getSubSeason();
            Season season = subSeason.getSeason();
            this.adjustWeatherFrequency(event.world, season);
            if (season != Season.WINTER && ((Boolean)SeasonsConfig.generateSnowAndIce.get()).booleanValue() && SeasonsConfig.isDimensionWhitelisted((ResourceKey<Level>)event.world.m_46472_())) {
                ServerLevel world = (ServerLevel)event.world;
                ChunkMap chunkManager = world.m_7726_().f_8325_;
                chunkManager.m_140416_().forEach(chunkHolder -> {
                    Optional optional = chunkHolder.m_140073_().getNow(ChunkHolder.f_139997_).left();
                    if (optional.isPresent()) {
                        LevelChunk chunk = (LevelChunk)optional.get();
                        ChunkPos chunkpos = chunkHolder.m_140092_();
                        if (!chunkManager.m_140397_(chunkpos)) {
                            this.meltInChunk(chunkManager, chunk, subSeason);
                        }
                    }
                });
            }
        }
    }
}

