/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import sereneseasons.api.SSGameRules;
import sereneseasons.api.config.SeasonsOption;
import sereneseasons.api.config.SyncedConfig;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.handler.PacketHandler;
import sereneseasons.network.message.MessageSyncSeasonCycle;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

public class SeasonHandler
implements SeasonHelper.ISeasonDataProvider {
    private Season.SubSeason lastSeason = null;
    public static final HashMap<ResourceKey<Level>, Integer> clientSeasonCycleTicks = new HashMap();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        Level world = event.world;
        if (event.phase == TickEvent.Phase.END && !world.f_46443_) {
            MinecraftServer server;
            if (!SyncedConfig.getBooleanValue(SeasonsOption.PROGRESS_SEASON_WHILE_OFFLINE) && (server = world.m_142572_()) != null && server.m_6846_().m_11309_() == 0) {
                return;
            }
            if (!world.m_46469_().m_46207_(SSGameRules.RULE_DOSEASONCYCLE)) {
                return;
            }
            SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
            if (savedData.seasonCycleTicks++ > SeasonTime.ZERO.getCycleDuration()) {
                savedData.seasonCycleTicks = 0;
            }
            if (savedData.seasonCycleTicks % 20 == 0) {
                SeasonHandler.sendSeasonUpdate(world);
            }
            savedData.m_77762_();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        Level world = player.f_19853_;
        SeasonHandler.sendSeasonUpdate(world);
    }

    public static SeasonTime getClientSeasonTime() {
        Integer i = clientSeasonCycleTicks.get(Minecraft.m_91087_().f_91073_.m_46472_());
        return new SeasonTime(i == null ? 0 : i);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        ResourceKey dimension = Minecraft.m_91087_().f_91074_.f_19853_.m_46472_();
        if (event.phase == TickEvent.Phase.END && SeasonsConfig.isDimensionWhitelisted((ResourceKey<Level>)dimension)) {
            SeasonTime calendar;
            clientSeasonCycleTicks.compute((ResourceKey<Level>)dimension, (k, v) -> v == null ? 0 : v + 1);
            if (clientSeasonCycleTicks.get(dimension) > SeasonTime.ZERO.getCycleDuration()) {
                clientSeasonCycleTicks.put((ResourceKey<Level>)dimension, 0);
            }
            if ((calendar = new SeasonTime(clientSeasonCycleTicks.get(dimension))).getSubSeason() != this.lastSeason) {
                Minecraft.m_91087_().f_91060_.m_109818_();
                this.lastSeason = calendar.getSubSeason();
            }
        }
    }

    public static void sendSeasonUpdate(Level world) {
        if (!world.f_46443_) {
            SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
            PacketHandler.HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new MessageSyncSeasonCycle((ResourceKey<Level>)world.m_46472_(), savedData.seasonCycleTicks));
        }
    }

    public static SeasonSavedData getSeasonSavedData(Level w) {
        if (w.m_5776_() || !(w instanceof ServerLevel)) {
            return null;
        }
        ServerLevel world = (ServerLevel)w;
        DimensionDataStorage saveDataManager = world.m_7726_().m_8483_();
        Supplier<SeasonSavedData> defaultSaveDataSupplier = () -> {
            SeasonSavedData savedData = new SeasonSavedData();
            int startingSeason = SyncedConfig.getIntValue(SeasonsOption.STARTING_SUB_SEASON);
            if (startingSeason == 0) {
                savedData.seasonCycleTicks = world.f_46441_.nextInt(12) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            if (startingSeason > 0) {
                savedData.seasonCycleTicks = (startingSeason - 1) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            savedData.m_77762_();
            return savedData;
        };
        return (SeasonSavedData)saveDataManager.m_164861_(SeasonSavedData::load, defaultSaveDataSupplier, "seasons");
    }

    @Override
    public ISeasonState getServerSeasonState(Level world) {
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
        return new SeasonTime(savedData.seasonCycleTicks);
    }

    @Override
    public ISeasonState getClientSeasonState() {
        Integer i = clientSeasonCycleTicks.get(Minecraft.m_91087_().f_91073_.m_46472_());
        return new SeasonTime(i == null ? 0 : i);
    }
}

