/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.network.message;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import sereneseasons.api.config.SyncedConfig;
import sereneseasons.core.SereneSeasons;

public class MessageSyncConfigs {
    public CompoundTag nbtOptions;

    public MessageSyncConfigs(CompoundTag nbtOptions) {
        this.nbtOptions = nbtOptions;
    }

    public static void encode(MessageSyncConfigs packet, FriendlyByteBuf buf) {
        buf.m_130079_(packet.nbtOptions);
    }

    public static MessageSyncConfigs decode(FriendlyByteBuf buf) {
        return new MessageSyncConfigs(buf.m_130260_());
    }

    public static class Handler {
        public static void handle(MessageSyncConfigs packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                for (String key : packet.nbtOptions.m_128431_()) {
                    SyncedConfig.SyncedConfigEntry entry = SyncedConfig.optionsToSync.get(key);
                    if (entry == null) {
                        SereneSeasons.logger.error("Option " + key + " does not exist locally!");
                    }
                    entry.value = packet.nbtOptions.m_128461_(key);
                    SereneSeasons.logger.info("SS configuration synchronized with the server");
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

