/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import sereneseasons.handler.season.SeasonHandler;

public class MessageSyncSeasonCycle {
    public ResourceKey<Level> dimension;
    public int seasonCycleTicks;

    public MessageSyncSeasonCycle() {
    }

    public MessageSyncSeasonCycle(ResourceKey<Level> dimension, int seasonCycleTicks) {
        this.dimension = dimension;
        this.seasonCycleTicks = seasonCycleTicks;
    }

    public static void encode(MessageSyncSeasonCycle packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.dimension.m_135782_().toString());
        buf.writeInt(packet.seasonCycleTicks);
    }

    public static MessageSyncSeasonCycle decode(FriendlyByteBuf buf) {
        return new MessageSyncSeasonCycle((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130277_())), buf.readInt());
    }

    public static class Handler {
        public static void handle(MessageSyncSeasonCycle packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                if (Minecraft.m_91087_().f_91074_ == null) {
                    return;
                }
                ResourceKey playerDimension = Minecraft.m_91087_().f_91074_.f_19853_.m_46472_();
                if (playerDimension.equals(packet.dimension)) {
                    SeasonHandler.clientSeasonCycleTicks.replace((ResourceKey<Level>)playerDimension, packet.seasonCycleTicks);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

