/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.command.CommandGetGrave;
import com.lothrazar.simpletomb.command.ITombCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommandEvents {
    public static final List<ITombCommand> COMMANDS = new ArrayList<ITombCommand>();
    public static final List<String> SUBCOMMANDS = new ArrayList<String>();

    @SubscribeEvent
    public void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        COMMANDS.add(new CommandGetGrave());
        if (SUBCOMMANDS.size() == 0) {
            for (ITombCommand cmd : COMMANDS) {
                SUBCOMMANDS.add(cmd.getName());
            }
        }
        CommandDispatcher r = event.getDispatcher();
        r.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"simpletomb").then(Commands.func_197056_a((String)"arguments", (ArgumentType)StringArgumentType.greedyString()).executes(this::execute))).executes(this::execute));
    }

    private int execute(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        List<String> arguments = Arrays.asList(ctx.getInput().split("\\s+"));
        if (arguments.size() < 2) {
            this.badCommandMsg(player);
            return 0;
        }
        String sub = arguments.get(1);
        for (ITombCommand cmd : COMMANDS) {
            boolean isOp;
            if (!sub.equalsIgnoreCase(cmd.getName())) continue;
            if (cmd.needsOp() && !(isOp = ((CommandSource)ctx.getSource()).func_197034_c(1))) {
                ModTomb.LOGGER.info("Player [" + player.func_110124_au() + "," + player.func_145748_c_() + "] attempted command " + sub + " but does not have the required permissions");
                UtilChat.sendFeedback(ctx, (String)"commands.help.failed");
                return 1;
            }
            return cmd.execute(ctx, arguments.subList(2, arguments.size()), (PlayerEntity)player);
        }
        this.badCommandMsg(player);
        return 0;
    }

    private void badCommandMsg(ServerPlayerEntity player) {
        player.func_145747_a((ITextComponent)new TranslationTextComponent("simpletomb.commands.null"), player.func_110124_au());
        player.func_145747_a((ITextComponent)new TranslationTextComponent("[" + String.join((CharSequence)", ", SUBCOMMANDS) + "]"), player.func_110124_au());
    }
}

