/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.particle;

import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.particle.CustomParticle;
import java.util.function.Predicate;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleCasting
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("simpletomb", "textures/particle/casting.png");
    private final LivingEntity caster;
    private final Predicate<LivingEntity> predic;
    private final double radius = 1.1;
    private double angle;
    private static final double ROT_INCR = 0.15707963267948966;
    private final float colorR;
    private final float colorG;
    private final float colorB;
    private boolean goUp;

    public ParticleCasting(ClientWorld world, LivingEntity caster, Predicate<LivingEntity> predic, double addY, double angle) {
        super(world, caster.func_226277_ct_(), caster.func_226278_cu_() + addY, caster.func_226281_cx_());
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.func_82338_g(1.0f);
        this.goUp = addY < 1.0;
        this.caster = caster;
        this.predic = predic;
        this.field_70544_f = world.field_73012_v.nextFloat() * 0.1f + 0.15f;
        this.angle = angle + (double)WorldHelper.getRandom(world.field_73012_v, -0.25, 0.25);
        this.field_190014_F = world.field_73012_v.nextFloat() * ((float)Math.PI * 2);
        float[] color = WorldHelper.getRGBColor3F(14937088);
        this.colorR = color[0];
        this.colorG = color[1];
        this.colorB = color[2];
        this.field_190017_n = false;
        this.updatePosition();
    }

    private void updatePosition() {
        this.angle += (double)0.01f;
        this.field_187123_c = this.field_187126_f = this.caster.func_226277_ct_() + this.radius * Math.cos(Math.PI * 2 * this.angle);
        this.field_187124_d = this.field_187127_g += this.goUp ? 0.02 : -0.02;
        this.field_187125_e = this.field_187128_h = this.caster.func_226281_cx_() + this.radius * Math.sin(Math.PI * 2 * this.angle);
        this.func_70538_b(this.clampColor(this.colorR + WorldHelper.getRandom(this.field_187122_b.field_73012_v, -20.0, 20.0) / 255.0f), this.clampColor(this.colorG - WorldHelper.getRandom(this.field_187122_b.field_73012_v, -20.0, 20.0) / 255.0f), this.clampColor(this.colorB + WorldHelper.getRandom(this.field_187122_b.field_73012_v, -20.0, 20.0) / 255.0f));
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F = (float)((double)this.field_190014_F + 0.15707963267948966);
    }

    private float clampColor(float color) {
        return MathHelper.func_76131_a((float)color, (float)0.0f, (float)1.0f);
    }

    public void func_189213_a() {
        if (this.field_187127_g > this.caster.func_226278_cu_() + 2.0 || this.field_187127_g < this.caster.func_226278_cu_()) {
            boolean bl = this.goUp = !this.goUp;
        }
        if (this.predic.test(this.caster)) {
            this.func_187112_i();
        }
        this.updatePosition();
        ++this.field_70546_d;
    }

    protected int func_189214_a(float partialTick) {
        int skylight = 5;
        int blocklight = 15;
        return skylight << 20 | blocklight << 4;
    }

    @Override
    ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }
}

