/*
 * Decompiled with CFR 0.152.
 */
package tfc.smallerunits;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.common.ToolType;
import tfc.smallerunits.SmallerUnitsTileEntity;
import tfc.smallerunits.registry.Deferred;
import tfc.smallerunits.utils.FakePlayer;
import tfc.smallerunits.utils.SmallUnit;

public class SmallerUnitBlock
extends Block
implements ITileEntityProvider {
    private static final BiFunction<AxisAlignedBB, AxisAlignedBB, Boolean> checkCollision = (a, b) -> b.func_72326_a(a);

    public SmallerUnitBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 40.0f).func_200947_a(SoundType.field_185851_d).harvestLevel(0).harvestTool(ToolType.PICKAXE));
    }

    public float func_176195_g(BlockState blockState, IBlockReader worldIn, BlockPos pos) {
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public float func_180647_a(BlockState state, final PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        VoxelShape shape = this.getSelectedShape(worldIn, pos, new ISelectionContext(){

            public boolean func_225581_b_() {
                return false;
            }

            public boolean func_216378_a(VoxelShape shape, BlockPos pos, boolean p_216378_3_) {
                return true;
            }

            public boolean func_216375_a(Item itemIn) {
                return player.func_184586_b(Hand.MAIN_HAND).equals(itemIn);
            }

            @Nullable
            public Entity getEntity() {
                return player;
            }
        });
        TileEntity uncastedTE = worldIn.func_175625_s(pos);
        if (uncastedTE instanceof SmallerUnitsTileEntity) {
            SmallerUnitsTileEntity te = (SmallerUnitsTileEntity)uncastedTE;
            Vec3d posBreak = shape.func_197752_a().func_189972_c().func_186678_a((double)te.containedWorld.unitsPerBlock);
            BlockState stateRemove = te.containedWorld.func_180495_p(new BlockPos(posBreak));
            return 1.0f / (1.0f / stateRemove.func_185903_a(player, (IBlockReader)te.containedWorld, new BlockPos(posBreak)) / (float)te.containedWorld.unitsPerBlock);
        }
        return 1.0f;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape;
        block14: {
            block13: {
                shape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
                if (context == null) break block13;
                Entity entity = context.getEntity();
                AxisAlignedBB bb1 = null;
                SmallerUnitsTileEntity te = (SmallerUnitsTileEntity)worldIn.func_175625_s(pos);
                if (entity != null && te != null) {
                    bb1 = entity.func_70114_g(entity);
                    if (bb1 == null) {
                        bb1 = entity.func_70046_E();
                    }
                    if (bb1 == null) {
                        bb1 = entity.func_174813_aQ();
                    }
                    bb1 = bb1.func_191194_a(new Vec3d((Vec3i)pos).func_186678_a(-1.0));
                    float expand = 0.2125f;
                    expand = Math.max(expand, entity.func_70111_Y() * expand);
                    bb1 = bb1.func_72314_b((double)expand, (double)expand, (double)expand);
                    bb1 = bb1.func_186662_g((double)entity.func_70111_Y());
                }
                AxisAlignedBB finalBb = bb1;
                if (te == null) break block14;
                for (SmallUnit u : te.containedWorld.unitHashMap.values()) {
                    VoxelShape shape1 = u.heldState.func_196952_d((IBlockReader)te.containedWorld, new BlockPos(u.x, u.y, u.z));
                    AtomicBoolean collides = new AtomicBoolean(false);
                    if (entity != null) {
                        shape1.func_197756_d().forEach(b -> {
                            if (b != null && checkCollision.apply(b = new AxisAlignedBB(b.field_72340_a / (double)te.containedWorld.unitsPerBlock, b.field_72338_b / (double)te.containedWorld.unitsPerBlock, b.field_72339_c / (double)te.containedWorld.unitsPerBlock, b.field_72336_d / (double)te.containedWorld.unitsPerBlock, b.field_72337_e / (double)te.containedWorld.unitsPerBlock, b.field_72334_f / (double)te.containedWorld.unitsPerBlock).func_72317_d((double)((float)u.x / (float)te.containedWorld.unitsPerBlock), (double)((float)u.y / (float)te.containedWorld.unitsPerBlock), (double)((float)u.z / (float)te.containedWorld.unitsPerBlock)), finalBb).booleanValue()) {
                                collides.set(true);
                            }
                        });
                    } else {
                        collides.set(true);
                    }
                    if (!shape1.func_197766_b() && collides.get() && !u.heldState.func_196958_f() && te.containedWorld.unitsPerBlock == 0) {
                        te.containedWorld.unitsPerBlock = 4;
                    }
                    for (AxisAlignedBB bb : shape1.func_197756_d()) {
                        if (entity != null) {
                            bb = new AxisAlignedBB(bb.field_72340_a / (double)te.containedWorld.unitsPerBlock, bb.field_72338_b / (double)te.containedWorld.unitsPerBlock, bb.field_72339_c / (double)te.containedWorld.unitsPerBlock, bb.field_72336_d / (double)te.containedWorld.unitsPerBlock, bb.field_72337_e / (double)te.containedWorld.unitsPerBlock, bb.field_72334_f / (double)te.containedWorld.unitsPerBlock).func_72317_d((double)((float)u.x / (float)te.containedWorld.unitsPerBlock), (double)((float)u.y / (float)te.containedWorld.unitsPerBlock), (double)((float)u.z / (float)te.containedWorld.unitsPerBlock));
                            if (!checkCollision.apply(bb, bb1).booleanValue() && !bb.func_72326_a(bb1) && !bb.func_72318_a(bb1.func_189972_c()) && !bb1.func_72318_a(bb.func_189972_c()) && !context.func_216378_a(shape1, pos, true)) continue;
                            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)bb), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                            continue;
                        }
                        shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)(bb.field_72340_a / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72338_b / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72339_c / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72336_d / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72337_e / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72334_f / (double)te.containedWorld.unitsPerBlock)).func_197751_a((double)((float)u.x / (float)te.containedWorld.unitsPerBlock), (double)((float)u.y / (float)te.containedWorld.unitsPerBlock), (double)((float)u.z / (float)te.containedWorld.unitsPerBlock)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                }
                break block14;
            }
            SmallerUnitsTileEntity te = (SmallerUnitsTileEntity)worldIn.func_175625_s(pos);
            if (te != null) {
                for (SmallUnit u : te.containedWorld.unitHashMap.values()) {
                    VoxelShape shape1;
                    if (te.containedWorld.unitsPerBlock == 0) {
                        te.containedWorld.unitsPerBlock = 4;
                    }
                    if ((shape1 = u.heldState.func_196952_d((IBlockReader)te.containedWorld, new BlockPos(u.x, u.y, u.z))).func_197766_b() || u.heldState.func_196958_f()) continue;
                    for (AxisAlignedBB bb : shape1.func_197756_d()) {
                        shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)(bb.field_72340_a / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72338_b / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72339_c / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72336_d / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72337_e / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72334_f / (double)te.containedWorld.unitsPerBlock)).func_197751_a((double)((float)u.x / (float)te.containedWorld.unitsPerBlock), (double)((float)u.y / (float)te.containedWorld.unitsPerBlock), (double)((float)u.z / (float)te.containedWorld.unitsPerBlock)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                }
            }
        }
        return shape;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        try {
            return this.getSelectedShape(worldIn, pos, new ISelectionContext(){

                public boolean func_225581_b_() {
                    return false;
                }

                public boolean func_216378_a(VoxelShape shape, BlockPos pos, boolean p_216378_3_) {
                    return false;
                }

                public boolean func_216375_a(Item itemIn) {
                    return false;
                }

                @Nullable
                public Entity getEntity() {
                    return Minecraft.func_71410_x().field_175622_Z;
                }
            });
        }
        catch (Throwable err) {
            VoxelShape shape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            try {
                SmallerUnitsTileEntity te = (SmallerUnitsTileEntity)worldIn.func_175625_s(pos);
                for (SmallUnit u : te.containedWorld.unitHashMap.values()) {
                    for (AxisAlignedBB bb : u.heldState.func_196954_c((IBlockReader)te.containedWorld, new BlockPos(u.x, u.y, u.z)).func_197756_d()) {
                        if (te.containedWorld.unitsPerBlock == 0) {
                            te.containedWorld.unitsPerBlock = 4;
                        }
                        shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)(bb.field_72340_a / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72338_b / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72339_c / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72336_d / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72337_e / (double)te.containedWorld.unitsPerBlock), (double)(bb.field_72334_f / (double)te.containedWorld.unitsPerBlock)).func_197751_a((double)((float)u.x / (float)te.containedWorld.unitsPerBlock), (double)((float)u.y / (float)te.containedWorld.unitsPerBlock), (double)((float)u.z / (float)te.containedWorld.unitsPerBlock)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (shape.func_197766_b()) {
                return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            return shape;
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getSelectedShape(worldIn, pos, context);
    }

    public VoxelShape getSelectedShape(IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (context.getEntity() != null) {
            try {
                VoxelShape defaultShape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.01, (double)0.01, (double)0.01);
                VoxelShape returnVal = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.01, (double)0.01, (double)0.01);
                double distanceBest = 999999.0;
                Vec3d start = context.getEntity().func_174824_e(0.0f);
                Vec3d stop = start.func_178787_e(context.getEntity().func_70040_Z().func_186678_a(9.0));
                SmallerUnitsTileEntity te = (SmallerUnitsTileEntity)worldIn.func_175625_s(pos);
                if (te != null) {
                    VoxelShape shape;
                    for (SmallUnit u : te.containedWorld.unitHashMap.values()) {
                        try {
                            double bestDist = 999999.0;
                            shape = null;
                            for (Object bb : u.heldState.func_196954_c((IBlockReader)te.containedWorld, new BlockPos(u.x, u.y, u.z)).func_197756_d()) {
                                try {
                                    double thisDist;
                                    if (te.containedWorld.unitsPerBlock == 0) {
                                        te.containedWorld.unitsPerBlock = 4;
                                    }
                                    AxisAlignedBB newBox = new AxisAlignedBB(((AxisAlignedBB)bb).field_72340_a / (double)te.containedWorld.unitsPerBlock, ((AxisAlignedBB)bb).field_72338_b / (double)te.containedWorld.unitsPerBlock, ((AxisAlignedBB)bb).field_72339_c / (double)te.containedWorld.unitsPerBlock, ((AxisAlignedBB)bb).field_72336_d / (double)te.containedWorld.unitsPerBlock, ((AxisAlignedBB)bb).field_72337_e / (double)te.containedWorld.unitsPerBlock, ((AxisAlignedBB)bb).field_72334_f / (double)te.containedWorld.unitsPerBlock).func_72317_d((double)((float)u.x / (float)te.containedWorld.unitsPerBlock), (double)((float)u.y / (float)te.containedWorld.unitsPerBlock), (double)((float)u.z / (float)te.containedWorld.unitsPerBlock));
                                    shape = shape == null ? VoxelShapes.func_197881_a((AxisAlignedBB)newBox) : VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)newBox), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                                    if (!newBox.func_186670_a(pos).func_216365_b(start, stop).isPresent() || !((thisDist = ((Vec3d)newBox.func_186670_a(pos).func_216365_b(start, stop).get()).func_72438_d(start)) < bestDist)) continue;
                                    bestDist = thisDist;
                                }
                                catch (Exception newBox) {}
                            }
                            if (shape == null || shape.func_197766_b() || !(bestDist < distanceBest)) continue;
                            returnVal = shape;
                            distanceBest = bestDist;
                        }
                        catch (Exception exception) {}
                    }
                    if (returnVal.toString().equals(defaultShape.toString())) {
                        for (Direction off : Direction.values()) {
                            shape = worldIn.func_180495_p(pos.func_177972_a(off)).func_196954_c(worldIn, pos);
                            VoxelShape shapeReturn = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
                            try {
                                for (AxisAlignedBB bb : shape.func_197756_d()) {
                                    AxisAlignedBB newBox = new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                                    Optional result = newBox.func_186670_a(pos.func_177972_a(off)).func_216365_b(start, stop);
                                    if (!result.isPresent()) continue;
                                    newBox = new AxisAlignedBB(bb.field_72340_a / (double)te.containedWorld.unitsPerBlock, bb.field_72338_b / (double)te.containedWorld.unitsPerBlock, bb.field_72339_c / (double)te.containedWorld.unitsPerBlock, bb.field_72336_d / (double)te.containedWorld.unitsPerBlock, bb.field_72337_e / (double)te.containedWorld.unitsPerBlock, bb.field_72334_f / (double)te.containedWorld.unitsPerBlock);
                                    try {
                                        VoxelShape shapeBox = VoxelShapes.func_197881_a((AxisAlignedBB)newBox).func_197751_a((double)((float)off.func_82601_c() / (float)te.containedWorld.unitsPerBlock), (double)((float)off.func_96559_d() / (float)te.containedWorld.unitsPerBlock), (double)((float)off.func_82599_e() / (float)te.containedWorld.unitsPerBlock)).func_197751_a((double)((float)(-off.func_82601_c()) * (1.0f / (float)te.containedWorld.unitsPerBlock)), (double)((float)(-off.func_96559_d()) * (1.0f / (float)te.containedWorld.unitsPerBlock)), (double)((float)(-off.func_82599_e()) * (1.0f / (float)te.containedWorld.unitsPerBlock)));
                                        Vec3d posA = ((Vec3d)result.get()).func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                                        posA = new Vec3d((double)((float)((int)(posA.field_72450_a * (double)te.containedWorld.unitsPerBlock)) / (float)te.containedWorld.unitsPerBlock), (double)((float)((int)(posA.field_72448_b * (double)te.containedWorld.unitsPerBlock)) / (float)te.containedWorld.unitsPerBlock), (double)((float)((int)(posA.field_72449_c * (double)te.containedWorld.unitsPerBlock)) / (float)te.containedWorld.unitsPerBlock));
                                        if (off.func_82601_c() != 0) {
                                            posA = new Vec3d(off.func_82601_c() == 1 ? 0.0 : (double)(1.0f - 1.0f / (float)te.containedWorld.unitsPerBlock), posA.field_72448_b, posA.field_72449_c);
                                        } else if (off.func_96559_d() != 0) {
                                            posA = new Vec3d(posA.field_72450_a, off.func_96559_d() == 1 ? 0.0 : (double)(1.0f - 1.0f / (float)te.containedWorld.unitsPerBlock), posA.field_72449_c);
                                        } else if (off.func_82599_e() != 0) {
                                            posA = new Vec3d(posA.field_72450_a, posA.field_72448_b, off.func_82599_e() == 1 ? 0.0 : (double)(1.0f - 1.0f / (float)te.containedWorld.unitsPerBlock));
                                        }
                                        shapeBox = shapeBox.func_197751_a(posA.func_82615_a(), posA.func_82617_b(), posA.func_82616_c());
                                        shapeReturn = VoxelShapes.func_197882_b((VoxelShape)shapeReturn, (VoxelShape)shapeBox, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                                    }
                                    catch (Throwable err) {
                                        err.printStackTrace();
                                    }
                                    return shapeReturn.func_197751_a((double)off.func_82601_c(), (double)off.func_96559_d(), (double)off.func_82599_e());
                                }
                            }
                            catch (Throwable err) {
                                err.printStackTrace();
                            }
                            if (shapeReturn.func_197766_b()) continue;
                            return shapeReturn;
                        }
                        returnVal = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.01, (double)0.01, (double)0.01);
                    }
                }
                return returnVal;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.01, (double)0.01, (double)0.01);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 0;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack value = new ItemStack((IItemProvider)Deferred.UNITITEM.get());
        value.func_196082_o().func_218657_a("BlockEntityTag", (INBT)world.func_175625_s(pos).serializeNBT());
        return value;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof SmallerUnitsTileEntity) {
            ((SmallerUnitsTileEntity)worldIn.func_175625_s((BlockPos)pos)).containedWorld.tick(worldIn);
        }
        worldIn.func_184138_a(pos, state, state, 0);
        worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.EXTREMELY_HIGH);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.EXTREMELY_HIGH);
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, final PlayerEntity player, final Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_184586_b(handIn).func_77973_b().equals(Deferred.UNIT)) {
            return ActionResultType.PASS;
        }
        try {
            BlockPos loc;
            SmallerUnitsTileEntity te;
            block38: {
                te = (SmallerUnitsTileEntity)worldIn.func_175625_s(pos);
                BlockState heldState = Block.func_149634_a((Item)player.func_184586_b(handIn).func_77973_b()).func_176223_P();
                VoxelShape shapeSel = this.getSelectedShape((IBlockReader)worldIn, pos, new ISelectionContext(){

                    public boolean func_225581_b_() {
                        return false;
                    }

                    public boolean func_216378_a(VoxelShape shape, BlockPos pos, boolean p_216378_3_) {
                        return false;
                    }

                    public boolean func_216375_a(Item itemIn) {
                        return player.func_184586_b(handIn).equals(itemIn);
                    }

                    @Nullable
                    public Entity getEntity() {
                        return player;
                    }
                });
                Vec3d blockpos = shapeSel.func_197752_a().func_189972_c().func_186678_a((double)te.containedWorld.unitsPerBlock);
                System.out.println(blockpos);
                loc = new BlockPos(blockpos);
                try {
                    heldState = Block.func_149634_a((Item)player.func_184586_b(handIn).func_77973_b()).getStateForPlacement(heldState, hit.func_216354_b(), heldState, (IWorld)te.containedWorld, new BlockPos(blockpos), loc.func_177972_a(hit.func_216354_b()), handIn);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    ActionResultType type;
                    VoxelShape shape;
                    BlockState clickedState;
                    if (loc.func_177958_n() > te.containedWorld.unitsPerBlock - 1 || blockpos.func_82615_a() <= 0.0) {
                        clickedState = worldIn.func_180495_p(new BlockPos((Vec3i)pos.func_177982_a(loc.func_177958_n() > 1 ? 1 : -1, 0, 0)));
                        loc = loc.func_177958_n() > 1 ? loc.func_177982_a(-1, 0, 0) : loc.func_177982_a(1, 0, 0);
                        shape = clickedState.func_196954_c((IBlockReader)te.containedWorld, loc);
                    } else if (loc.func_177952_p() > te.containedWorld.unitsPerBlock - 1 || blockpos.func_82616_c() <= 0.0) {
                        clickedState = worldIn.func_180495_p(new BlockPos((Vec3i)pos.func_177982_a(0, 0, loc.func_177952_p() > 1 ? 1 : -1)));
                        loc = loc.func_177952_p() > 1 ? loc.func_177982_a(0, 0, -1) : loc.func_177982_a(0, 0, 1);
                        shape = clickedState.func_196954_c((IBlockReader)te.containedWorld, loc);
                    } else if (loc.func_177956_o() > te.containedWorld.unitsPerBlock - 1 || blockpos.func_82617_b() <= 0.0) {
                        clickedState = worldIn.func_180495_p(new BlockPos((Vec3i)pos.func_177982_a(0, loc.func_177956_o() > 1 ? 1 : -1, 0)));
                        loc = loc.func_177956_o() > 1 ? loc.func_177982_a(0, -1, 0) : loc.func_177982_a(0, 1, 0);
                        shape = clickedState.func_196954_c((IBlockReader)te.containedWorld, loc);
                    } else {
                        clickedState = te.containedWorld.func_180495_p(loc);
                        shape = clickedState.func_196954_c((IBlockReader)te.containedWorld, loc);
                    }
                    if (shape.func_197766_b() || !(type = clickedState.func_177230_c().func_225533_a_(clickedState, (World)te.containedWorld, loc, player, handIn, hit)).equals((Object)ActionResultType.FAIL) && !type.equals((Object)ActionResultType.PASS) || Block.func_149634_a((Item)player.func_184586_b(handIn).func_77973_b()).func_176223_P().equals(Blocks.field_150350_a.func_176223_P())) break block38;
                    loc = loc.func_177972_a(hit.func_216354_b());
                    FakePlayer fakePlayer = new FakePlayer(te.containedWorld, player.func_146103_bH());
                    fakePlayer.func_70080_a(player.func_226277_ct_() - (double)pos.func_177958_n(), player.func_226278_cu_() - (double)pos.func_177956_o(), player.func_226281_cx_() - (double)pos.func_177952_p(), player.field_70177_z, player.field_70125_A);
                    fakePlayer.func_70034_d(player.func_70079_am());
                    fakePlayer.func_184611_a(handIn, player.func_184586_b(handIn).func_77946_l());
                    if (player.func_184812_l_()) {
                        fakePlayer.func_71033_a(GameType.CREATIVE);
                    }
                    Vec3d start = player.func_174824_e(0.0f).func_178788_d(player.func_70040_Z().func_186678_a(1.0)).func_178788_d(new Vec3d((Vec3i)pos));
                    Vec3d stop = start.func_178787_e(player.func_70040_Z().func_186678_a(10.0));
                    VoxelShape newShape = null;
                    for (AxisAlignedBB bb : shape.func_197756_d()) {
                        if (newShape == null) {
                            newShape = VoxelShapes.func_197881_a((AxisAlignedBB)bb.func_186664_h((double)te.containedWorld.unitsPerBlock).func_186670_a(loc));
                            continue;
                        }
                        newShape = VoxelShapes.func_197882_b((VoxelShape)newShape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)bb.func_186664_h((double)te.containedWorld.unitsPerBlock).func_186670_a(loc)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                    BlockRayTraceResult result = newShape.func_212433_a(start.func_186678_a((double)te.containedWorld.unitsPerBlock), stop.func_186678_a((double)te.containedWorld.unitsPerBlock), loc.func_177972_a(hit.func_216354_b().func_176734_d()));
                    if (result != null) {
                        try {
                            result = result.func_216351_a(hit.func_216354_b());
                            fakePlayer.func_184586_b(handIn).func_196084_a(new ItemUseContext((PlayerEntity)fakePlayer, handIn, result));
                            if (!player.func_184812_l_()) {
                                player.func_184586_b(handIn).func_190918_g(1);
                            }
                        }
                        catch (Throwable err) {
                            StringBuilder stack = new StringBuilder("\n" + err.toString() + "(" + err.getMessage() + ")");
                            for (StackTraceElement element : err.getStackTrace()) {
                                stack.append(element.toString()).append("\n");
                            }
                            System.out.println(stack.toString());
                            System.out.println(result);
                        }
                    }
                    if (!te.containedWorld.func_180495_p(loc).equals(Blocks.field_150350_a.func_176223_P())) break block38;
                    te.containedWorld.func_175656_a(loc, heldState);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(handIn).func_190918_g(1);
                    }
                }
                catch (Throwable err) {
                    if (Block.func_149634_a((Item)player.func_184586_b(handIn).func_77973_b()).func_176223_P().equals(Blocks.field_150350_a.func_176223_P())) {
                    }
                    BlockState clickedState = te.containedWorld.func_180495_p(loc.func_177972_a(hit.func_216354_b().func_176734_d()));
                    VoxelShape shape = clickedState.func_196954_c((IBlockReader)te.containedWorld, loc.func_177972_a(hit.func_216354_b().func_176734_d()));
                    Vec3d start = player.func_174824_e(0.0f).func_178788_d(new Vec3d((Vec3i)pos));
                    Vec3d stop = start.func_178787_e(player.func_70040_Z().func_186678_a(9.0));
                    BlockRayTraceResult result = shape.func_212433_a(start, stop, loc);
                    try {
                        if (result != null) {
                            player.func_184586_b(handIn).func_196084_a(new ItemUseContext(player, handIn, result));
                            if (!player.func_184812_l_()) {
                                player.func_184586_b(handIn).func_190918_g(1);
                            }
                        } else {
                            te.containedWorld.func_180501_a(loc, heldState.func_196956_a(hit.func_216354_b(), heldState, (IWorld)te.containedWorld, loc, loc), 0);
                            if (!player.func_184812_l_()) {
                                player.func_184586_b(handIn).func_190918_g(1);
                            }
                        }
                    }
                    finally {
                        StringBuilder stack = new StringBuilder("\n" + err.toString() + "(" + err.getMessage() + ")");
                        StackTraceElement[] stackTraceElementArray = err.getStackTrace();
                        int n = stackTraceElementArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                System.out.println(stack.toString());
                            }
                            StackTraceElement element = stackTraceElementArray[n2];
                            stack.append(element.toString()).append("\n");
                            ++n2;
                        }
                    }
                }
            }
            try {
                TileEntity tileEntity = te.containedWorld.func_180495_p(loc).createTileEntity((IBlockReader)te.containedWorld);
                if (tileEntity != null) {
                    if (player.func_184586_b(handIn).func_196082_o().func_74764_b("BlockEntityTag")) {
                        tileEntity.func_145839_a(player.func_184586_b(handIn).func_196082_o().func_74775_l("BlockEntityTag"));
                        tileEntity.func_174878_a(loc);
                    }
                    te.containedWorld.func_175690_a(loc, tileEntity);
                }
            }
            catch (Throwable tileEntity) {
                // empty catch block
            }
            te.func_70296_d();
            worldIn.func_184138_a(pos, state, state, 0);
            return ActionResultType.SUCCESS;
        }
        catch (Throwable err) {
            StringBuilder stack = new StringBuilder("\n" + err.toString() + "(" + err.getMessage() + ")");
            for (StackTraceElement element : err.getStackTrace()) {
                stack.append(element.toString()).append("\n");
            }
            System.out.println(stack.toString());
        }
        return ActionResultType.SUCCESS;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        TileEntity teUncasted = world.func_175625_s(pos);
        if (teUncasted instanceof SmallerUnitsTileEntity) {
            SmallerUnitsTileEntity te = (SmallerUnitsTileEntity)world.func_175625_s(pos);
            if (world.field_72995_K) {
                return false;
            }
            if (te.containedWorld.unitHashMap.isEmpty()) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                if (!player.func_184812_l_()) {
                    ItemStack stack = new ItemStack((IItemProvider)Deferred.UNITITEM.get());
                    if (!stack.func_196082_o().func_74764_b("BlockEntityTag")) {
                        CompoundNBT tag = new CompoundNBT();
                        stack.func_196082_o().func_218657_a("BlockEntityTag", (INBT)tag);
                    }
                    stack.func_196082_o().func_74775_l("BlockEntityTag").func_74778_a("world", "");
                    ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                    world.func_217376_c((Entity)entity);
                }
                return false;
            }
            BlockRayTraceResult hit = this.func_199600_g(state, (IBlockReader)world, pos).func_212433_a(player.func_174824_e(0.0f).func_178788_d(player.func_70040_Z()), player.func_174824_e(0.0f).func_178787_e(player.func_70040_Z().func_186678_a(8.0)), pos);
            Vec3d blockpos = hit.func_216347_e().func_178788_d(new Vec3d((Vec3i)pos)).func_186678_a((double)te.containedWorld.unitsPerBlock);
            if (!hit.func_216354_b().func_176730_m().toString().contains("-")) {
                if (blockpos.func_82617_b() % 1.0 == 0.0) {
                    blockpos = blockpos.func_178786_a(0.0, 1.0, 0.0);
                } else if (blockpos.func_82615_a() % 1.0 == 0.0) {
                    blockpos = blockpos.func_178786_a(1.0, 0.0, 0.0);
                } else if (blockpos.func_82616_c() % 1.0 == 0.0) {
                    blockpos = blockpos.func_178786_a(0.0, 0.0, 1.0);
                }
            }
            BlockPos loc = new BlockPos(blockpos);
            BlockState removed = te.containedWorld.func_180495_p(loc);
            try {
                if (world instanceof ServerWorld) {
                    List stackCollection;
                    ResourceLocation resourcelocation = removed.func_177230_c().func_220068_i();
                    if (resourcelocation == LootTables.field_186419_a) {
                        stackCollection = Collections.emptyList();
                    } else {
                        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)world).func_216015_a(LootParameters.field_216286_f, (Object)pos).func_216015_a(LootParameters.field_216287_g, (Object)state).func_216021_b(LootParameters.field_216288_h, (Object)te.containedWorld.func_175625_s(loc)).func_216021_b(LootParameters.field_216281_a, (Object)player).func_216015_a(LootParameters.field_216289_i, (Object)player.func_184586_b(Hand.MAIN_HAND));
                        LootContext lootcontext = lootcontext$builder.func_216022_a(LootParameterSets.field_216267_h);
                        ServerWorld serverworld = lootcontext.func_202879_g();
                        LootTable loottable = serverworld.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
                        stackCollection = loottable.func_216113_a(lootcontext);
                    }
                    for (ItemStack stack : stackCollection) {
                        if (player.func_184812_l_()) continue;
                        ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                        world.func_217376_c((Entity)entity);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            te.containedWorld.func_180501_a(loc, Blocks.field_150350_a.func_176223_P(), 0);
            world.func_184138_a(pos, state, state, 0);
            return false;
        }
        return true;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new SmallerUnitsTileEntity();
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SmallerUnitsTileEntity();
    }
}

