/*
 * Decompiled with CFR 0.152.
 */
package tfc.smallerunits;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.crash.ReportedException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import tfc.smallerunits.SmallerUnitsTileEntity;
import tfc.smallerunits.utils.SmallUnit;

public class SmallerUnitTESR
extends TileEntityRenderer<SmallerUnitsTileEntity> {
    private static SmallerUnitTESR INSTANCE;

    public SmallerUnitTESR(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        INSTANCE = this;
    }

    public static SmallerUnitTESR getINSTANCE() {
        return INSTANCE;
    }

    public void render(SmallerUnitsTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.func_227860_a_();
        int sc = tileEntityIn.serializeNBT().func_74762_e("upb");
        if (sc == 0) {
            sc = 4;
        }
        int packedlight = combinedLightIn;
        if (tileEntityIn.func_145830_o()) {
            packedlight = tileEntityIn.func_145831_w().func_226658_a_(LightType.SKY, tileEntityIn.func_174877_v()) << 20 | tileEntityIn.func_145831_w().func_226658_a_(LightType.BLOCK, tileEntityIn.func_174877_v()) << 4;
        }
        Collection<SmallUnit> units = tileEntityIn.containedWorld.unitHashMap.values();
        matrixStackIn.func_227862_a_(1.0f / (float)sc, 1.0f / (float)sc, 1.0f / (float)sc);
        for (SmallUnit unit : units) {
            StringBuilder errmsg;
            int light;
            matrixStackIn.func_227860_a_();
            BlockState state = unit.heldState;
            matrixStackIn.func_227861_a_((double)unit.x, (double)unit.y, (double)unit.z);
            int n = light = tileEntityIn.func_145830_o() ? LightTexture.func_228451_a_((int)tileEntityIn.containedWorld.getBlockLightValue(new BlockPos(unit.x, unit.y, unit.z)), (int)tileEntityIn.containedWorld.getSkyLightValue(new BlockPos(unit.x, unit.y, unit.z))) : combinedLightIn;
            if ((state.func_185901_i().equals((Object)BlockRenderType.MODEL) || state.func_185901_i().equals((Object)BlockRenderType.ENTITYBLOCK_ANIMATED) || state.func_185901_i().equals((Object)BlockRenderType.INVISIBLE)) && tileEntityIn.containedWorld.func_175625_s(new BlockPos(unit.x, unit.y, unit.z)) != null) {
                matrixStackIn.func_227860_a_();
                try {
                    TileEntity renderTE = tileEntityIn.containedWorld.func_175625_s(new BlockPos(unit.x, unit.y, unit.z));
                    renderTE.func_226984_a_((World)tileEntityIn.containedWorld, new BlockPos(unit.x, unit.y, unit.z));
                    if (TileEntityRendererDispatcher.field_147556_a.func_147547_b(renderTE) != null) {
                        TileEntityRendererDispatcher.field_147556_a.func_147547_b(renderTE).func_225616_a_(renderTE, partialTicks, matrixStackIn, bufferIn, light, combinedOverlayIn);
                    }
                }
                catch (NullPointerException renderTE) {
                }
                catch (Throwable err) {
                    errmsg = new StringBuilder("\n");
                    errmsg.append(err.toString()).append('\n');
                    for (StackTraceElement stackTraceElement : err.getStackTrace()) {
                        errmsg.append(stackTraceElement.toString()).append('\n');
                    }
                    System.out.println(errmsg.toString());
                }
                matrixStackIn.func_227865_b_();
            }
            try {
                if (state.func_185901_i().equals((Object)BlockRenderType.MODEL)) {
                    ArrayList qds = new ArrayList();
                    IBakedModel mdl = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
                    for (Direction direction : Direction.values()) {
                        if (tileEntityIn.containedWorld.func_180495_p(new BlockPos(unit.x, unit.y, unit.z).func_177972_a(direction)).func_224755_d((IBlockReader)tileEntityIn.containedWorld, new BlockPos(unit.x, unit.y, unit.z).func_177972_a(direction), direction) && RenderTypeLookup.func_228394_b_((BlockState)tileEntityIn.containedWorld.func_180495_p(new BlockPos(unit.x, unit.y, unit.z).func_177972_a(direction))).equals((Object)RenderType.func_228639_c_())) continue;
                        if (RenderTypeLookup.func_228394_b_((BlockState)state).equals((Object)RenderTypeLookup.func_228394_b_((BlockState)tileEntityIn.containedWorld.func_180495_p(new BlockPos(unit.x, unit.y, unit.z).func_177972_a(direction))))) {
                            if (state.equals(tileEntityIn.containedWorld.func_180495_p(new BlockPos(unit.x, unit.y, unit.z).func_177972_a(direction))) || RenderTypeLookup.func_228394_b_((BlockState)state).equals((Object)RenderType.func_228645_f_()) && tileEntityIn.containedWorld.func_180495_p(new BlockPos(unit.x, unit.y, unit.z).func_177972_a(direction)).func_224755_d((IBlockReader)tileEntityIn.containedWorld, new BlockPos(unit.x, unit.y, unit.z).func_177972_a(direction), direction)) continue;
                            qds.addAll(mdl.func_200117_a(state, direction, new Random(new BlockPos(unit.x, unit.y, unit.z).func_218275_a())));
                            continue;
                        }
                        qds.addAll(mdl.func_200117_a(state, direction, new Random(new BlockPos(unit.x, unit.y, unit.z).func_218275_a())));
                    }
                    qds.addAll(mdl.func_200117_a(state, null, new Random(new BlockPos(unit.x, unit.y, unit.z).func_218275_a())));
                    ItemStack itemStack = new ItemStack((IItemProvider)Item.func_150898_a((Block)state.func_177230_c()));
                    boolean flag = !itemStack.func_190926_b();
                    MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
                    for (BakedQuad bakedquad : qds) {
                        int i = -1;
                        if (flag && bakedquad.func_178212_b()) {
                            i = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, (ILightReader)tileEntityIn.containedWorld, new BlockPos(unit.x, unit.y, unit.z), bakedquad.func_178211_c());
                        }
                        float f = (float)(i >> 16 & 0xFF) / 255.0f;
                        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                        float f2 = (float)(i & 0xFF) / 255.0f;
                        bufferIn.getBuffer(RenderTypeLookup.func_228394_b_((BlockState)state)).addVertexData(matrixstack$entry, bakedquad, f, f1, f2, light, combinedOverlayIn, true);
                    }
                    if (tileEntityIn.isEnchanted) {
                        Minecraft.func_71410_x().func_175602_ab().renderModel(state, new BlockPos(unit.x, unit.y, unit.z), (ILightReader)tileEntityIn.containedWorld, matrixStackIn, bufferIn.getBuffer(RenderType.func_228653_j_()), true, new Random(new BlockPos(unit.x, unit.y, unit.z).func_218275_a()), (IModelData)EmptyModelData.INSTANCE);
                    }
                }
            }
            catch (Throwable err) {
                Minecraft.func_71410_x().func_175602_ab().func_228791_a_(state, matrixStackIn, bufferIn, packedlight, combinedOverlayIn);
                if (err instanceof ReportedException) {
                    System.out.println(((ReportedException)err).func_71575_a().func_71502_e());
                }
                errmsg = new StringBuilder("\n");
                errmsg.append(err.toString()).append('\n');
                for (StackTraceElement stackTraceElement : err.getStackTrace()) {
                    errmsg.append(stackTraceElement.toString()).append('\n');
                }
                System.out.println(errmsg.toString());
            }
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            matrixStackIn.func_227860_a_();
            try {
                RenderSystem.enableDepthTest();
                VoxelShape shape = tileEntityIn.func_195044_w().func_177230_c().func_220071_b(tileEntityIn.func_195044_w(), (IBlockReader)tileEntityIn.func_145831_w(), tileEntityIn.func_174877_v(), null);
                for (AxisAlignedBB box : shape.func_197756_d()) {
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStackIn, (IVertexBuilder)bufferIn.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)box, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                shape = tileEntityIn.func_195044_w().func_177230_c().func_220053_a(tileEntityIn.func_195044_w(), (IBlockReader)tileEntityIn.func_145831_w(), tileEntityIn.func_174877_v(), null);
                for (AxisAlignedBB box : shape.func_197756_d()) {
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStackIn, (IVertexBuilder)bufferIn.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)box, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                }
                shape = tileEntityIn.func_195044_w().func_177230_c().func_199600_g(tileEntityIn.func_195044_w(), (IBlockReader)tileEntityIn.func_145831_w(), tileEntityIn.func_174877_v());
                for (AxisAlignedBB box : shape.func_197756_d()) {
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStackIn, (IVertexBuilder)bufferIn.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)box, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                }
                BlockRayTraceResult result = shape.func_212433_a(Minecraft.func_71410_x().field_71439_g.func_174824_e(0.0f), Minecraft.func_71410_x().field_71439_g.func_174824_e(0.0f).func_178787_e(Minecraft.func_71410_x().field_71439_g.func_70040_Z().func_186678_a(9.0)), tileEntityIn.func_174877_v());
                if (result != null) {
                    float size = 0.001f;
                    Vec3d hit = result.func_216347_e();
                    hit = hit.func_178788_d(new Vec3d((Vec3i)tileEntityIn.func_174877_v()));
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStackIn, (IVertexBuilder)bufferIn.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)new AxisAlignedBB(hit.field_72450_a - (double)size, hit.field_72448_b - (double)size, hit.field_72449_c - (double)size, hit.field_72450_a + (double)size, hit.field_72448_b + (double)size, hit.field_72449_c + (double)size), (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                shape = tileEntityIn.func_195044_w().func_177230_c().func_196247_c(tileEntityIn.func_195044_w(), (IBlockReader)tileEntityIn.func_145831_w(), tileEntityIn.func_174877_v());
                for (AxisAlignedBB box : shape.func_197756_d()) {
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStackIn, (IVertexBuilder)bufferIn.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)box, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private static void drawShape(MatrixStack matrixStackIn, IVertexBuilder bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        shapeIn.func_197754_a((p_230013_12_, p_230013_14_, p_230013_16_, p_230013_18_, p_230013_20_, p_230013_22_) -> {
            bufferIn.func_227888_a_(matrix4f, (float)(p_230013_12_ + xIn), (float)(p_230013_14_ + yIn), (float)(p_230013_16_ + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
            bufferIn.func_227888_a_(matrix4f, (float)(p_230013_18_ + xIn), (float)(p_230013_20_ + yIn), (float)(p_230013_22_ + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
    }
}

