/*
 * Decompiled with CFR 0.152.
 */
package tfc.smallerunits.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import tfc.smallerunits.SmallerUnitBlock;
import tfc.smallerunits.SmallerUnitsTileEntity;
import tfc.smallerunits.utils.SmallUnit;

public class FakeWorld
extends World
implements IWorld {
    public HashMap<BlockPos, SmallUnit> unitHashMap = new HashMap();
    public HashMap<BlockPos, SmallUnit> lastUnitsHashMap = new HashMap();
    public int unitsPerBlock;
    public SmallerUnitsTileEntity owner;
    public int time = 0;
    FakeTickList tickList = new FakeTickList(this);
    FakeTickList blockUpdateList = new FakeTickList(this);

    public void func_175690_a(BlockPos pos, @Nullable TileEntity tileEntityIn) {
        if (this.unitHashMap.containsKey(pos)) {
            this.unitHashMap.get((Object)pos).tileEntity = tileEntityIn;
        }
    }

    public void func_184138_a(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        oldState.func_196947_b((World)this, pos, newState, (flags & 4) == 4);
        for (Direction dir : Direction.values()) {
            this.func_180495_p(pos.func_177972_a(dir)).onNeighborChange((IWorldReader)this, pos.func_177972_a(dir), pos);
            this.func_180495_p(pos.func_177972_a(dir)).func_215697_a((World)this, pos.func_177972_a(dir), oldState.func_177230_c(), pos, false);
        }
    }

    public void func_184148_a(@Nullable PlayerEntity player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
    }

    public void func_217384_a(@Nullable PlayerEntity playerIn, Entity entityIn, SoundEvent eventIn, SoundCategory categoryIn, float volume, float pitch) {
    }

    @Nullable
    public Entity func_73045_a(int id) {
        return null;
    }

    @Nullable
    public MapData func_217406_a(String mapName) {
        return null;
    }

    public void func_217399_a(MapData mapDataIn) {
    }

    public int func_217395_y() {
        return 0;
    }

    public void func_175715_c(int breakerId, BlockPos pos, int progress) {
    }

    public Scoreboard func_96441_U() {
        return null;
    }

    public RecipeManager func_199532_z() {
        return null;
    }

    public NetworkTagManager func_205772_D() {
        return null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (SmallUnit unit : this.unitHashMap.values()) {
            str.append(unit.toString()).append(";");
        }
        return str.toString();
    }

    public void fromString(String s) {
        for (String s1 : s.split(";")) {
            SmallUnit unit = SmallUnit.fromString(s1, this.unitsPerBlock);
            if (unit == null) continue;
            this.unitHashMap.put(new BlockPos(unit.x, unit.y, unit.z), unit);
        }
    }

    public IChunk func_217348_a(int chunkX, int chunkZ, ChunkStatus requiredStatus) {
        return this.func_217353_a(chunkX, chunkZ, requiredStatus, false);
    }

    public void tick(ServerWorld realWorld) {
        try {
            ++this.time;
            BlockPos randomPos = new BlockPos(0, 32, 0);
            ServerWorld sworld = realWorld.func_73046_m().func_71218_a(Objects.requireNonNull(DimensionType.func_193417_a((ResourceLocation)new ResourceLocation("smallerunits", "susimulator"))));
            sworld.func_72863_F().func_217205_a(0, 0, true);
            sworld.func_72863_F().func_217205_a(0, -1, true);
            sworld.func_72863_F().func_217205_a(-1, -1, true);
            sworld.func_72863_F().func_217205_a(-1, 0, true);
            for (BlockPos pos : this.lastUnitsHashMap.keySet()) {
                SmallUnit newUnit = this.unitHashMap.containsKey(pos) ? this.unitHashMap.get(pos) : SmallUnit.fromString("0", this.unitsPerBlock);
                sworld.func_180501_a(randomPos.func_177971_a((Vec3i)pos), this.func_180495_p(pos), 64);
                BlockState oldState = this.lastUnitsHashMap.containsKey(pos) ? this.lastUnitsHashMap.get((Object)pos).heldState : Blocks.field_150350_a.func_176223_P();
                BlockState newState = this.func_180495_p(pos);
                if (!oldState.equals(newState)) {
                    int isMoving = newState.func_177230_c() instanceof MovingPistonBlock || oldState.func_177230_c() instanceof MovingPistonBlock ? 1 : 0;
                    this.func_217393_a(randomPos.func_177971_a((Vec3i)pos), oldState, newState);
                    newState.func_215705_a((World)this, pos, oldState, isMoving != 0);
                    newState.onNeighborChange((IWorldReader)this, pos, pos);
                    newState.func_215697_a((World)this, pos, oldState.func_177230_c(), pos, isMoving != 0);
                    for (Direction dir : Direction.values()) {
                        this.func_180495_p(pos.func_177972_a(dir)).func_215697_a((World)this, pos.func_177972_a(dir), newState.func_177230_c(), pos, isMoving != 0);
                        this.func_180495_p(pos.func_177972_a(dir)).onNeighborChange((IWorldReader)this, pos.func_177972_a(dir), pos);
                        this.func_180495_p(pos.func_177972_a(dir)).observedNeighborChange((World)this, pos.func_177972_a(dir), oldState.func_177230_c(), pos);
                    }
                }
                SmallUnit smallUnit = newUnit = this.unitHashMap.containsKey(pos) ? this.unitHashMap.get(pos) : SmallUnit.fromString("0", this.unitsPerBlock);
                if (this.lastUnitsHashMap.containsKey(pos)) {
                    this.lastUnitsHashMap.replace(pos, newUnit);
                    continue;
                }
                this.lastUnitsHashMap.put(pos, newUnit);
            }
            for (BlockPos pos : this.unitHashMap.keySet()) {
                BlockState newState;
                BlockState oldState = this.lastUnitsHashMap.containsKey(pos) ? this.lastUnitsHashMap.get((Object)pos).heldState : Blocks.field_150350_a.func_176223_P();
                if (!oldState.equals(newState = this.func_180495_p(pos))) {
                    sworld.func_180501_a(randomPos.func_177971_a((Vec3i)pos), this.func_180495_p(pos), 64);
                    this.func_217393_a(randomPos.func_177971_a((Vec3i)pos), oldState, newState);
                    newState.func_215705_a((World)this, pos, oldState, false);
                    newState.onNeighborChange((IWorldReader)this, pos, pos);
                    newState.func_215697_a((World)this, pos, oldState.func_177230_c(), pos, false);
                    for (Direction dir : Direction.values()) {
                        this.func_180495_p(pos.func_177972_a(dir)).func_215697_a((World)this, pos.func_177972_a(dir), newState.func_177230_c(), pos, false);
                        this.func_180495_p(pos.func_177972_a(dir)).onNeighborChange((IWorldReader)this, pos.func_177972_a(dir), pos);
                        this.func_180495_p(pos.func_177972_a(dir)).observedNeighborChange((World)this, pos.func_177972_a(dir), oldState.func_177230_c(), pos);
                        if (this.tickList.ticklist.containsKey(pos.func_177972_a(dir))) continue;
                        this.tickList.scheduleTick(pos.func_177972_a(dir), this.func_180495_p(pos.func_177972_a(dir)).func_177230_c(), this.func_180495_p(pos.func_177972_a(dir)).func_177230_c().func_149738_a((IWorldReader)this) / 10);
                    }
                }
                if (this.lastUnitsHashMap.containsKey(pos)) {
                    this.lastUnitsHashMap.replace(pos, this.unitHashMap.get(pos));
                    continue;
                }
                this.lastUnitsHashMap.put(pos, this.unitHashMap.get(pos));
            }
            for (BlockPos pos : this.unitHashMap.keySet()) {
                sworld.func_180501_a(randomPos.func_177971_a((Vec3i)pos), this.func_180495_p(pos), 64);
            }
            MinecraftForge.EVENT_BUS.post((Event)new TickEvent.WorldTickEvent(LogicalSide.SERVER, TickEvent.Phase.START, (World)sworld));
            try {
                for (int x = 0; x < this.unitsPerBlock; ++x) {
                    for (int y = 0; y < this.unitsPerBlock; ++y) {
                        for (int z = 0; z < this.unitsPerBlock; ++z) {
                            TileEntity te;
                            if (!(sworld.func_180495_p(randomPos.func_177982_a(x, y, z)).func_177230_c() instanceof SmallerUnitBlock) && this.tickList.isTickPending(new BlockPos(x, y, z), sworld.func_180495_p(randomPos.func_177982_a(x, y, z)).func_177230_c())) {
                                sworld.func_180495_p(randomPos.func_177982_a(x, y, z)).func_227033_a_(sworld, randomPos.func_177982_a(x, y, z), this.field_73012_v);
                                this.tickList.unscheduleTick(new BlockPos(x, y, z));
                            }
                            if ((te = this.func_175625_s(new BlockPos(x, y, z))) == null) {
                                te = sworld.func_175625_s(randomPos.func_177971_a((Vec3i)new BlockPos(x, y, z)));
                            }
                            this.func_175656_a(new BlockPos(x, y, z), sworld.func_180495_p(randomPos.func_177971_a((Vec3i)new BlockPos(x, y, z))));
                            if (te != null) {
                                te.func_226984_a_((World)this, new BlockPos(x, y, z));
                                if (te instanceof ITickableTileEntity) {
                                    ((ITickableTileEntity)te).func_73660_a();
                                }
                            }
                            this.func_175690_a(new BlockPos(x, y, z), te);
                            if (te != null) {
                                te.func_226984_a_((World)sworld, new BlockPos(x, y, z));
                            }
                            sworld.func_180501_a(randomPos.func_177982_a(x, y, z), this.func_180495_p(new BlockPos(x, y, z)), 64);
                            for (Direction dir : Direction.values()) {
                                sworld.func_180501_a(randomPos.func_177982_a(x, y, z).func_177972_a(dir), this.func_180495_p(new BlockPos(x, y, z).func_177972_a(dir)), 64);
                            }
                        }
                    }
                }
            }
            catch (Throwable err) {
                StringBuilder stack = new StringBuilder("\n" + err.toString() + "(" + err.getMessage() + ")");
                for (StackTraceElement element : err.getStackTrace()) {
                    stack.append(element.toString()).append("\n");
                }
                System.out.println(stack.toString());
            }
            MinecraftForge.EVENT_BUS.post((Event)new TickEvent.WorldTickEvent(LogicalSide.SERVER, TickEvent.Phase.END, (World)sworld));
            for (BlockPos pos : this.lastUnitsHashMap.keySet()) {
                if (sworld.func_180495_p(pos) != Blocks.field_150350_a.func_176223_P()) {
                    this.func_175656_a(pos, sworld.func_180495_p(randomPos.func_177971_a((Vec3i)pos)));
                }
                sworld.func_180501_a(randomPos.func_177971_a((Vec3i)pos), Blocks.field_150350_a.func_176223_P(), 64);
                sworld.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)(randomPos.func_177958_n() + pos.func_177958_n()), (double)(randomPos.func_177956_o() + pos.func_177956_o()), (double)(randomPos.func_177952_p() + pos.func_177952_p()), (double)(randomPos.func_177958_n() + pos.func_177958_n() + 1), (double)(randomPos.func_177956_o() + pos.func_177956_o() + 1), (double)(randomPos.func_177952_p() + pos.func_177952_p() + 1))).forEach(e -> e.func_70106_y());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public List<Entity> func_72839_b(@Nullable Entity entityIn, AxisAlignedBB bb) {
        return ImmutableList.of();
    }

    public Biome func_226691_t_(BlockPos p_226691_1_) {
        return Biomes.field_185440_P;
    }

    public int func_217298_h(BlockPos pos) {
        return this.func_201696_r(pos);
    }

    public int getSkyLightValue(BlockPos pos) {
        return this.owner.func_145831_w() != null ? this.owner.func_145831_w().func_226658_a_(LightType.SKY, this.owner.func_174877_v()) : 15;
    }

    public int getBlockLightValue(BlockPos pos) {
        float light = 15.0f;
        BlockPos pos1 = this.owner.func_174877_v();
        if (this.owner.func_145831_w() != null) {
            light = 0.0f;
            for (Direction dir : Direction.values()) {
                light = Math.max(light, (float)this.owner.func_145831_w().func_226658_a_(LightType.BLOCK, pos1.func_177972_a(dir)));
            }
        }
        return (int)light;
    }

    public float func_72826_c(float partialTicks) {
        return this.owner.func_145831_w().func_72826_c(partialTicks);
    }

    public int func_201572_C() {
        return this.owner.func_145831_w() != null ? this.owner.func_145831_w().func_201572_C() : 15;
    }

    public int func_201696_r(BlockPos pos) {
        return this.func_226658_a_(LightType.BLOCK, pos) | this.func_226658_a_(LightType.SKY, pos);
    }

    public int func_205049_d(BlockPos pos, int amount) {
        return this.func_201696_r(pos) - amount;
    }

    public int func_226658_a_(LightType lightTypeIn, BlockPos blockPosIn) {
        return this.owner.func_145831_w() != null ? (lightTypeIn.equals((Object)LightType.SKY) ? this.getSkyLightValue(blockPosIn) : this.getBlockLightValue(blockPosIn)) : 15;
    }

    public int func_226659_b_(BlockPos blockPosIn, int amount) {
        return this.func_201696_r(blockPosIn) - amount;
    }

    public <T extends Entity> List<T> func_217394_a(@Nullable EntityType<T> type, AxisAlignedBB boundingBox, Predicate<? super T> predicate) {
        return this.owner.func_145831_w().func_217394_a(type, boundingBox.func_186664_h((double)this.unitsPerBlock).func_186670_a(this.owner.func_174877_v()), predicate);
    }

    public <T extends Entity> List<T> func_217357_a(Class<? extends T> p_217357_1_, AxisAlignedBB p_217357_2_) {
        return this.owner.func_145831_w().func_217357_a(p_217357_1_, p_217357_2_.func_186664_h((double)this.unitsPerBlock).func_186670_a(this.owner.func_174877_v()));
    }

    public void func_217391_K() {
        super.func_217391_K();
    }

    public boolean func_175700_a(TileEntity tile) {
        this.unitHashMap.get((Object)tile.func_174877_v()).tileEntity = tile;
        return true;
    }

    public void func_147448_a(Collection<TileEntity> tileEntityCollection) {
        tileEntityCollection.forEach(tile -> {
            this.unitHashMap.get((Object)tile.func_174877_v()).tileEntity = tile;
        });
    }

    public void func_175713_t(BlockPos pos) {
        this.unitHashMap.get((Object)pos).tileEntity = null;
    }

    public FakeWorld(int unitsPerBlock, SmallerUnitsTileEntity owner) {
        super(new WorldInfo(){}, DimensionType.field_223227_a_, (world, dimension) -> null, new IProfiler(){

            public void func_219894_a() {
            }

            public void func_219897_b() {
            }

            public void func_76320_a(String name) {
            }

            public void func_194340_a(Supplier<String> nameSupplier) {
            }

            public void func_76319_b() {
            }

            public void func_219895_b(String name) {
            }

            public void func_194339_b(Supplier<String> nameSupplier) {
            }

            public void func_230035_c_(String p_230035_1_) {
            }

            public void func_230036_c_(Supplier<String> p_230036_1_) {
            }
        }, false);
        this.unitsPerBlock = unitsPerBlock;
        this.owner = owner;
    }

    public long func_72905_C() {
        return 0L;
    }

    public ITickList<Block> func_205220_G_() {
        return this.tickList;
    }

    public ITickList<Fluid> func_205219_F_() {
        return null;
    }

    public World func_201672_e() {
        return this;
    }

    public WorldInfo func_72912_H() {
        return new WorldInfo(){};
    }

    public DifficultyInstance func_175649_E(BlockPos pos) {
        return new DifficultyInstance(Difficulty.EASY, 0L, 0L, (float)this.func_72853_d());
    }

    public AbstractChunkProvider func_72863_F() {
        return null;
    }

    public Random func_201674_k() {
        return new Random();
    }

    public void func_195592_c(BlockPos pos, Block blockIn) {
        for (Direction dir : Direction.values()) {
            this.func_180495_p(pos.func_177972_a(dir)).onNeighborChange((IWorldReader)this, pos.func_177972_a(dir), pos);
            this.func_180495_p(pos.func_177972_a(dir)).func_215697_a((World)this, pos.func_177972_a(dir), blockIn, pos, false);
        }
    }

    public BlockPos func_175694_M() {
        return new BlockPos(0, 0, 0);
    }

    public void func_184133_a(@Nullable PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        try {
            player.field_70170_p.func_184133_a(player, pos, soundIn, category, volume, pitch);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void func_217378_a(@Nullable PlayerEntity player, int type, BlockPos pos, int data) {
        try {
            player.field_70170_p.func_217378_a(player, type, pos, data);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public WorldBorder func_175723_af() {
        WorldBorder border = new WorldBorder();
        border.func_177739_c((double)((float)this.unitsPerBlock / 2.0f), (double)((float)this.unitsPerBlock / 2.0f));
        border.func_177725_a(this.unitsPerBlock * 2);
        return border;
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        if (this.unitHashMap.containsKey(pos)) {
            return this.unitHashMap.get((Object)pos).tileEntity;
        }
        return null;
    }

    public BlockState func_180495_p(BlockPos pos) {
        if (this.unitHashMap.containsKey(pos)) {
            return this.unitHashMap.get((Object)pos).heldState;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void markAndNotifyBlock(BlockPos pos, @Nullable Chunk chunk, BlockState blockstate, BlockState newState, int flags) {
        super.markAndNotifyBlock(pos, chunk, blockstate, newState, flags);
    }

    public void func_195593_d(BlockPos pos, Block blockIn) {
        for (Direction dir : Direction.values()) {
            this.func_180495_p(pos.func_177972_a(dir)).onNeighborChange((IWorldReader)this, pos.func_177972_a(dir), pos);
            this.func_180495_p(pos.func_177972_a(dir)).func_215697_a((World)this, pos.func_177972_a(dir), blockIn, pos, false);
        }
    }

    public void func_175695_a(BlockPos pos, Block blockType, Direction skipSide) {
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)skipSide)) continue;
            this.func_180495_p(pos.func_177972_a(dir)).onNeighborChange((IWorldReader)this, pos.func_177972_a(dir), pos);
            this.func_180495_p(pos.func_177972_a(dir)).func_215697_a((World)this, pos.func_177972_a(dir), blockType, pos, false);
        }
    }

    public IFluidState func_204610_c(BlockPos pos) {
        if (this.unitHashMap.containsKey(pos)) {
            return this.unitHashMap.get((Object)pos).heldState.func_204520_s();
        }
        return Blocks.field_150355_j.func_176223_P().func_204520_s();
    }

    public boolean func_195585_a(@Nullable Entity entityIn, VoxelShape shape) {
        return true;
    }

    public boolean func_226668_i_(Entity p_226668_1_) {
        return true;
    }

    public List<Entity> func_175674_a(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        return null;
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        return null;
    }

    public List<? extends PlayerEntity> func_217369_A() {
        return null;
    }

    @Nullable
    public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        final FakeWorld world = this;
        return new IChunk(){

            @Nullable
            public BlockState func_177436_a(BlockPos pos, BlockState state, boolean isMoving) {
                SmallUnit unit = new SmallUnit(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), FakeWorld.this.unitsPerBlock, state);
                try {
                    if (world.func_175625_s(pos) != null) {
                        unit.tileEntity = world.func_175625_s(pos);
                    }
                    try {
                        this.func_180495_p(pos).func_196947_b(world, pos, state, false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (FakeWorld.this.unitHashMap.containsKey(pos)) {
                        FakeWorld.this.unitHashMap.replace(pos, unit);
                    } else {
                        FakeWorld.this.unitHashMap.put(pos, unit);
                    }
                    if (state.equals(Blocks.field_150350_a.func_176223_P())) {
                        FakeWorld.this.unitHashMap.remove(pos);
                    }
                    for (Direction dir : Direction.values()) {
                        this.func_180495_p(pos.func_177972_a(dir)).onNeighborChange((IWorldReader)world, pos.func_177972_a(dir), pos);
                        this.func_180495_p(pos.func_177972_a(dir)).observedNeighborChange(world, pos.func_177972_a(dir), this.func_180495_p(pos).func_177230_c(), pos);
                    }
                }
                catch (Throwable err) {
                    StringBuilder stack = new StringBuilder("\n" + err.toString() + "(" + err.getMessage() + ")");
                    for (StackTraceElement element : err.getStackTrace()) {
                        stack.append(element.toString()).append("\n");
                    }
                    System.out.println(stack.toString());
                }
                state.func_215705_a(world, pos, state, isMoving);
                return state;
            }

            public void func_177426_a(BlockPos pos, TileEntity tileEntityIn) {
                FakeWorld.this.unitHashMap.get((Object)pos).tileEntity = tileEntityIn;
            }

            public void func_76612_a(Entity entityIn) {
            }

            public Set<BlockPos> func_203066_o() {
                ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
                for (SmallUnit unit : FakeWorld.this.unitHashMap.values()) {
                    if (unit.tileEntity == null) continue;
                    poses.add(new BlockPos(unit.x, unit.y, unit.z));
                }
                return ImmutableSet.copyOf(poses);
            }

            public ChunkSection[] func_76587_i() {
                return new ChunkSection[0];
            }

            public Collection<Map.Entry<Heightmap.Type, Heightmap>> func_217311_f() {
                return null;
            }

            public void func_201607_a(Heightmap.Type type, long[] data) {
            }

            public Heightmap func_217303_b(Heightmap.Type typeIn) {
                return null;
            }

            public int func_201576_a(Heightmap.Type heightmapType, int x, int z) {
                return 0;
            }

            public ChunkPos func_76632_l() {
                return new ChunkPos(0, 0);
            }

            public void func_177432_b(long saveTime) {
            }

            public Map<String, StructureStart> func_201609_c() {
                return null;
            }

            public void func_201612_a(Map<String, StructureStart> structureStartsIn) {
            }

            @Nullable
            public BiomeContainer func_225549_i_() {
                return null;
            }

            public void func_177427_f(boolean modified) {
            }

            public boolean func_201593_f() {
                return false;
            }

            public ChunkStatus func_201589_g() {
                return null;
            }

            public void func_177425_e(BlockPos pos) {
                FakeWorld.this.unitHashMap.get((Object)pos).tileEntity = null;
            }

            public ShortList[] func_201614_D() {
                return new ShortList[0];
            }

            @Nullable
            public CompoundNBT func_201579_g(BlockPos pos) {
                return FakeWorld.this.unitHashMap.get((Object)pos).tileEntity.serializeNBT();
            }

            @Nullable
            public CompoundNBT func_223134_j(BlockPos pos) {
                return FakeWorld.this.unitHashMap.get((Object)pos).tileEntity.serializeNBT();
            }

            public Stream<BlockPos> func_217304_m() {
                return null;
            }

            public ITickList<Block> func_205218_i_() {
                return world.func_205220_G_();
            }

            public ITickList<Fluid> func_212247_j() {
                return null;
            }

            public UpgradeData func_196966_y() {
                return null;
            }

            public void func_177415_c(long newInhabitedTime) {
            }

            public long func_177416_w() {
                return 0L;
            }

            public boolean func_217310_r() {
                return false;
            }

            public void func_217305_b(boolean lightCorrectIn) {
            }

            @Nullable
            public TileEntity func_175625_s(BlockPos pos) {
                return FakeWorld.this.unitHashMap.get((Object)pos).tileEntity;
            }

            public BlockState func_180495_p(BlockPos pos) {
                if (FakeWorld.this.unitHashMap.containsKey(pos)) {
                    return FakeWorld.this.unitHashMap.get((Object)pos).heldState;
                }
                return Blocks.field_150350_a.func_176223_P();
            }

            public IFluidState func_204610_c(BlockPos pos) {
                return FakeWorld.this.unitHashMap.get((Object)pos).heldState.func_204520_s();
            }

            @Nullable
            public StructureStart func_201585_a(String stucture) {
                return null;
            }

            public void func_201584_a(String structureIn, StructureStart structureStartIn) {
            }

            public LongSet func_201578_b(String structureIn) {
                return null;
            }

            public void func_201583_a(String strucutre, long reference) {
            }

            public Map<String, LongSet> func_201604_d() {
                return null;
            }

            public void func_201606_b(Map<String, LongSet> p_201606_1_) {
            }
        };
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return 0;
    }

    public int func_175657_ab() {
        return this.func_201572_C();
    }

    public BiomeManager func_225523_d_() {
        return null;
    }

    public Biome func_225604_a_(int x, int y, int z) {
        return null;
    }

    public boolean func_201670_d() {
        try {
            return Minecraft.func_71410_x().field_71441_e.field_72995_K;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int func_181545_F() {
        return 0;
    }

    public Dimension func_201675_m() {
        return null;
    }

    public WorldLightManager func_225524_e_() {
        return null;
    }

    public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
        this.func_217353_a(0, 0, null, true).func_177436_a(pos, newState, false);
        return true;
    }

    public boolean func_217377_a(BlockPos pos, boolean isMoving) {
        for (Direction dir : Direction.values()) {
            this.func_180495_p(pos.func_177972_a(dir)).onNeighborChange((IWorldReader)this, pos.func_177972_a(dir), pos);
            this.func_180495_p(pos.func_177972_a(dir)).func_215697_a((World)this, pos.func_177972_a(dir), this.func_180495_p(pos).func_177230_c(), pos, false);
        }
        this.unitHashMap.remove(pos);
        return true;
    }

    public boolean func_225521_a_(BlockPos p_225521_1_, boolean p_225521_2_, @Nullable Entity p_225521_3_) {
        this.unitHashMap.remove(p_225521_1_);
        for (Direction dir : Direction.values()) {
            this.func_180495_p(p_225521_1_.func_177972_a(dir)).onNeighborChange((IWorldReader)this, p_225521_1_.func_177972_a(dir), p_225521_1_);
            this.func_180495_p(p_225521_1_.func_177972_a(dir)).func_215697_a((World)this, p_225521_1_.func_177972_a(dir), this.func_180495_p(p_225521_1_).func_177230_c(), p_225521_1_, false);
        }
        return true;
    }

    public boolean func_217375_a(BlockPos p_217375_1_, Predicate<BlockState> p_217375_2_) {
        return p_217375_2_.test(this.func_180495_p(p_217375_1_));
    }

    public static class FakeTickList
    implements ITickList<Block> {
        public HashMap<BlockPos, Long> ticklist = new HashMap();
        public ArrayList<BlockPos> updatorlist = new ArrayList();
        public HashMap<BlockPos, Block> blocklist = new HashMap();
        FakeWorld world;

        public FakeTickList(FakeWorld world) {
            this.world = world;
        }

        public boolean isTickScheduled(BlockPos pos, Block itemIn) {
            if (this.blocklist.containsKey(pos) && this.blocklist.get(pos).equals(itemIn)) {
                return this.ticklist.containsKey(pos);
            }
            return false;
        }

        public void scheduleTick(BlockPos pos, Block itemIn, int scheduledTime, TickPriority priority) {
            if (!itemIn.func_176223_P().func_196958_f()) {
                this.ticklist.put(pos, (long)this.world.time + (long)scheduledTime);
                this.blocklist.put(pos, itemIn);
            }
        }

        public void unscheduleTick(BlockPos pos) {
            try {
                while (this.ticklist.containsKey(pos)) {
                    this.ticklist.remove(pos);
                }
                while (this.blocklist.containsKey(pos)) {
                    this.blocklist.remove(pos);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void addBlockUpdate(BlockPos pos, BlockPos source) {
            this.scheduleTick(pos, Blocks.field_150346_d, 0);
            this.updatorlist.add(source);
        }

        public void scheduleTick(BlockPos pos, Block itemIn, int scheduledTime) {
            this.scheduleTick(pos, itemIn, scheduledTime, TickPriority.NORMAL);
        }

        public boolean isTickPending(BlockPos pos, Block obj) {
            return this.ticklist.containsKey(pos) && this.ticklist.get(pos).intValue() <= this.world.time;
        }

        public void func_219497_a(Stream<NextTickListEntry<Block>> p_219497_1_) {
            p_219497_1_.forEach(nextTickListEntry -> {
                this.ticklist.put(nextTickListEntry.field_180282_a, nextTickListEntry.field_77180_e);
                this.blocklist.put(nextTickListEntry.field_180282_a, (Block)nextTickListEntry.func_151351_a());
            });
        }
    }
}

