/*
 * Decompiled with CFR 0.152.
 */
package com.tfc.smallerunits;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import com.tfc.smallerunits.block.SmallerUnitBlock;
import com.tfc.smallerunits.block.UnitTileEntity;
import com.tfc.smallerunits.utils.SmallUnit;
import com.tfc.smallerunits.utils.rendering.CustomBuffer;
import com.tfc.smallerunits.utils.rendering.SUPseudoVBO;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmallerUnitsTESR
extends TileEntityRenderer<UnitTileEntity> {
    public static final Object2ObjectLinkedOpenHashMap<BlockPos, VertexBuffer> bufferCache1 = new Object2ObjectLinkedOpenHashMap();
    public static final Object2ObjectLinkedOpenHashMap<BlockPos, Pair<CompoundNBT, SUPseudoVBO>> bufferCache = new Object2ObjectLinkedOpenHashMap();
    private static final Quaternion quat90X = new Quaternion(90.0f, 0.0f, 0.0f, true);
    private static final Quaternion quat180X = new Quaternion(180.0f, 0.0f, 0.0f, true);
    private static final Quaternion quat90Y = new Quaternion(0.0f, 90.0f, 0.0f, true);
    private int lastGameTime = 0;
    public static final Logger LOGGER = LogManager.getLogger();

    public SmallerUnitsTESR(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public static void renderCube(float r, float g, float b, float x, float y, float z, IVertexBuilder builder, int combinedOverlay, int combinedLight, MatrixStack matrixStack, boolean useNormals) {
        SmallerUnitsTESR.renderSquare(r, g, b, x, y, z + 0.25f, builder, combinedOverlay, combinedLight, matrixStack, useNormals);
        matrixStack.func_227863_a_(quat90Y);
        SmallerUnitsTESR.renderSquare(r, g, b, x - 0.25f, y, z + 0.25f, builder, combinedOverlay, combinedLight, matrixStack, useNormals);
        matrixStack.func_227863_a_(quat90Y);
        SmallerUnitsTESR.renderSquare(r, g, b, -0.25f, 0.0f, 0.0f, builder, combinedOverlay, combinedLight, matrixStack, useNormals);
        matrixStack.func_227863_a_(quat90Y);
        SmallerUnitsTESR.renderSquare(r, g, b, 0.0f, 0.0f, 0.0f, builder, combinedOverlay, combinedLight, matrixStack, useNormals);
        matrixStack.func_227863_a_(quat90X);
        SmallerUnitsTESR.renderSquare(r, g, b, 0.0f, -0.25f, 0.0f, builder, combinedOverlay, combinedLight, matrixStack, useNormals);
        matrixStack.func_227863_a_(quat180X);
        SmallerUnitsTESR.renderSquare(r, g, b, 0.0f, 0.0f, 0.25f, builder, combinedOverlay, combinedLight, matrixStack, useNormals);
    }

    public static void renderSquare(float r, float g, float b, float x, float y, float z, IVertexBuilder builder, int combinedOverlay, int combinedLight, MatrixStack matrixStack, boolean useNormals) {
        Vector3f normal;
        Vector3f corner1 = SmallerUnitsTESR.translate(matrixStack, x, y, z);
        Vector3f corner2 = SmallerUnitsTESR.translate(matrixStack, x + 0.25f, y, z);
        Vector3f corner3 = SmallerUnitsTESR.translate(matrixStack, x + 0.25f, y + 0.25f, z);
        Vector3f corner4 = SmallerUnitsTESR.translate(matrixStack, x, y + 0.25f, z);
        if (useNormals) {
            Vector3f normalU = new Vector3f(x, y, z);
            Vector3f normalV = normalU.func_229195_e_();
            normalU.func_195897_a(new Vector3f(x + 0.25f, y, z));
            normalV.func_195897_a(new Vector3f(x + 0.25f, y + 0.25f, z));
            normal = new Vector3f(normalU.func_195900_b() * normalV.func_195902_c() - normalU.func_195902_c() * normalV.func_195900_b(), normalU.func_195902_c() * normalV.func_195899_a() - normalU.func_195899_a() * normalV.func_195902_c(), normalU.func_195899_a() * normalV.func_195900_b() - normalU.func_195900_b() * normalV.func_195899_a());
            Matrix3f matrix3f = matrixStack.func_227866_c_().func_227872_b_();
            normal.func_229188_a_(matrix3f);
            normal.func_229194_d_();
        } else {
            normal = new Vector3f(0.0f, 1.0f, 0.0f);
        }
        builder.func_225588_a_(corner1.func_195899_a(), corner1.func_195900_b(), corner1.func_195902_c(), r, g, b, 1.0f, 0.0f, 0.0f, combinedOverlay, combinedLight, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
        builder.func_225588_a_(corner2.func_195899_a(), corner2.func_195900_b(), corner2.func_195902_c(), r, g, b, 1.0f, 0.0f, 0.0f, combinedOverlay, combinedLight, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
        builder.func_225588_a_(corner3.func_195899_a(), corner3.func_195900_b(), corner3.func_195902_c(), r, g, b, 1.0f, 0.0f, 0.0f, combinedOverlay, combinedLight, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
        builder.func_225588_a_(corner4.func_195899_a(), corner4.func_195900_b(), corner4.func_195902_c(), r, g, b, 1.0f, 0.0f, 0.0f, combinedOverlay, combinedLight, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
    }

    public static Vector3f translate(MatrixStack stack, float x, float y, float z) {
        Vector4f vector4f = new Vector4f(x, y, z, 1.0f);
        vector4f.func_229372_a_(stack.func_227866_c_().func_227870_a_());
        return new Vector3f(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c());
    }

    public void render(UnitTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        CompoundNBT nbt = tileEntityIn.serializeNBT();
        nbt.func_82580_o("x");
        nbt.func_82580_o("y");
        nbt.func_82580_o("z");
        nbt.func_82580_o("id");
        nbt.func_82580_o("ForgeData");
        nbt.func_82580_o("ForgeCaps");
        nbt.func_82580_o("ticks");
        for (Direction dir : Direction.values()) {
            TileEntity otherTE;
            BlockState state = tileEntityIn.func_145831_w().func_180495_p(tileEntityIn.func_174877_v().func_177972_a(dir));
            boolean isAir = state.isAir((IBlockReader)tileEntityIn.func_145831_w(), tileEntityIn.func_174877_v().func_177972_a(dir));
            boolean isUnit = state.func_177230_c() instanceof SmallerUnitBlock;
            int scale = 0;
            if (isUnit && (otherTE = tileEntityIn.func_145831_w().func_175625_s(tileEntityIn.func_174877_v().func_177972_a(dir))) instanceof UnitTileEntity) {
                scale = ((UnitTileEntity)otherTE).unitsPerBlock;
            }
            nbt.func_74778_a(dir.toString(), isAir ? "air" : (isUnit ? "unit" + scale : "obstructed"));
        }
        tileEntityIn.field_145850_b.lightManager.func_215575_a(100, true, true);
        if (!bufferCache.containsKey((Object)tileEntityIn.func_174877_v()) || !((CompoundNBT)((Pair)bufferCache.get((Object)tileEntityIn.func_174877_v())).getFirst()).equals((Object)nbt)) {
            bufferCache.remove((Object)tileEntityIn.func_174877_v());
            tileEntityIn.field_145850_b.isRendering = true;
            CustomBuffer customBuffer = new CustomBuffer();
            MatrixStack src = matrixStackIn;
            matrixStackIn = new MatrixStack();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227866_c_().func_227872_b_().func_226114_a_(new Matrix3f(new Quaternion(1.0f, 0.0f, 0.0f, 0.0f)));
            matrixStackIn.func_227862_a_(1.0f / (float)tileEntityIn.unitsPerBlock, 1.0f / (float)tileEntityIn.unitsPerBlock, 1.0f / (float)tileEntityIn.unitsPerBlock);
            matrixStackIn.func_227861_a_(0.0, -64.0, 0.0);
            for (SmallUnit value : tileEntityIn.field_145850_b.blockMap.values()) {
                customBuffer.pos = value.pos;
                RenderType type = RenderType.func_228639_c_();
                for (RenderType blockRenderType : RenderType.func_228661_n_()) {
                    if (!RenderTypeLookup.canRenderInLayer((BlockState)value.state, (RenderType)blockRenderType)) continue;
                    type = blockRenderType;
                }
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_((double)value.pos.func_177958_n(), (double)value.pos.func_177956_o(), (double)value.pos.func_177952_p());
                if (value.state.func_185901_i().equals((Object)BlockRenderType.MODEL)) {
                    IVertexBuilder builder = customBuffer.getBuffer(type);
                    if (Minecraft.func_71410_x().field_71474_y.field_74348_k.equals((Object)AmbientOcclusionStatus.MAX)) {
                        Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModelSmooth((IBlockDisplayReader)tileEntityIn.field_145850_b, Minecraft.func_71410_x().func_175602_ab().func_184389_a(value.state), value.state, value.pos, matrixStackIn, builder, true, new Random(value.pos.func_218275_a()), value.pos.func_218275_a(), combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
                    } else {
                        Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModelFlat((IBlockDisplayReader)tileEntityIn.field_145850_b, Minecraft.func_71410_x().func_175602_ab().func_184389_a(value.state), value.state, value.pos, matrixStackIn, builder, true, new Random(value.pos.func_218275_a()), value.pos.func_218275_a(), combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
                    }
                }
                if (!value.state.func_204520_s().func_206888_e()) {
                    RenderType type1 = RenderTypeLookup.func_228391_a_((FluidState)value.state.func_204520_s());
                    CustomBuffer.CustomVertexBuilder builder1 = (CustomBuffer.CustomVertexBuilder)customBuffer.getBuffer(type1);
                    try {
                        matrixStackIn.func_227860_a_();
                        builder1.matrix = matrixStackIn;
                        Minecraft.func_71410_x().func_175602_ab().field_175025_e.func_228796_a_((IBlockDisplayReader)tileEntityIn.field_145850_b, value.pos, (IVertexBuilder)builder1, value.state.func_204520_s());
                        matrixStackIn.func_227865_b_();
                        builder1.matrix = null;
                    }
                    catch (Throwable ignored) {
                        StringBuilder builder2 = new StringBuilder(ignored.toString()).append("\n");
                        StackTraceElement[] stackTraceElementArray = ignored.getStackTrace();
                        int n = stackTraceElementArray.length;
                        for (int i = 0; i < n; ++i) {
                            StackTraceElement element = stackTraceElementArray[i];
                            builder2.append(element.toString()).append("\n");
                        }
                        System.out.println(builder2.toString());
                    }
                }
                matrixStackIn.func_227865_b_();
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn = src;
            SUPseudoVBO vbo = new SUPseudoVBO(customBuffer);
            vbo.render(bufferIn, matrixStackIn, combinedLightIn, combinedOverlayIn, tileEntityIn.field_145850_b);
            bufferCache.put((Object)tileEntityIn.func_174877_v(), (Object)Pair.of((Object)nbt, (Object)vbo));
            tileEntityIn.field_145850_b.isRendering = false;
        } else {
            ((SUPseudoVBO)((Pair)bufferCache.get((Object)tileEntityIn.func_174877_v())).getSecond()).render(bufferIn, matrixStackIn, combinedLightIn, combinedOverlayIn, tileEntityIn.field_145850_b);
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(1.0f / (float)tileEntityIn.unitsPerBlock, 1.0f / (float)tileEntityIn.unitsPerBlock, 1.0f / (float)tileEntityIn.unitsPerBlock);
        for (SmallUnit value : tileEntityIn.field_145850_b.blockMap.values()) {
            if (value.tileEntity == null) continue;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)value.pos.func_177958_n(), (double)(value.pos.func_177956_o() - 64), (double)value.pos.func_177952_p());
            TileEntity tileEntity = value.tileEntity;
            TileEntityRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity);
            int matrixSize = matrixStackIn.field_227859_a_.size();
            boolean isExceptionPresent = false;
            String exceptionAt = "";
            if (renderer != null) {
                try {
                    renderer.func_225616_a_(tileEntity, partialTicks, matrixStackIn, bufferIn, LightTexture.func_228451_a_((int)tileEntityIn.field_145850_b.func_226658_a_(LightType.BLOCK, value.pos), (int)tileEntityIn.field_145850_b.func_226658_a_(LightType.SKY, value.pos)), combinedOverlayIn);
                }
                catch (Throwable ignored) {
                    isExceptionPresent = true;
                    for (StackTraceElement element : ignored.getStackTrace()) {
                        if (!element.getClassName().equals(renderer.getClass().getName())) continue;
                        exceptionAt = element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")";
                    }
                }
            }
            if (matrixSize != matrixStackIn.field_227859_a_.size()) {
                LOGGER.log(Level.WARN, "What's going on? Tile Entity renderer for " + tileEntity.func_200662_C().getRegistryName() + " missed " + (matrixStackIn.field_227859_a_.size() - matrixSize) + " pops." + (isExceptionPresent ? " An exception was thrown:\n" + exceptionAt : " No exceptions were found."));
            }
            while (matrixStackIn.field_227859_a_.size() != matrixSize) {
                matrixStackIn.func_227865_b_();
            }
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
        if (tileEntityIn.field_145850_b.blockMap.isEmpty()) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(4.0f, 4.0f, 4.0f);
            RenderSystem.disableTexture();
            matrixStackIn.func_227862_a_(1.0f / (float)tileEntityIn.unitsPerBlock, 1.0f / (float)tileEntityIn.unitsPerBlock, 1.0f / (float)tileEntityIn.unitsPerBlock);
            this.renderHalf(matrixStackIn, bufferIn, combinedOverlayIn, combinedLightIn, tileEntityIn);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)((float)tileEntityIn.unitsPerBlock / 4.0f), 0.0, (double)((float)tileEntityIn.unitsPerBlock / 4.0f));
            matrixStackIn.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
            this.renderHalf(matrixStackIn, bufferIn, combinedOverlayIn, combinedLightIn, tileEntityIn);
            matrixStackIn.func_227865_b_();
            RenderSystem.enableTexture();
            matrixStackIn.func_227865_b_();
        }
    }

    public void renderHalf(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedOverlayIn, int combinedLightIn, UnitTileEntity tileEntityIn) {
        if (tileEntityIn.isNatural) {
            return;
        }
        this.renderCorner(matrixStackIn, bufferIn, combinedOverlayIn, combinedLightIn);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)((float)tileEntityIn.unitsPerBlock / 4.0f), 0.0);
        matrixStackIn.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
        this.renderCorner(matrixStackIn, bufferIn, combinedOverlayIn, combinedLightIn);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 0.0, (double)((float)tileEntityIn.unitsPerBlock / 4.0f));
        matrixStackIn.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
        this.renderCorner(matrixStackIn, bufferIn, combinedOverlayIn, combinedLightIn);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)((float)tileEntityIn.unitsPerBlock / 4.0f), (double)((float)tileEntityIn.unitsPerBlock / 4.0f));
        matrixStackIn.func_227863_a_(new Quaternion(180.0f, 0.0f, 0.0f, true));
        this.renderCorner(matrixStackIn, bufferIn, combinedOverlayIn, combinedLightIn);
        matrixStackIn.func_227865_b_();
    }

    public void renderCorner(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedOverlayIn, int combinedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(0.001f, 1.0f, 1.0f);
        SmallerUnitsTESR.renderCube(1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("textures/block/white_concrete.png"))), combinedOverlayIn, combinedLightIn, matrixStackIn, true);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(1.0f, 0.001f, 1.0f);
        SmallerUnitsTESR.renderCube(1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("textures/block/white_concrete.png"))), combinedOverlayIn, combinedLightIn, matrixStackIn, true);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(1.0f, 1.0f, 0.001f);
        SmallerUnitsTESR.renderCube(1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("textures/block/white_concrete.png"))), combinedOverlayIn, combinedLightIn, matrixStackIn, true);
        matrixStackIn.func_227865_b_();
    }
}

