/*
 * Decompiled with CFR 0.152.
 */
package com.tfc.smallerunits.block;

import com.tfc.smallerunits.block.UnitTileEntity;
import com.tfc.smallerunits.helpers.ContainerMixinHelper;
import com.tfc.smallerunits.registry.Deferred;
import com.tfc.smallerunits.utils.ExternalUnitInteractionContext;
import com.tfc.smallerunits.utils.SmallUnit;
import com.tfc.smallerunits.utils.UnitRaytraceContext;
import com.tfc.smallerunits.utils.UnitRaytraceHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.DebugStickItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.SkullItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;

public class SmallerUnitBlock
extends Block
implements ITileEntityProvider {
    public static final VoxelShape virtuallyEmptyShape = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)0.001f, (double)0.001f, (double)0.001f);
    public static final HashMap<CompoundNBT, VoxelShape> shapeMap = new HashMap();

    public SmallerUnitBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150348_b).func_235828_a_((a, b, c) -> false).func_226896_b_().func_200948_a(1.0f, 1.0f));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new UnitTileEntity();
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        UnitTileEntity te = new UnitTileEntity();
        te.loadingWorld = worldIn;
        return te;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_230322_a_(state, worldIn, pos, context);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos worldPos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BlockRayTraceResult result;
        TileEntity tileEntityUncasted = worldIn.func_175625_s(worldPos);
        if (!(tileEntityUncasted instanceof UnitTileEntity)) {
            return super.func_225533_a_(state, worldIn, worldPos, player, handIn, hit);
        }
        UnitTileEntity tileEntity = (UnitTileEntity)tileEntityUncasted;
        UnitRaytraceContext raytraceContext = UnitRaytraceHelper.raytraceBlock(tileEntity, (Entity)player, true, worldPos, Optional.empty());
        if (raytraceContext.shapeHit.func_197766_b()) {
            BlockPos hitPos;
            result = hit;
            Vector3d pos1 = result.func_216347_e().func_178788_d(new Vector3d((double)worldPos.func_177958_n(), (double)worldPos.func_177956_o(), (double)worldPos.func_177952_p())).func_186678_a((double)tileEntity.unitsPerBlock);
            Vector3d pos = new Vector3d(pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c);
            pos = this.invRound(pos);
            raytraceContext.posHit = hitPos = new BlockPos(Math.floor(pos.field_72450_a), Math.floor(pos.field_72448_b) + 64.0, Math.floor(pos.field_72449_c));
        }
        raytraceContext.posHit = raytraceContext.posHit.func_177972_a(hit.func_216354_b());
        ItemStack stack = player.func_184586_b(handIn);
        result = new BlockRayTraceResult(hit.func_216347_e().func_178786_a((double)worldPos.func_177958_n(), (double)worldPos.func_177956_o(), (double)worldPos.func_177952_p()).func_186678_a((double)tileEntity.unitsPerBlock).func_72441_c(0.0, 64.0, 0.0), hit.func_216354_b(), raytraceContext.posHit.func_177972_a(hit.func_216354_b().func_176734_d()), hit.func_216353_d());
        boolean playerIsSleeping = player.func_70608_bn();
        Vector3d playerPos = player.func_213303_ch();
        ActionResultType resultType = ActionResultType.FAIL;
        try {
            resultType = tileEntity.field_145850_b.func_180495_p(raytraceContext.posHit.func_177972_a(hit.func_216354_b().func_176734_d())).func_227031_a_((World)tileEntity.field_145850_b, player, handIn, result);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!playerIsSleeping && player.func_70608_bn()) {
            player.func_225652_a_(true, true);
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147364_a(playerPos.func_82615_a(), playerPos.func_82617_b(), playerPos.func_82616_c(), player.field_70177_z, player.field_70125_A);
            }
            player.func_70107_b(playerPos.func_82615_a(), playerPos.func_82617_b(), playerPos.func_82617_b());
            player.func_146105_b((ITextComponent)new StringTextComponent("Sorry, but you can't sleep in tiny beds."), true);
        }
        if (resultType.func_226246_a_()) {
            tileEntity.func_70296_d();
            worldIn.func_175646_b(worldPos, (TileEntity)tileEntity);
            if (player.field_71070_bA != null) {
                ContainerMixinHelper.setNaturallyClosable(player.field_71070_bA, false);
            }
            return resultType;
        }
        raytraceContext.posHit = raytraceContext.posHit.func_177972_a(hit.func_216354_b().func_176734_d());
        if (stack.func_77973_b() instanceof BlockItem) {
            BlockState statePlace;
            BlockItemUseContext context;
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BlockItem item = (BlockItem)stack.func_77973_b();
            if (item.func_179223_d() instanceof SmallerUnitBlock && !stack.func_77942_o()) {
                return ActionResultType.CONSUME;
            }
            BlockPos posOffset = raytraceContext.posHit.func_177972_a(hit.func_216354_b());
            BlockState clicked = tileEntity.field_145850_b.func_180495_p(raytraceContext.posHit);
            if (clicked.func_196953_a(context = new BlockItemUseContext((World)tileEntity.field_145850_b, player, handIn, stack, result))) {
                posOffset = posOffset.func_177972_a(hit.func_216354_b().func_176734_d());
            }
            if ((statePlace = item.func_179223_d().func_196258_a(context)) != null && statePlace.func_196955_c((IWorldReader)tileEntity.field_145850_b, posOffset)) {
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                tileEntity.field_145850_b.func_175656_a(posOffset, statePlace);
                statePlace.func_177230_c().func_180633_a((World)tileEntity.field_145850_b, posOffset, statePlace, (LivingEntity)player, stack);
                if (!(stack.func_77973_b() instanceof SkullItem)) {
                    if (statePlace.func_177230_c() instanceof ITileEntityProvider) {
                        CompoundNBT nbt;
                        TileEntity te = ((ITileEntityProvider)statePlace.func_177230_c()).func_196283_a_((IBlockReader)tileEntity.field_145850_b);
                        if (stack.func_77942_o() && (nbt = stack.func_196082_o()).func_74764_b("BlockEntityTag")) {
                            nbt = nbt.func_74775_l("BlockEntityTag");
                            te.func_230337_a_(statePlace, nbt);
                        }
                        tileEntity.field_145850_b.func_175690_a(posOffset, te);
                    } else if (statePlace.func_177230_c().hasTileEntity(statePlace)) {
                        CompoundNBT nbt;
                        TileEntity te = statePlace.func_177230_c().createTileEntity(statePlace, (IBlockReader)tileEntity.field_145850_b);
                        if (stack.func_77942_o() && (nbt = stack.func_196082_o()).func_74764_b("BlockEntityTag")) {
                            nbt = nbt.func_74775_l("BlockEntityTag");
                            te.func_230337_a_(statePlace, nbt);
                        }
                        tileEntity.field_145850_b.func_175690_a(posOffset, te);
                    }
                }
            }
        } else if (stack.func_77973_b() instanceof BucketItem) {
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            ((BucketItem)stack.func_77973_b()).func_180616_a(player, (World)tileEntity.field_145850_b, raytraceContext.posHit, result);
        } else if (stack.func_77973_b() instanceof BoneMealItem) {
            BlockState clicked = tileEntity.field_145850_b.func_180495_p(raytraceContext.posHit);
            if (clicked.func_177230_c() instanceof IGrowable && ((IGrowable)clicked.func_177230_c()).func_176473_a((IBlockReader)tileEntity.field_145850_b, raytraceContext.posHit, clicked, worldIn.field_72995_K)) {
                ((IGrowable)clicked.func_177230_c()).func_225535_a_((ServerWorld)tileEntity.field_145850_b, tileEntity.field_145850_b.field_73012_v, raytraceContext.posHit, clicked);
            }
        } else {
            BlockPos posOffset = raytraceContext.posHit.func_177972_a(hit.func_216354_b().func_176734_d());
            if (!worldIn.field_72995_K || !(stack.func_77973_b() instanceof DebugStickItem)) {
                stack.func_77973_b().func_195939_a((ItemUseContext)new BlockItemUseContext((World)tileEntity.field_145850_b, player, handIn, stack, new BlockRayTraceResult(raytraceContext.vecHit.func_186678_a((double)tileEntity.unitsPerBlock), hit.func_216354_b(), posOffset, hit.func_216353_d())));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        TileEntity tileEntityUncasted = world.func_175625_s(pos);
        if (!(tileEntityUncasted instanceof UnitTileEntity)) {
            return 0.0f;
        }
        UnitTileEntity tileEntity = (UnitTileEntity)tileEntityUncasted;
        return tileEntity.field_145850_b.blockMap.isEmpty() ? 0.0f : -1.0f;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        TileEntity tileEntityUncasted = worldIn.func_175625_s(pos);
        if (!(tileEntityUncasted instanceof UnitTileEntity)) {
            return -1.0f;
        }
        UnitTileEntity tileEntity = (UnitTileEntity)tileEntityUncasted;
        UnitRaytraceContext raytraceContext = UnitRaytraceHelper.raytraceBlock(tileEntity, (Entity)player, true, pos, Optional.empty());
        if (raytraceContext.shapeHit.func_197766_b()) {
            return -1.0f;
        }
        BlockPos hitPos = raytraceContext.posHit;
        BlockState state1 = tileEntity.field_145850_b.func_180495_p(hitPos);
        float amt = state1.func_185903_a(player, (IBlockReader)tileEntity.field_145850_b, hitPos) * (float)tileEntity.unitsPerBlock;
        return amt;
    }

    public boolean removedByPlayer(BlockState state, World worldIn, BlockPos worldPos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (worldIn.field_72995_K) {
            return false;
        }
        TileEntity tileEntityUncasted = worldIn.func_175625_s(worldPos);
        if (!(tileEntityUncasted instanceof UnitTileEntity)) {
            return true;
        }
        UnitTileEntity tileEntity = (UnitTileEntity)tileEntityUncasted;
        UnitRaytraceContext raytraceContext = UnitRaytraceHelper.raytraceBlock(tileEntity, (Entity)player, true, worldPos, Optional.empty());
        if (raytraceContext.shapeHit.func_197766_b()) {
            return false;
        }
        BlockPos hitPos = raytraceContext.posHit;
        BlockState state1 = tileEntity.field_145850_b.func_180495_p(hitPos);
        List stacks = state1.func_215693_a(new LootContext.Builder((ServerWorld)tileEntity.field_145850_b).func_186469_a(player.func_184817_da()).func_216023_a(tileEntity.field_145850_b.field_73012_v).func_216016_a(tileEntity.field_145850_b.field_73012_v.nextLong()).func_216015_a(LootParameters.field_216289_i, (Object)player.func_184586_b(Hand.MAIN_HAND)).func_216015_a(LootParameters.field_237457_g_, (Object)raytraceContext.vecHit).func_216021_b(LootParameters.field_216288_h, (Object)tileEntity.field_145850_b.func_175625_s(raytraceContext.posHit)).func_216015_a(LootParameters.field_216287_g, (Object)state1).func_216015_a(LootParameters.field_216281_a, (Object)player));
        for (ItemStack stack : stacks) {
            ItemEntity entity = new ItemEntity((World)tileEntity.field_145850_b, (double)hitPos.func_177958_n(), (double)hitPos.func_177956_o(), (double)hitPos.func_177952_p(), stack);
            tileEntity.field_145850_b.func_217376_c((Entity)entity);
        }
        state1.func_196947_b((World)tileEntity.field_145850_b, raytraceContext.posHit, Blocks.field_150350_a.func_176223_P(), false);
        state1.removedByPlayer((World)tileEntity.field_145850_b, hitPos, player, true, state1.func_204520_s());
        tileEntity.field_145850_b.func_217377_a(hitPos, false);
        return false;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_151468_f()) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        TileEntity tileEntityUncasted = world.func_175625_s(pos);
        if (!(tileEntityUncasted instanceof UnitTileEntity)) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        UnitTileEntity tileEntity = (UnitTileEntity)tileEntityUncasted;
        UnitRaytraceContext raytraceContext = UnitRaytraceHelper.raytraceBlock(tileEntity, (Entity)player, true, pos, Optional.empty());
        if (raytraceContext.shapeHit.func_197766_b()) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        BlockPos hitPos = raytraceContext.posHit;
        BlockState state1 = tileEntity.field_145850_b.func_180495_p(hitPos);
        if (target instanceof BlockRayTraceResult) {
            return state1.getPickBlock((RayTraceResult)new BlockRayTraceResult(raytraceContext.vecHit, ((BlockRayTraceResult)target).func_216354_b(), raytraceContext.posHit, ((BlockRayTraceResult)target).func_216353_d()), world, pos, player);
        }
        return state1.getPickBlock((RayTraceResult)new BlockRayTraceResult(raytraceContext.vecHit, Direction.UP, raytraceContext.posHit, false), world, pos, player);
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof UnitTileEntity)) {
            return;
        }
        UnitTileEntity tileEntity1 = (UnitTileEntity)tileEntity;
        if (tileEntity1.field_145850_b != null) {
            BlockPos blockPos;
            ArrayList<SmallUnit> toRemove = new ArrayList<SmallUnit>();
            ArrayList<SmallUnit> toMove = new ArrayList<SmallUnit>();
            for (SmallUnit value : tileEntity1.field_145850_b.blockMap.values()) {
                blockPos = value.pos;
                if (value.pos == null) {
                    toRemove.add(value);
                    continue;
                }
                int y = value.pos.func_177956_o() - 64;
                if (blockPos.func_177958_n() >= 0 && blockPos.func_177958_n() <= tileEntity1.unitsPerBlock - 1 && blockPos.func_177952_p() >= 0 && blockPos.func_177952_p() <= tileEntity1.unitsPerBlock - 1 && y >= 0 && y <= tileEntity1.unitsPerBlock - 1) continue;
                toMove.add(value);
            }
            for (SmallUnit smallUnit : toRemove) {
                tileEntity1.field_145850_b.blockMap.remove(smallUnit.pos);
            }
            for (SmallUnit value : toMove) {
                blockPos = value.pos;
                ExternalUnitInteractionContext context = new ExternalUnitInteractionContext(((UnitTileEntity)tileEntity).field_145850_b, value.pos);
                if (context.teInRealWorld instanceof UnitTileEntity && ((UnitTileEntity)context.teInRealWorld).field_145850_b.blockMap.isEmpty()) {
                    ((UnitTileEntity)context.teInRealWorld).unitsPerBlock = tileEntity1.unitsPerBlock;
                }
                if (context.stateInRealWorld.func_177230_c().equals(Blocks.field_150350_a)) {
                    UnitTileEntity tileEntity2 = new UnitTileEntity();
                    worldIn.func_175656_a(context.posInRealWorld, ((Block)Deferred.UNIT.get()).func_176223_P());
                    worldIn.func_175690_a(context.posInRealWorld, (TileEntity)tileEntity2);
                    tileEntity2.isNatural = true;
                    continue;
                }
                TileEntity te = context.teInRealWorld;
                if (!(te instanceof UnitTileEntity)) continue;
                value.pos = context.posInFakeWorld;
                ((UnitTileEntity)te).field_145850_b.func_241211_a_(value.pos, value.state, 3, 0);
                ((UnitTileEntity)te).field_145850_b.func_175690_a(value.pos, value.tileEntity);
                tileEntity1.field_145850_b.blockMap.remove(blockPos);
                tileEntity.func_70296_d();
                te.func_70296_d();
                worldIn.func_184138_a(tileEntity.func_174877_v(), state, state, 3);
                worldIn.func_184138_a(te.func_174877_v(), state, state, 3);
            }
            long start = new Date().getTime();
            tileEntity1.field_145850_b.func_72835_b(() -> Math.abs(new Date().getTime() - start) <= 10L);
            if (tileEntity1.isNatural && tileEntity1.field_145850_b.blockMap.isEmpty()) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        Direction dir;
        BlockPos pos1;
        BlockState state1;
        TileEntity tileEntityUncasted = reader.func_175625_s(pos);
        if (context.getEntity() == null || !(tileEntityUncasted instanceof UnitTileEntity)) {
            return super.func_220053_a(state, reader, pos, context);
        }
        UnitTileEntity tileEntity = (UnitTileEntity)tileEntityUncasted;
        VoxelShape shape = UnitRaytraceHelper.raytraceBlock((UnitTileEntity)tileEntity, (Entity)context.getEntity(), (boolean)true, (BlockPos)pos, Optional.of(context)).shapeHit;
        if (!shape.func_197766_b()) {
            return shape;
        }
        Vector3d start = context.getEntity().func_174824_e(0.0f);
        double reach = 8.0;
        if (context.getEntity() instanceof PlayerEntity) {
            reach = ((LivingEntity)context.getEntity()).func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get());
        }
        Vector3d look = context.getEntity().func_70040_Z().func_186678_a(reach);
        Vector3d end = context.getEntity().func_174824_e(0.0f).func_178787_e(look);
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n && !((state1 = reader.func_180495_p(pos1 = pos.func_177972_a(dir = directionArray[i]))).func_177230_c() instanceof SmallerUnitBlock); ++i) {
            VoxelShape raytraceShape = state1.func_199611_f(reader, pos, context);
            boolean isHit = false;
            Vector3d hit = null;
            for (AxisAlignedBB axisAlignedBB : raytraceShape.func_197756_d()) {
                Optional intercept = (axisAlignedBB = axisAlignedBB.func_72317_d((double)pos1.func_177958_n(), (double)pos1.func_177956_o(), (double)pos1.func_177952_p())).func_216365_b(start, end);
                if (!intercept.isPresent()) continue;
                isHit = true;
                hit = (Vector3d)intercept.get();
            }
            if (!isHit) continue;
            VoxelShape shape1 = raytraceShape.func_197751_a((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e());
            BlockPos pos2 = this.getHit((RayTraceResult)new BlockRayTraceResult(hit, context.getEntity().func_174811_aO(), pos1, false), pos1, tileEntity.unitsPerBlock);
            pos2 = pos2.func_177972_a(dir.func_176734_d());
            if (dir == Direction.DOWN) {
                pos2 = new BlockPos(pos2.func_177958_n(), -1, pos2.func_177952_p());
            } else if (dir == Direction.UP) {
                pos2 = new BlockPos(pos2.func_177958_n(), tileEntity.unitsPerBlock, pos2.func_177952_p());
            } else if (dir == Direction.WEST) {
                pos2 = new BlockPos(-1, pos2.func_177956_o(), pos2.func_177952_p());
            } else if (dir == Direction.EAST) {
                pos2 = new BlockPos(tileEntity.unitsPerBlock, pos2.func_177956_o(), pos2.func_177952_p());
            } else if (dir == Direction.NORTH) {
                pos2 = new BlockPos(pos2.func_177958_n(), pos2.func_177956_o(), -1);
            } else if (dir == Direction.SOUTH) {
                pos2 = new BlockPos(pos2.func_177958_n(), pos2.func_177956_o(), tileEntity.unitsPerBlock);
            }
            return VoxelShapes.func_197882_b((VoxelShape)shape1, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)((float)pos2.func_177958_n() / (float)tileEntity.unitsPerBlock), (double)((float)pos2.func_177956_o() / (float)tileEntity.unitsPerBlock), (double)((float)pos2.func_177952_p() / (float)tileEntity.unitsPerBlock), (double)((float)pos2.func_177958_n() / (float)tileEntity.unitsPerBlock + 1.0f / (float)tileEntity.unitsPerBlock), (double)((float)pos2.func_177956_o() / (float)tileEntity.unitsPerBlock + 1.0f / (float)tileEntity.unitsPerBlock), (double)((float)pos2.func_177952_p() / (float)tileEntity.unitsPerBlock + 1.0f / (float)tileEntity.unitsPerBlock))), (IBooleanFunction)IBooleanFunction.field_223238_i_);
        }
        if (shape.func_197766_b()) {
            return super.func_230322_a_(state, reader, pos, context);
        }
        return shape;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_230335_e_(state, worldIn, pos);
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader reader, BlockPos pos) {
        TileEntity tileEntityUncasted = reader.func_175625_s(pos);
        if (!(tileEntityUncasted instanceof UnitTileEntity)) {
            return virtuallyEmptyShape;
        }
        UnitTileEntity tileEntity = (UnitTileEntity)tileEntityUncasted;
        CompoundNBT nbt = tileEntity.serializeNBT();
        nbt.func_82580_o("x");
        nbt.func_82580_o("y");
        nbt.func_82580_o("z");
        nbt.func_82580_o("id");
        nbt.func_82580_o("ForgeData");
        nbt.func_82580_o("ForgeCaps");
        nbt.func_82580_o("ticks");
        if (!shapeMap.containsKey(nbt)) {
            VoxelShape shape = VoxelShapes.func_197880_a();
            for (SmallUnit value : tileEntity.field_145850_b.blockMap.values()) {
                VoxelShape shape1 = value.state.func_196952_d((IBlockReader)tileEntity.field_145850_b, value.pos);
                VoxelShape shape2 = VoxelShapes.func_197880_a();
                for (AxisAlignedBB axisAlignedBB : this.shrink(shape1, tileEntity.unitsPerBlock)) {
                    shape2 = VoxelShapes.func_197872_a((VoxelShape)shape2, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)axisAlignedBB));
                }
                shape2 = shape2.func_197751_a((double)((float)value.pos.func_177958_n() / (float)tileEntity.unitsPerBlock), (double)((float)(value.pos.func_177956_o() - 64) / (float)tileEntity.unitsPerBlock), (double)((float)value.pos.func_177952_p() / (float)tileEntity.unitsPerBlock));
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)shape2);
            }
            if (shape.func_197766_b()) {
                return shape;
            }
            shapeMap.put(nbt, shape);
            return shape;
        }
        return shapeMap.get(nbt);
    }

    public BlockPos getHit(RayTraceResult result, BlockPos worldPos, int scale) {
        Vector3d pos1 = result.func_216347_e().func_178788_d(new Vector3d((double)worldPos.func_177958_n(), (double)worldPos.func_177956_o(), (double)worldPos.func_177952_p())).func_186678_a((double)scale);
        Vector3d pos = new Vector3d(pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c);
        pos = this.invRound(pos);
        return new BlockPos(Math.floor(pos.field_72450_a), Math.floor(pos.field_72448_b), Math.floor(pos.field_72449_c));
    }

    public Vector3d invRound(Vector3d pos) {
        double x = pos.func_82615_a();
        double y = pos.func_82617_b();
        double z = pos.func_82616_c();
        x = pos.field_72450_a <= 0.5 ? Math.ceil(pos.field_72450_a) - 1.0 : Math.floor(pos.field_72450_a);
        y = pos.field_72448_b <= 0.5 ? Math.ceil(pos.field_72448_b) - 1.0 : Math.floor(pos.field_72448_b);
        z = pos.field_72449_c <= 0.5 ? Math.ceil(pos.field_72449_c) - 1.0 : Math.floor(pos.field_72449_c);
        return new Vector3d((double)Math.round(x), (double)Math.round(y), (double)Math.round(z));
    }

    public ArrayList<AxisAlignedBB> shrink(VoxelShape shape, int scale) {
        ArrayList<AxisAlignedBB> newBoundingBoxes = new ArrayList<AxisAlignedBB>();
        for (AxisAlignedBB axisAlignedBB : shape.func_197756_d()) {
            axisAlignedBB = new AxisAlignedBB(axisAlignedBB.field_72340_a / (double)scale, axisAlignedBB.field_72338_b / (double)scale, axisAlignedBB.field_72339_c / (double)scale, axisAlignedBB.field_72336_d / (double)scale, axisAlignedBB.field_72337_e / (double)scale, axisAlignedBB.field_72334_f / (double)scale);
            newBoundingBoxes.add(axisAlignedBB);
        }
        return newBoundingBoxes;
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntityUncasted = worldIn.func_175625_s(pos);
        if (!(tileEntityUncasted instanceof UnitTileEntity)) {
            return;
        }
        UnitTileEntity tileEntity = (UnitTileEntity)tileEntityUncasted;
        UnitRaytraceContext raytraceContext = UnitRaytraceHelper.raytraceBlock(tileEntity, (Entity)player, true, pos, Optional.empty());
        if (raytraceContext.shapeHit.func_197766_b()) {
            return;
        }
        BlockPos hitPos = raytraceContext.posHit;
        tileEntity.field_145850_b.func_180495_p(raytraceContext.posHit).func_196942_a((World)tileEntity.field_145850_b, raytraceContext.posHit, player);
    }
}

