/*
 * Decompiled with CFR 0.152.
 */
package com.tfc.smallerunits.block;

import com.tfc.smallerunits.SmallerUnitsTESR;
import com.tfc.smallerunits.registry.Deferred;
import com.tfc.smallerunits.utils.UnitPallet;
import com.tfc.smallerunits.utils.world.FakeDimensionSavedData;
import com.tfc.smallerunits.utils.world.FakeServerWorld;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.TickPriority;
import net.minecraftforge.fml.loading.FMLEnvironment;
import sun.misc.Unsafe;

public class UnitTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final Unsafe theUnsafe;
    public boolean isNatural = false;
    public CompoundNBT dataNBT = new CompoundNBT();
    public final FakeServerWorld field_145850_b;
    public int unitsPerBlock = 4;
    public IBlockReader loadingWorld;

    public UnitTileEntity() {
        super((TileEntityType)Deferred.UNIT_TE.get());
        try {
            this.field_145850_b = (FakeServerWorld)((Object)theUnsafe.allocateInstance(FakeServerWorld.class));
            this.field_145850_b.init(this);
        }
        catch (Throwable err) {
            throw new RuntimeException(err);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    public void func_73660_a() {
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (FMLEnvironment.dist.isClient()) {
            for (Direction dir : Direction.values()) {
                SmallerUnitsTESR.bufferCache.remove((Object)this.func_174877_v().func_177972_a(dir));
            }
            SmallerUnitsTESR.bufferCache.remove((Object)this.func_174877_v());
        }
        this.unitsPerBlock = Math.min(Math.max(nbt.func_74762_e("upb"), 1), 256);
        UnitPallet pallet = new UnitPallet(nbt.func_74775_l("containedUnits"), this.field_145850_b);
        this.field_145850_b.blockMap = pallet.posUnitMap;
        CompoundNBT ticks = nbt.func_74775_l("ticks");
        ListNBT blockTickList = ticks.func_150295_c("blockTicks", 10);
        for (INBT inbt : blockTickList) {
            CompoundNBT tick = (CompoundNBT)inbt;
            BlockPos pos = new BlockPos(tick.func_74762_e("x"), tick.func_74762_e("y"), tick.func_74762_e("z"));
            long time = tick.func_74762_e("time");
            int priority = tick.func_74762_e("priority");
            this.field_145850_b.func_205220_G_().func_205362_a(pos, (Object)pallet.posUnitMap.get((Object)pos).state.func_177230_c(), (int)time, TickPriority.func_205397_a((int)priority));
        }
        ListNBT fluidTickList = ticks.func_150295_c("fluidTicks", 10);
        for (INBT inbt : fluidTickList) {
            CompoundNBT tick = (CompoundNBT)inbt;
            BlockPos pos = new BlockPos(tick.func_74762_e("x"), tick.func_74762_e("y"), tick.func_74762_e("z"));
            long time = tick.func_74762_e("time");
            int priority = tick.func_74762_e("priority");
            this.field_145850_b.func_205219_F_().func_205362_a(pos, (Object)pallet.posUnitMap.get((Object)pos).state.func_204520_s().func_206886_c(), (int)time, TickPriority.func_205397_a((int)priority));
        }
        if (nbt.func_74764_b("savedData")) {
            this.dataNBT = nbt.func_74775_l("savedData");
        }
        if (nbt.func_74764_b("isNatural")) {
            this.isNatural = nbt.func_74767_n("isNatural");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT tick;
        UnitPallet unitPallet = new UnitPallet(this.field_145850_b.blockMap.values());
        compound.func_218657_a("containedUnits", (INBT)unitPallet.nbt);
        compound.func_74768_a("upb", Math.max(1, this.unitsPerBlock));
        CompoundNBT ticks = new CompoundNBT();
        ListNBT pendingBlockTicks = new ListNBT();
        for (NextTickListEntry blockNextTickListEntry : this.field_145850_b.func_205220_G_().func_223188_a(new ChunkPos(0L), false, false)) {
            tick = new CompoundNBT();
            tick.func_74772_a("time", blockNextTickListEntry.field_235017_b_ - this.field_145850_b.func_82737_E());
            tick.func_74768_a("x", blockNextTickListEntry.field_180282_a.func_177958_n());
            tick.func_74768_a("y", blockNextTickListEntry.field_180282_a.func_177956_o());
            tick.func_74768_a("z", blockNextTickListEntry.field_180282_a.func_177952_p());
            tick.func_74768_a("priority", blockNextTickListEntry.field_82754_f.ordinal());
            pendingBlockTicks.add((Object)tick);
        }
        ticks.func_218657_a("blockTicks", (INBT)pendingBlockTicks);
        ListNBT pendingFluidTicks = new ListNBT();
        for (NextTickListEntry blockNextTickListEntry : this.field_145850_b.func_205219_F_().func_223188_a(new ChunkPos(0L), false, false)) {
            tick = new CompoundNBT();
            tick.func_74772_a("time", blockNextTickListEntry.field_235017_b_ - this.field_145850_b.func_82737_E());
            tick.func_74768_a("x", blockNextTickListEntry.field_180282_a.func_177958_n());
            tick.func_74768_a("y", blockNextTickListEntry.field_180282_a.func_177956_o());
            tick.func_74768_a("z", blockNextTickListEntry.field_180282_a.func_177952_p());
            tick.func_74768_a("priority", blockNextTickListEntry.field_82754_f.ordinal());
            pendingFluidTicks.add((Object)tick);
        }
        ticks.func_218657_a("fluidTicks", (INBT)pendingFluidTicks);
        compound.func_218657_a("ticks", (INBT)ticks);
        this.field_145850_b.func_217481_x().func_212775_b();
        compound.func_218657_a("savedData", (INBT)((FakeDimensionSavedData)this.field_145850_b.func_217481_x()).savedNBT);
        compound.func_74757_a("isNatural", this.isNatural);
        return super.func_189515_b(compound);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.func_230337_a_(((Block)Deferred.UNIT.get()).func_176223_P(), nbt);
    }

    public CompoundNBT serializeNBT() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public CompoundNBT getTileData() {
        return this.serializeNBT();
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtShare = this.serializeNBT();
        nbtShare.func_82580_o("ticks");
        nbtShare.func_82580_o("savedData");
        return nbtShare;
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            theUnsafe = (Unsafe)f.get(null);
        }
        catch (Throwable err) {
            throw new RuntimeException(err);
        }
    }
}

