/*
 * Decompiled with CFR 0.152.
 */
package com.tfc.smallerunits.crafting;

import com.mojang.datafixers.util.Pair;
import com.tfc.smallerunits.TileResizingItem;
import com.tfc.smallerunits.UnitItem;
import com.tfc.smallerunits.registry.Deferred;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;

public class RecipeUtils {
    public static NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (item.func_77973_b() instanceof TileResizingItem) {
                ItemStack newStack = item.func_77946_l();
                nonnulllist.set(i, (Object)newStack);
                continue;
            }
            if (!item.hasContainerItem()) continue;
            nonnulllist.set(i, (Object)item.getContainerItem());
        }
        return nonnulllist;
    }

    public static boolean matchesShapelessResizing(CraftingInventory inventory) {
        int count = 0;
        UnitItem unitIfPresent = null;
        TileResizingItem hammer = null;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i).func_77946_l();
            if ((count += stack.func_190926_b() ? 0 : 1) > 2) {
                return false;
            }
            if (stack.func_77973_b() instanceof UnitItem && unitIfPresent != null) {
                return false;
            }
            if (stack.func_77973_b() instanceof TileResizingItem && hammer != null) {
                return false;
            }
            if (stack.func_77973_b() instanceof UnitItem) {
                unitIfPresent = (UnitItem)stack.func_77973_b();
                continue;
            }
            if (stack.func_77973_b() instanceof TileResizingItem) {
                hammer = (TileResizingItem)stack.func_77973_b();
                continue;
            }
            if (stack.func_190926_b()) continue;
            return false;
        }
        if (hammer == null) {
            return false;
        }
        return hammer.getScale() > 0 || unitIfPresent != null;
    }

    public static Pair<ItemStack, ItemStack> getUnitAndHammer(CraftingInventory inventory) {
        int count = 0;
        ItemStack unitIfPresent = null;
        ItemStack hammer = null;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i).func_77946_l();
            if ((count += stack.func_190926_b() ? 0 : 1) > 2) {
                return null;
            }
            if (stack.func_77973_b() instanceof UnitItem) {
                unitIfPresent = stack;
                continue;
            }
            if (stack.func_77973_b() instanceof TileResizingItem) {
                hammer = stack;
                continue;
            }
            if (stack.func_190926_b()) continue;
            return null;
        }
        if (unitIfPresent == null) {
            unitIfPresent = new ItemStack((IItemProvider)Deferred.UNITITEM.get());
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("upb", 3);
            unitIfPresent.func_196082_o().func_218657_a("BlockEntityTag", (INBT)nbt);
        }
        return Pair.of(unitIfPresent, hammer);
    }
}

