/*
 * Decompiled with CFR 0.152.
 */
package com.tfc.smallerunits.utils;

import com.tfc.smallerunits.utils.SmallUnit;
import com.tfc.smallerunits.utils.world.FakeServerWorld;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class UnitPallet {
    public final CompoundNBT nbt;
    public final HashMap<BlockState, Integer> stateIdMap = new HashMap();
    public final HashMap<BlockPos, Integer> posIdMap = new HashMap();
    public final HashMap<BlockPos, SmallUnit> posUnitMap = new HashMap();
    public int lastId = 0;

    public UnitPallet(Collection<SmallUnit> units) {
        this.nbt = new CompoundNBT();
        ListNBT listNbt = new ListNBT();
        CompoundNBT states = new CompoundNBT();
        for (SmallUnit unit : units) {
            this.posUnitMap.put(unit.pos, unit);
            if (!this.stateIdMap.containsKey(unit.state)) {
                this.stateIdMap.put(unit.state, this.lastId++);
            }
            this.posIdMap.put(unit.pos, this.stateIdMap.get(unit.state));
            CompoundNBT unitNBT = new CompoundNBT();
            if (unit == null || unit.pos == null) continue;
            unitNBT.func_74768_a("x", unit.pos.func_177958_n());
            unitNBT.func_74768_a("y", unit.pos.func_177956_o() - 64);
            unitNBT.func_74768_a("z", unit.pos.func_177952_p());
            unitNBT.func_74768_a("state", this.stateIdMap.get(unit.state).intValue());
            if (unit.tileEntity != null) {
                unitNBT.func_218657_a("tileNBT", (INBT)unit.tileEntity.serializeNBT());
            }
            listNbt.add((Object)unitNBT);
            String state = unit.state.toString();
            state = state.substring("Block{".length());
            state = state.replace("}", "");
            states.func_74778_a(this.stateIdMap.get(unit.state).toString(), state);
        }
        this.nbt.func_218657_a("units", (INBT)listNbt);
        this.nbt.func_218657_a("states", (INBT)states);
    }

    public UnitPallet(CompoundNBT nbt, FakeServerWorld world) {
        this.nbt = nbt;
        ListNBT listNBT = nbt.func_150295_c("units", 10);
        CompoundNBT stateIndexMap = nbt.func_74775_l("states");
        for (INBT inbt : listNBT) {
            TileEntity te;
            CompoundNBT teNBT;
            TileEntityType type;
            CompoundNBT nbt1 = (CompoundNBT)inbt;
            BlockPos pos = new BlockPos(nbt1.func_74762_e("x"), nbt1.func_74762_e("y") + 64, nbt1.func_74762_e("z"));
            int stateIndex = nbt1.func_74762_e("state");
            String state = stateIndexMap.func_74779_i(stateIndex + "");
            int end = state.indexOf("[");
            if (end == -1) {
                end = state.length() + 1;
            }
            String blockName = state;
            if (state.contains("[")) {
                blockName = state.substring(0, end);
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
            SmallUnit unit = null;
            for (BlockState validState : block.func_176194_O().func_177619_a()) {
                if (!validState.toString().startsWith("Block{" + state.replace("[", "}["))) continue;
                unit = new SmallUnit(pos, validState);
                this.posUnitMap.put(pos, unit);
                break;
            }
            if (unit == null || !nbt1.func_74764_b("tileNBT") || (type = (TileEntityType)ForgeRegistries.TILE_ENTITIES.getValue(new ResourceLocation((teNBT = nbt1.func_74775_l("tileNBT")).func_74779_i("id")))) == null || (te = type.func_200968_a()) == null) continue;
            te.func_230337_a_(unit.state, teNBT);
            unit.tileEntity = te;
            if (world == null) continue;
            unit.tileEntity.func_226984_a_((World)world, pos);
        }
    }
}

