/*
 * Decompiled with CFR 0.152.
 */
package com.tfc.smallerunits.utils;

import com.tfc.smallerunits.block.UnitTileEntity;
import com.tfc.smallerunits.utils.SmallUnit;
import com.tfc.smallerunits.utils.UnitRaytraceContext;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ForgeMod;

public class UnitRaytraceHelper {
    public static UnitRaytraceContext raytraceBlock(UnitTileEntity tileEntity, Entity entity, boolean includeGround, BlockPos pos, Optional<ISelectionContext> contextOptional) {
        VoxelShape shape = null;
        Vector3d start = entity.func_174824_e(0.0f);
        double reach = 8.0;
        if (entity instanceof PlayerEntity) {
            reach = ((LivingEntity)entity).func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get());
        }
        Vector3d look = entity.func_70040_Z().func_186678_a(reach);
        Vector3d end = entity.func_174824_e(0.0f).func_178787_e(look);
        double bestDist = Double.POSITIVE_INFINITY;
        BlockPos hitPos = null;
        Vector3d hitVec = null;
        for (SmallUnit unit : tileEntity.field_145850_b.blockMap.values()) {
            VoxelShape shape1 = contextOptional.isPresent() ? unit.state.func_215700_a((IBlockReader)tileEntity.field_145850_b, unit.pos, contextOptional.get()) : unit.state.func_196954_c((IBlockReader)tileEntity.field_145850_b, unit.pos);
            ArrayList<AxisAlignedBB> aabbs = UnitRaytraceHelper.shrink(shape1, tileEntity.unitsPerBlock);
            for (AxisAlignedBB axisAlignedBB : aabbs) {
                double dist;
                axisAlignedBB = axisAlignedBB.func_72317_d((double)((float)unit.pos.func_177958_n() / (float)tileEntity.unitsPerBlock), (double)((float)(unit.pos.func_177956_o() - 64) / (float)tileEntity.unitsPerBlock), (double)((float)unit.pos.func_177952_p() / (float)tileEntity.unitsPerBlock));
                Optional intercept = (axisAlignedBB = axisAlignedBB.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())).func_216365_b(start, end);
                if (!intercept.isPresent() || (dist = ((Vector3d)intercept.get()).func_72438_d(start)) > bestDist) continue;
                bestDist = dist;
                VoxelShape theShape = VoxelShapes.func_197880_a();
                for (AxisAlignedBB axisAlignedBB1 : aabbs) {
                    axisAlignedBB1 = axisAlignedBB1.func_72317_d((double)((float)unit.pos.func_177958_n() / (float)tileEntity.unitsPerBlock), (double)((float)(unit.pos.func_177956_o() - 64) / (float)tileEntity.unitsPerBlock), (double)((float)unit.pos.func_177952_p() / (float)tileEntity.unitsPerBlock));
                    theShape = VoxelShapes.func_197872_a((VoxelShape)theShape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)axisAlignedBB1));
                }
                shape = theShape;
                hitPos = unit.pos;
                hitVec = (Vector3d)intercept.get();
            }
        }
        if (shape == null || hitPos == null) {
            return new UnitRaytraceContext(VoxelShapes.func_197880_a(), new BlockPos(-100, -100, -100), new Vector3d(-100.0, -100.0, -100.0));
        }
        return new UnitRaytraceContext(shape, hitPos, hitVec);
    }

    public static ArrayList<AxisAlignedBB> shrink(VoxelShape shape, int scale) {
        ArrayList<AxisAlignedBB> newBoundingBoxes = new ArrayList<AxisAlignedBB>();
        for (AxisAlignedBB axisAlignedBB : shape.func_197756_d()) {
            axisAlignedBB = new AxisAlignedBB(axisAlignedBB.field_72340_a / (double)scale, axisAlignedBB.field_72338_b / (double)scale, axisAlignedBB.field_72339_c / (double)scale, axisAlignedBB.field_72336_d / (double)scale, axisAlignedBB.field_72337_e / (double)scale, axisAlignedBB.field_72334_f / (double)scale);
            newBoundingBoxes.add(axisAlignedBB);
        }
        return newBoundingBoxes;
    }
}

