/*
 * Decompiled with CFR 0.152.
 */
package com.tfc.smallerunits.utils.rendering;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomBuffer
implements IRenderTypeBuffer {
    private static final RegionRenderCacheBuilder fixedBuilder = new RegionRenderCacheBuilder();
    public static final SortedMap<RenderType, CustomBufferBuilder> fixedBuffers = (SortedMap)Util.func_200696_a((Object)new Object2ObjectLinkedOpenHashMap(), p_228485_1_ -> {
        p_228485_1_.put((Object)Atlases.func_228782_g_(), (Object)fixedBuilder.getBuilder(RenderType.func_228639_c_()));
        p_228485_1_.put((Object)Atlases.func_228783_h_(), (Object)fixedBuilder.getBuilder(RenderType.func_228643_e_()));
        p_228485_1_.put((Object)Atlases.func_228768_a_(), (Object)fixedBuilder.getBuilder(RenderType.func_228641_d_()));
        p_228485_1_.put((Object)Atlases.func_228785_j_(), (Object)fixedBuilder.getBuilder(RenderType.func_228645_f_()));
        CustomBuffer.put((Object2ObjectLinkedOpenHashMap<RenderType, CustomBufferBuilder>)p_228485_1_, Atlases.func_228776_b_());
        CustomBuffer.put((Object2ObjectLinkedOpenHashMap<RenderType, CustomBufferBuilder>)p_228485_1_, Atlases.func_228778_c_());
        CustomBuffer.put((Object2ObjectLinkedOpenHashMap<RenderType, CustomBufferBuilder>)p_228485_1_, Atlases.func_228779_d_());
        CustomBuffer.put((Object2ObjectLinkedOpenHashMap<RenderType, CustomBufferBuilder>)p_228485_1_, Atlases.func_228780_e_());
        CustomBuffer.put((Object2ObjectLinkedOpenHashMap<RenderType, CustomBufferBuilder>)p_228485_1_, Atlases.func_228781_f_());
        CustomBuffer.put((Object2ObjectLinkedOpenHashMap<RenderType, CustomBufferBuilder>)p_228485_1_, RenderType.func_228647_g_());
        CustomBuffer.put((Object2ObjectLinkedOpenHashMap<RenderType, CustomBufferBuilder>)p_228485_1_, RenderType.func_228653_j_());
        CustomBuffer.put((Object2ObjectLinkedOpenHashMap<RenderType, CustomBufferBuilder>)p_228485_1_, RenderType.func_228655_k_());
        CustomBuffer.put((Object2ObjectLinkedOpenHashMap<RenderType, CustomBufferBuilder>)p_228485_1_, RenderType.func_228651_i_());
        ModelBakery.field_229320_k_.forEach(p_228488_1_ -> CustomBuffer.put((Object2ObjectLinkedOpenHashMap<RenderType, CustomBufferBuilder>)p_228485_1_, p_228488_1_));
    });
    public ArrayList<CustomVertexBuilder> builders = new ArrayList();
    public BlockPos pos;
    public Direction face;

    private static void put(Object2ObjectLinkedOpenHashMap<RenderType, CustomBufferBuilder> mapBuildersIn, RenderType renderTypeIn) {
        mapBuildersIn.put((Object)renderTypeIn, (Object)new CustomBufferBuilder(renderTypeIn.func_228662_o_(), renderTypeIn));
    }

    public IVertexBuilder getBuffer(RenderType p_getBuffer_1_) {
        CustomVertexBuilder builder = new CustomVertexBuilder(p_getBuffer_1_);
        builder.pos = this.pos;
        builder.face = this.face;
        this.builders.add(builder);
        return builder;
    }

    public static class VertexElement
    extends Vertex
    implements IElement {
        public RenderType type;

        public VertexElement(Vertex vert, RenderType type) {
            this.x = vert.x;
            this.y = vert.y;
            this.z = vert.z;
            this.r = vert.r;
            this.g = vert.g;
            this.b = vert.b;
            this.a = vert.a;
            this.u = vert.u;
            this.v = vert.v;
            this.lv = vert.lv;
            this.lu = vert.lu;
            this.ou = vert.ou;
            this.ov = vert.ov;
            this.nx = vert.nx;
            this.ny = vert.ny;
            this.nz = vert.nz;
            this.type = type;
        }

        @Override
        public void addToBuffer(IRenderTypeBuffer.Impl buffer) {
            try {
                buffer.getBuffer(this.type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class Vertex {
        public double x;
        public double y;
        public double z;
        public int r;
        public int g;
        public int b;
        public int a;
        public float u;
        public float v;
        public float lu;
        public float lv;
        public int ou;
        public int ov;
        public float nx;
        public float ny;
        public float nz;
        public BlockPos pos;
        public Direction dir;
    }

    public static class CustomVertexBuilder
    implements IVertexBuilder {
        public ArrayList<Vertex> vertices = new ArrayList();
        public Vertex vertex = new Vertex();
        public RenderType type;
        public BlockPos pos;
        public Direction face;
        public MatrixStack matrix = null;

        public CustomVertexBuilder(RenderType type) {
            this.type = type;
        }

        public IVertexBuilder func_227886_a_(int lightmapUV) {
            this.vertex.lu = lightmapUV;
            this.vertex.lv = lightmapUV;
            return this;
        }

        public IVertexBuilder func_227891_b_(int overlayUV) {
            return this;
        }

        public IVertexBuilder func_225582_a_(double x, double y, double z) {
            if (this.matrix != null) {
                Vector4f vec = new Vector4f((float)x, (float)y, (float)z, 0.0f);
                vec.func_229372_a_(this.matrix.func_227866_c_().func_227870_a_());
                Vector4f offsetVec = new Vector4f((float)(-(this.pos.func_177958_n() % 16) + this.pos.func_177958_n()), (float)(-(this.pos.func_177956_o() % 16) + this.pos.func_177956_o() - 64), (float)(-(this.pos.func_177952_p() % 16) + this.pos.func_177952_p()), 0.0f);
                offsetVec.func_229372_a_(this.matrix.func_227866_c_().func_227870_a_());
                x = vec.func_195910_a() + offsetVec.func_195910_a();
                y = vec.func_195913_b() + offsetVec.func_195913_b();
                z = vec.func_195914_c() + offsetVec.func_195914_c();
            }
            this.vertex.x = x;
            this.vertex.y = y;
            this.vertex.z = z;
            return this;
        }

        public IVertexBuilder func_225586_a_(int red, int green, int blue, int alpha) {
            this.vertex.r = red;
            this.vertex.g = green;
            this.vertex.b = blue;
            this.vertex.a = alpha;
            return this;
        }

        public IVertexBuilder func_225583_a_(float u, float v) {
            this.vertex.u = u;
            this.vertex.v = v;
            return this;
        }

        public IVertexBuilder func_225585_a_(int u, int v) {
            this.vertex.ou = u;
            this.vertex.ov = v;
            return this;
        }

        public IVertexBuilder func_225587_b_(int u, int v) {
            this.vertex.lu = u;
            this.vertex.lv = v;
            return this;
        }

        public IVertexBuilder func_225584_a_(float x, float y, float z) {
            this.vertex.nx = x;
            this.vertex.ny = y;
            this.vertex.nz = z;
            return this;
        }

        public void func_181675_d() {
            this.vertices.add(this.vertex);
            this.vertex.dir = this.face;
            this.vertex.pos = this.pos;
            this.vertex = new Vertex();
        }

        public IVertexBuilder func_227885_a_(float red, float green, float blue, float alpha) {
            this.vertex.r = (int)(red * 255.0f);
            this.vertex.g = (int)(green * 255.0f);
            this.vertex.b = (int)(blue * 255.0f);
            this.vertex.a = (int)(alpha * 255.0f);
            return this;
        }
    }

    public static class CustomBufferBuilder
    extends BufferBuilder {
        protected ArrayList<IElement> elements = new ArrayList();
        Vertex vertex = new Vertex();
        private RenderType type;

        public CustomBufferBuilder(int bufferSizeIn, RenderType type) {
            super(bufferSizeIn);
            this.type = type;
        }

        public void func_181668_a(int glMode, VertexFormat format) {
        }

        public void func_178977_d() {
        }

        public IVertexBuilder func_227886_a_(int lightmapUV) {
            this.vertex.lu = lightmapUV;
            this.vertex.lv = lightmapUV;
            return this;
        }

        public IVertexBuilder func_227891_b_(int overlayUV) {
            return this;
        }

        public IVertexBuilder func_225582_a_(double x, double y, double z) {
            this.vertex.x = x;
            this.vertex.y = y;
            this.vertex.z = z;
            return this;
        }

        public IVertexBuilder func_225586_a_(int red, int green, int blue, int alpha) {
            this.vertex.r = red;
            this.vertex.g = green;
            this.vertex.b = blue;
            this.vertex.a = alpha;
            return this;
        }

        public IVertexBuilder func_225583_a_(float u, float v) {
            this.vertex.u = u;
            this.vertex.v = v;
            return this;
        }

        public IVertexBuilder func_225585_a_(int u, int v) {
            this.vertex.ou = u;
            this.vertex.ov = v;
            return this;
        }

        public IVertexBuilder func_225587_b_(int u, int v) {
            this.vertex.lu = u;
            this.vertex.lv = v;
            return this;
        }

        public IVertexBuilder func_225584_a_(float x, float y, float z) {
            this.vertex.nx = x;
            this.vertex.ny = y;
            this.vertex.nz = z;
            return this;
        }

        public void func_181675_d() {
            this.elements.add(new VertexElement(this.vertex, this.type));
            this.vertex = new Vertex();
        }

        public IVertexBuilder func_227885_a_(float red, float green, float blue, float alpha) {
            this.vertex.r = (int)(red * 255.0f);
            this.vertex.g = (int)(green * 255.0f);
            this.vertex.b = (int)(blue * 255.0f);
            this.vertex.a = (int)(alpha * 255.0f);
            return this;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Impl
    extends CustomBuffer {
        protected final CustomBufferBuilder buffer;
        protected final Map<RenderType, CustomBufferBuilder> fixedBuffers;
        protected final Set<BufferBuilder> startedBuffers = Sets.newHashSet();
        public ArrayList<BufferBuilder> builders = new ArrayList();
        protected Optional<RenderType> lastRenderType = Optional.empty();

        public Impl(CustomBufferBuilder bufferIn, Map<RenderType, CustomBufferBuilder> fixedBuffersIn) {
            this.buffer = bufferIn;
            this.fixedBuffers = fixedBuffersIn;
        }

        public ArrayList<IElement> getAllElements() {
            ArrayList<IElement> elements = new ArrayList<IElement>();
            for (BufferBuilder builder : this.builders) {
                elements.addAll(((CustomBufferBuilder)builder).elements);
            }
            elements.addAll(this.buffer.elements);
            return elements;
        }

        @Override
        public IVertexBuilder getBuffer(RenderType p_getBuffer_1_) {
            Optional optional = p_getBuffer_1_.func_230169_u_();
            CustomBufferBuilder bufferbuilder = this.getBufferRaw(p_getBuffer_1_);
            this.builders.add(bufferbuilder);
            if (!Objects.equals(this.lastRenderType, optional)) {
                RenderType rendertype;
                if (this.lastRenderType.isPresent() && !this.fixedBuffers.containsKey(rendertype = this.lastRenderType.get())) {
                    this.finish(rendertype);
                }
                if (this.startedBuffers.add(bufferbuilder)) {
                    bufferbuilder.func_181668_a(p_getBuffer_1_.func_228664_q_(), p_getBuffer_1_.func_228663_p_());
                }
                this.lastRenderType = optional;
            }
            return bufferbuilder;
        }

        private CustomBufferBuilder getBufferRaw(RenderType renderTypeIn) {
            return this.fixedBuffers.getOrDefault(renderTypeIn, this.buffer);
        }

        public void finish() {
            this.lastRenderType.ifPresent(p_228464_1_ -> {
                IVertexBuilder ivertexbuilder = this.getBuffer((RenderType)p_228464_1_);
                if (ivertexbuilder == this.buffer) {
                    this.finish((RenderType)p_228464_1_);
                }
            });
            for (RenderType rendertype : this.fixedBuffers.keySet()) {
                this.finish(rendertype);
            }
        }

        public void finish(RenderType renderTypeIn) {
            CustomBufferBuilder bufferbuilder = this.getBufferRaw(renderTypeIn);
            boolean flag = Objects.equals(this.lastRenderType, renderTypeIn.func_230169_u_());
            if ((flag || bufferbuilder != this.buffer) && this.startedBuffers.remove((Object)bufferbuilder)) {
                renderTypeIn.func_228631_a_((BufferBuilder)bufferbuilder, 0, 0, 0);
                if (flag) {
                    this.lastRenderType = Optional.empty();
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RegionRenderCacheBuilder {
        private final Map<RenderType, CustomBufferBuilder> builders = RenderType.func_228661_n_().stream().collect(Collectors.toMap(p_228369_0_ -> p_228369_0_, p_228368_0_ -> new CustomBufferBuilder(p_228368_0_.func_228662_o_(), (RenderType)p_228368_0_)));

        public CustomBufferBuilder getBuilder(RenderType renderTypeIn) {
            return this.builders.get(renderTypeIn);
        }

        public void resetBuilders() {
            this.builders.values().forEach(BufferBuilder::func_178965_a);
        }

        public void discardBuilders() {
            this.builders.values().forEach(BufferBuilder::func_227833_h_);
        }
    }

    public static interface IElement {
        public void addToBuffer(IRenderTypeBuffer.Impl var1);
    }
}

