/*
 * Decompiled with CFR 0.152.
 */
package com.tfc.smallerunits.utils.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tfc.smallerunits.utils.rendering.CustomBuffer;
import com.tfc.smallerunits.utils.rendering.RenderTypeHelper;
import com.tfc.smallerunits.utils.world.FakeServerWorld;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.LightType;

public class SUPseudoVBO {
    private final CustomBuffer buffer;

    public SUPseudoVBO(CustomBuffer buffer) {
        this.buffer = buffer;
    }

    public void render(IRenderTypeBuffer buffer1, MatrixStack matrixStack, int overworldLight, int combinedOverlay, FakeServerWorld world) {
        try {
            for (CustomBuffer.CustomVertexBuilder builder2 : this.buffer.builders) {
                IVertexBuilder builder1 = buffer1.getBuffer(RenderTypeHelper.getType(builder2.type));
                for (int i = 0; i < builder2.vertices.size(); i += 4) {
                    CustomBuffer.Vertex vert = builder2.vertices.get(i);
                    CustomBuffer.Vertex vert1 = builder2.vertices.get(i + 1);
                    CustomBuffer.Vertex vert2 = builder2.vertices.get(i + 2);
                    CustomBuffer.Vertex vert3 = builder2.vertices.get(i + 3);
                    this.drawFace(vert, vert1, vert2, vert3, matrixStack, overworldLight, world, builder1, combinedOverlay);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void drawFace(CustomBuffer.Vertex vertex1, CustomBuffer.Vertex vertex2, CustomBuffer.Vertex vertex3, CustomBuffer.Vertex vertex4, MatrixStack matrixStack, int overworldLight, FakeServerWorld world, IVertexBuilder builder1, int combinedOverlay) {
        Vector3f normalU = new Vector3f((float)vertex1.x, (float)vertex1.y, (float)vertex1.z);
        Vector3f normalV = normalU.func_229195_e_();
        Vector3f workingVec = new Vector3f((float)vertex2.x, (float)vertex2.y, (float)vertex2.z);
        workingVec.func_195904_b((float)vertex4.x, (float)vertex4.y, (float)vertex4.z);
        workingVec.func_195898_a(0.5f);
        normalU.func_195897_a(workingVec);
        workingVec = new Vector3f((float)vertex3.x, (float)vertex3.y, (float)vertex3.z);
        workingVec.func_195904_b((float)vertex4.x, (float)vertex4.y, (float)vertex4.z);
        workingVec.func_195898_a(0.5f);
        normalV.func_195897_a(workingVec);
        Vector3f normal = new Vector3f(normalU.func_195900_b() * normalV.func_195902_c() - normalU.func_195902_c() * normalV.func_195900_b(), normalU.func_195902_c() * normalV.func_195899_a() - normalU.func_195899_a() * normalV.func_195902_c(), normalU.func_195899_a() * normalV.func_195900_b() - normalU.func_195900_b() * normalV.func_195899_a());
        normal.func_229194_d_();
        normal.setX(-Math.abs(normal.func_195899_a()));
        normal.setY(normal.func_195900_b());
        normal.setZ(-Math.abs(normal.func_195902_c()));
        this.drawVertex(vertex1, new Vector3d((double)normal.func_195899_a(), (double)normal.func_195900_b(), (double)normal.func_195902_c()), matrixStack, overworldLight, world, builder1, combinedOverlay);
        this.drawVertex(vertex2, new Vector3d((double)normal.func_195899_a(), (double)normal.func_195900_b(), (double)normal.func_195902_c()), matrixStack, overworldLight, world, builder1, combinedOverlay);
        this.drawVertex(vertex3, new Vector3d((double)normal.func_195899_a(), (double)normal.func_195900_b(), (double)normal.func_195902_c()), matrixStack, overworldLight, world, builder1, combinedOverlay);
        this.drawVertex(vertex4, new Vector3d((double)normal.func_195899_a(), (double)normal.func_195900_b(), (double)normal.func_195902_c()), matrixStack, overworldLight, world, builder1, combinedOverlay);
    }

    public void drawVertex(CustomBuffer.Vertex vert, Vector3d normal, MatrixStack matrixStack, int overworldLight, FakeServerWorld world, IVertexBuilder builder1, int combinedOverlay) {
        double amt;
        Vector3f normal1;
        Vector3f vector3f = this.translate(matrixStack, (float)vert.x, (float)vert.y, (float)vert.z);
        BlockPos posLight = vert.pos;
        if (Minecraft.func_71410_x().field_71474_y.field_74348_k.equals((Object)AmbientOcclusionStatus.MAX)) {
            int offY;
            int offX;
            normal1 = new Vector3f(vert.nx, vert.ny, vert.nz);
            normal1.func_229194_d_();
            Vector3d offset = new Vector3d(vert.x * (double)world.owner.unitsPerBlock - (double)posLight.func_177958_n(), vert.y * (double)world.owner.unitsPerBlock - (double)(posLight.func_177956_o() - 64), vert.z * (double)world.owner.unitsPerBlock - (double)posLight.func_177952_p());
            int n = offset.func_82615_a() == 0.0 ? 0 : (offX = offset.func_82615_a() == 1.0 ? 1 : 0);
            int n2 = offset.func_82617_b() == 0.0 ? 0 : (offY = offset.func_82617_b() == 1.0 ? 1 : 0);
            int offZ = offset.func_82616_c() == 0.0 ? 0 : (offset.func_82616_c() == 1.0 ? 1 : 0);
            posLight = new BlockPos(posLight.func_177958_n() + offX, posLight.func_177956_o() + offY, posLight.func_177952_p() + offZ);
        } else {
            normal1 = new Vector3f(vert.nx, vert.ny, vert.nz);
            normal1.func_229194_d_();
            posLight = posLight.func_177982_a(-Math.round(normal1.func_195899_a()), -Math.round(normal1.func_195900_b()), -Math.round(normal1.func_195902_c()));
        }
        int overworldSky = LightTexture.func_228454_b_((int)overworldLight);
        int overworldBlock = LightTexture.func_228450_a_((int)overworldLight);
        int blockLight = world.func_226658_a_(LightType.BLOCK, posLight);
        int skyLight = world.func_226658_a_(LightType.SKY, posLight);
        if (normal.field_72448_b != 0.0) {
            normal = new Vector3d(0.0, -normal.field_72448_b, 0.0);
        }
        if (vert.nx != 0.0f || vert.ny != 1.0f || vert.nz != 0.0f) {
            normal = new Vector3d((double)vert.nx, (double)vert.ny, (double)vert.nz);
        }
        if (Double.isNaN(amt = (normal = normal.func_72432_b()).func_72430_b(new Vector3d(1.0, 0.0, 0.5).func_72432_b()))) {
            amt = 1.0;
        }
        amt = Math.abs(amt);
        amt /= 2.25;
        amt = 1.0 - amt;
        if (normal.field_72448_b > 0.0) {
            amt /= 2.15;
        }
        builder1.func_225588_a_(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c(), (float)((double)vert.r * amt) / 255.0f, (float)((double)vert.g * amt) / 255.0f, (float)((double)vert.b * amt) / 255.0f, (float)vert.a / 255.0f, vert.u, vert.v, combinedOverlay, LightTexture.func_228451_a_((int)Math.max(overworldBlock, blockLight), (int)Math.max(overworldSky, skyLight)), (float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c);
    }

    public Vector3f translate(MatrixStack stack, float x, float y, float z) {
        Vector4f vector4f = new Vector4f(x, y, z, 1.0f);
        vector4f.func_229372_a_(stack.func_227866_c_().func_227870_a_());
        return new Vector3f(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c());
    }
}

