/*
 * Decompiled with CFR 0.152.
 */
package com.tfc.smallerunits.utils.world;

import com.tfc.smallerunits.block.UnitTileEntity;
import com.tfc.smallerunits.registry.Deferred;
import com.tfc.smallerunits.utils.ExternalUnitInteractionContext;
import com.tfc.smallerunits.utils.world.FakeServerWorld;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.ChunkTaskPriorityQueueSorter;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.IWorldLightListener;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorldLightManager;

public class FakeLightingManager
extends ServerWorldLightManager {
    private WorldLightManager lightManager;
    private ChunkManager manager;
    private int lastSize = 0;
    private int[] lighting = new int[0];
    private int lastX = 0;
    private int lastY = 0;
    private int lastZ = 0;
    int recursionDepth = 0;

    public FakeLightingManager(IChunkLightProvider provider, ChunkManager chunkManagerIn, boolean hasSkyLight, DelegatedTaskExecutor<Runnable> p_i50701_4_, ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>> p_i50701_5_, FakeServerWorld world) {
        super(provider, chunkManagerIn, hasSkyLight, p_i50701_4_, p_i50701_5_);
        this.lightManager = new WorldLightManager(provider, true, hasSkyLight);
        this.manager = chunkManagerIn;
    }

    public void func_215568_a(BlockPos blockPosIn) {
        this.lightManager.func_215568_a(blockPosIn);
    }

    public int func_215575_a(int toUpdateCount, boolean updateSkyLight, boolean updateBlockLight) {
        int i;
        FakeServerWorld world = (FakeServerWorld)this.manager.field_219255_i;
        if (this.lastSize != world.owner.unitsPerBlock) {
            this.lighting = new int[world.owner.unitsPerBlock * world.owner.unitsPerBlock * world.owner.unitsPerBlock];
            this.lastSize = world.owner.unitsPerBlock;
        }
        for (i = 0; i < toUpdateCount; ++i) {
            BlockPos pos;
            ++this.lastX;
            if (this.lastX > world.owner.unitsPerBlock - 1) {
                ++this.lastZ;
                this.lastX = 0;
                if (this.lastZ > world.owner.unitsPerBlock - 1) {
                    ++this.lastY;
                    this.lastZ = 0;
                    if (this.lastY > world.owner.unitsPerBlock - 1) {
                        this.lastY = 0;
                        break;
                    }
                }
            }
            if (this.testLight(pos = new BlockPos(this.lastX, this.lastY, this.lastZ), world) || this.testLight(pos = new BlockPos(world.owner.unitsPerBlock - 1 - this.lastX, world.owner.unitsPerBlock - 1 - this.lastY, world.owner.unitsPerBlock - 1 - this.lastZ), world)) break;
        }
        return i;
    }

    private boolean testLight(BlockPos pos, FakeServerWorld world) {
        if (this.isInbounds(pos, world.owner.unitsPerBlock)) {
            int stateLight;
            BlockState state = world.func_180495_p(pos.func_177982_a(0, 64, 0));
            int max = stateLight = state.getLightValue((IBlockReader)world, pos.func_177982_a(0, 64, 0));
            for (Direction dir : Direction.values()) {
                if (this.isInbounds(pos.func_177972_a(dir), world.owner.unitsPerBlock)) {
                    int amt = this.lighting[this.toIndex(pos.func_177972_a(dir))];
                    max = Math.max(max, amt - 1);
                    continue;
                }
                ExternalUnitInteractionContext context = new ExternalUnitInteractionContext(world, pos.func_177972_a(dir).func_177982_a(0, 64, 0));
                if (context.stateInRealWorld == null || !context.stateInRealWorld.equals(((Block)Deferred.UNIT.get()).func_176223_P()) || context.posInRealWorld.equals((Object)world.owner.func_174877_v()) || context.teInRealWorld == null || context.teInRealWorld.equals((Object)world.owner) || this.recursionDepth >= 1) continue;
                ++this.recursionDepth;
                int amt = ((UnitTileEntity)context.teInRealWorld).field_145850_b.func_226658_a_(LightType.BLOCK, context.posInFakeWorld);
                max = Math.max(max, amt - 1);
                --this.recursionDepth;
            }
            if (stateLight == 0) {
                max -= state.func_200016_a((IBlockReader)this.manager.field_219255_i, pos.func_177982_a(0, 64, 0));
            }
            this.lighting[this.toIndex((BlockPos)pos)] = max;
            return false;
        }
        this.lastX = 0;
        this.lastY = 0;
        this.lastZ = 0;
        return true;
    }

    public boolean isInbounds(BlockPos pos, int upb) {
        return pos.func_177958_n() >= 0 && pos.func_177958_n() <= upb - 1 && pos.func_177952_p() >= 0 && pos.func_177952_p() <= upb - 1 && pos.func_177956_o() >= 0 && pos.func_177956_o() <= upb - 1 && this.toIndex(pos) >= 0 && this.toIndex(pos) < this.lighting.length;
    }

    public int getBlockLight(BlockPos pos) {
        if (this.isInbounds(pos, ((FakeServerWorld)this.manager.field_219255_i).owner.unitsPerBlock)) {
            if (this.manager.field_219255_i.field_72995_K) {
                this.testLight(pos, (FakeServerWorld)this.manager.field_219255_i);
            }
            return this.lighting[this.toIndex(pos)];
        }
        for (Direction value : Direction.values()) {
            if (!this.isInbounds(pos.func_177972_a(value), ((FakeServerWorld)this.manager.field_219255_i).owner.unitsPerBlock)) continue;
            return this.lighting[this.toIndex(pos.func_177972_a(value))] - 10;
        }
        return 0;
    }

    public int toIndex(BlockPos pos) {
        return pos.func_177958_n() + pos.func_177956_o() * ((FakeServerWorld)this.manager.field_219255_i).owner.unitsPerBlock + pos.func_177952_p() * ((FakeServerWorld)this.manager.field_219255_i).owner.unitsPerBlock * ((FakeServerWorld)this.manager.field_219255_i).owner.unitsPerBlock;
    }

    public boolean func_215570_a() {
        return this.lightManager.func_215570_a();
    }

    public IWorldLightListener func_215569_a(LightType type) {
        return this.lightManager.func_215569_a(type);
    }

    public String func_215572_a(LightType p_215572_1_, SectionPos p_215572_2_) {
        return this.lightManager.func_215572_a(p_215572_1_, p_215572_2_);
    }

    public int func_227470_b_(BlockPos blockPosIn, int amount) {
        return this.lightManager.func_227470_b_(blockPosIn, amount);
    }

    public void func_215573_a(BlockPos blockPosIn, int p_215573_2_) {
        this.lightManager.func_215573_a(blockPosIn, p_215573_2_);
    }

    protected void func_215581_a(ChunkPos p_215581_1_) {
        for (int i = 64; i < 80; ++i) {
            this.lightManager.func_215566_a(SectionPos.func_218156_a((ChunkPos)p_215581_1_, (int)i), false);
        }
    }

    public void func_215566_a(SectionPos pos, boolean isEmpty) {
        this.lightManager.func_215566_a(pos, isEmpty);
    }

    public void func_215571_a(ChunkPos p_215571_1_, boolean p_215571_2_) {
        this.lightManager.func_215571_a(p_215571_1_, p_215571_2_);
    }

    public void func_215574_a(LightType type, SectionPos pos, @Nullable NibbleArray array, boolean p_215574_4_) {
        this.lightManager.func_215574_a(type, pos, array, p_215574_4_);
    }

    public void func_223115_b(ChunkPos pos, boolean retain) {
        this.lightManager.func_223115_b(pos, retain);
    }

    public void func_215567_a(BlockPos p_215567_1_, boolean p_215567_2_) {
        this.lightManager.func_215567_a(p_215567_1_, p_215567_2_);
    }
}

