/*
 * Decompiled with CFR 0.152.
 */
package com.tfc.smallerunits.utils.world;

import com.tfc.smallerunits.block.UnitTileEntity;
import com.tfc.smallerunits.registry.Deferred;
import com.tfc.smallerunits.utils.ExternalUnitInteractionContext;
import com.tfc.smallerunits.utils.SmallUnit;
import com.tfc.smallerunits.utils.world.FakeChunk;
import com.tfc.smallerunits.utils.world.FakeLightingManager;
import com.tfc.smallerunits.utils.world.FakeServerChunkProvider;
import com.tfc.smallerunits.utils.world.FakeServerTickList;
import com.tfc.smallerunits.utils.world.FakeServerWorldInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.concurrent.DelegatedTaskExecutor;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.ChunkTaskPriorityQueueSorter;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import sun.misc.Unsafe;

public class FakeServerWorld
extends ServerWorld {
    private static final WorldBorder border = new WorldBorder();
    private static final Unsafe theUnsafe;
    private static final LongSet forcedChunks;
    public HashMap<BlockPos, SmallUnit> blockMap;
    public ArrayList<SmallUnit> tileEntityChanges;
    public ArrayList<BlockPos> tileEntityPoses;
    public WorldLightManager lightManager;
    public UnitTileEntity owner;
    private boolean hasInit = false;
    private boolean isFirstTick;
    private IChunk chunk;
    private Profiler blankProfiler;
    public boolean isRendering = false;

    public FakeServerWorld(MinecraftServer p_i241885_1_, Executor p_i241885_2_, SaveFormat.LevelSave p_i241885_3_, IServerWorldInfo p_i241885_4_, RegistryKey<World> p_i241885_5_, DimensionType p_i241885_6_, IChunkStatusListener p_i241885_7_, ChunkGenerator p_i241885_8_, boolean p_i241885_9_, long p_i241885_10_, List<ISpecialSpawner> p_i241885_12_, boolean p_i241885_13_) {
        super(p_i241885_1_, p_i241885_2_, p_i241885_3_, p_i241885_4_, p_i241885_5_, p_i241885_6_, p_i241885_7_, p_i241885_8_, p_i241885_9_, p_i241885_10_, p_i241885_12_, p_i241885_13_);
    }

    public void func_175690_a(BlockPos pos, @Nullable TileEntity tileEntityIn) {
        ExternalUnitInteractionContext context = new ExternalUnitInteractionContext(this, pos);
        if (context.stateInRealWorld != null && context.stateInRealWorld.equals(((Block)Deferred.UNIT.get()).func_176223_P()) && !context.posInRealWorld.equals((Object)this.owner.func_174877_v()) && context.teInRealWorld != null) {
            ((UnitTileEntity)context.teInRealWorld).field_145850_b.func_175690_a(context.posInFakeWorld, tileEntityIn);
            return;
        }
        SmallUnit unit = this.blockMap.getOrDefault(pos, new SmallUnit(pos, Blocks.field_150350_a.func_176223_P()));
        if (unit.tileEntity != null) {
            this.field_147482_g.remove(tileEntityIn);
        }
        if (tileEntityIn != null && tileEntityIn.func_200662_C().func_223045_a(unit.state.func_177230_c())) {
            unit.tileEntity = tileEntityIn;
            tileEntityIn.func_226984_a_((World)this, pos);
            this.field_147482_g.add(unit.tileEntity);
            if (!this.blockMap.containsKey(pos)) {
                this.blockMap.put(pos, unit);
            }
        } else {
            unit.tileEntity = null;
        }
        this.tileEntityChanges.add(unit);
    }

    public void func_175713_t(BlockPos pos) {
        SmallUnit unit = this.blockMap.getOrDefault(pos, new SmallUnit(pos, Blocks.field_150350_a.func_176223_P()));
        this.field_147482_g.remove(unit.tileEntity);
        this.tileEntityChanges.add(unit);
        unit.tileEntity = null;
    }

    public void init(UnitTileEntity owner) {
        if (!this.hasInit) {
            this.tileEntityChanges = new ArrayList();
            this.owner = owner;
            this.hasInit = true;
            this.field_241102_C_ = null;
            this.blockMap = new HashMap();
            this.tileEntityPoses = new ArrayList();
            this.chunk = new FakeChunk(this);
            final FakeServerWorld world = this;
            this.field_241102_C_ = FakeServerChunkProvider.getProvider(this);
            DelegatedTaskExecutor delegatedtaskexecutor1 = DelegatedTaskExecutor.func_213144_a(Runnable::run, (String)"light");
            ITaskExecutor unitExecutor = ITaskExecutor.func_213140_a((String)"idk", unit -> {});
            ITaskExecutor itaskexecutor = ITaskExecutor.func_213140_a((String)"su_world", entry -> ((Runnable)entry.field_219428_a.apply(unitExecutor)).run());
            this.lightManager = new FakeLightingManager(new IChunkLightProvider(){

                @Nullable
                public IBlockReader func_217202_b(int chunkX, int chunkZ) {
                    return world;
                }

                public IBlockReader func_212864_k_() {
                    return world;
                }
            }, this.func_72863_F().field_217237_a, true, (DelegatedTaskExecutor<Runnable>)delegatedtaskexecutor1, (ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>>)itaskexecutor, this);
            this.field_94579_S = new FakeServerTickList<Block>(this, p_205341_0_ -> p_205341_0_ == null || p_205341_0_.func_176223_P().func_196958_f(), arg_0 -> ((DefaultedRegistry)Registry.field_212618_g).func_177774_c(arg_0), arg_0 -> ((FakeServerWorld)this).func_205338_b(arg_0), true);
            this.field_205342_P = new FakeServerTickList<Fluid>(this, p_205774_0_ -> p_205774_0_ == null || p_205774_0_ == Fluids.field_204541_a, arg_0 -> ((DefaultedRegistry)Registry.field_212619_h).func_177774_c(arg_0), arg_0 -> ((FakeServerWorld)this).func_205339_a(arg_0), false);
            this.field_241103_E_ = new FakeServerWorldInfo(this);
            this.field_72986_A = this.field_241103_E_;
            this.field_73012_v = new Random();
            this.blankProfiler = new Profiler(() -> 0L, () -> 0, false);
            this.field_72984_F = () -> this.blankProfiler;
            this.field_175728_M = border;
            this.isFirstTick = true;
            this.field_147490_S = new ObjectLinkedOpenHashSet();
            this.field_217491_A = new ArrayList();
            this.field_217499_z = new PriorityQueue();
            this.field_175741_N = new Object2ObjectLinkedOpenHashMap();
            this.field_217498_x = new Int2ObjectArrayMap();
            try {
                theUnsafe.getAndSetObject((Object)this, theUnsafe.objectFieldOffset(ObfuscationReflectionHelper.findField(World.class, (String)"field_147483_b")), Collections.newSetFromMap(new IdentityHashMap()));
            }
            catch (Throwable err) {
                throw new RuntimeException(err);
            }
            this.field_175730_i = new ArrayList();
            this.field_147482_g = new ArrayList();
            this.field_147484_a = new ArrayList();
        }
    }

    public long func_82737_E() {
        return this.owner.func_145831_w() == null ? 0L : this.owner.func_145831_w().func_82737_E();
    }

    public long func_72820_D() {
        return this.owner.func_145831_w().func_72820_D();
    }

    public boolean func_72935_r() {
        return this.owner.func_145831_w().func_72935_r();
    }

    public boolean func_226690_K_() {
        return this.owner.field_145850_b.func_226690_K_();
    }

    public boolean func_226660_f_(BlockPos blockPosIn) {
        return this.owner.func_145831_w().func_226660_f_(this.owner.func_174877_v());
    }

    public boolean func_175710_j(BlockPos pos) {
        return this.func_226660_f_(pos);
    }

    public LongSet func_217469_z() {
        return forcedChunks;
    }

    public BlockState func_180495_p(BlockPos pos) {
        ExternalUnitInteractionContext context = new ExternalUnitInteractionContext(this, pos);
        if (context.stateInRealWorld != null) {
            if (context.stateInRealWorld.equals(((Block)Deferred.UNIT.get()).func_176223_P())) {
                if (!context.posInRealWorld.equals((Object)this.owner.func_174877_v())) {
                    if (!this.isRendering) {
                        return ((UnitTileEntity)context.teInRealWorld).field_145850_b.func_180495_p(context.posInFakeWorld);
                    }
                    return ((UnitTileEntity)context.teInRealWorld).field_145850_b.func_180495_p(context.posInFakeWorld).func_204520_s().func_206883_i();
                }
            } else {
                if (context.stateInRealWorld.equals(Blocks.field_150357_h.func_176223_P())) {
                    return Blocks.field_150357_h.func_176223_P();
                }
                if (context.stateInRealWorld.equals(Blocks.field_180401_cv.func_176223_P())) {
                    return Blocks.field_180401_cv.func_176223_P();
                }
            }
        }
        return this.blockMap.getOrDefault((Object)pos, (SmallUnit)new SmallUnit((BlockPos)pos, (BlockState)Blocks.field_150350_a.func_176223_P())).state;
    }

    public RecipeManager func_199532_z() {
        return this.owner.func_145831_w().func_199532_z();
    }

    public void func_241123_a_(boolean p_241123_1_, boolean p_241123_2_) {
    }

    public Biome func_226691_t_(BlockPos pos) {
        return this.owner.func_145831_w().func_226691_t_(pos);
    }

    public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        return this.chunk;
    }

    public void func_72835_b(BooleanSupplier hasTimeLeft) {
        if (this.isFirstTick) {
            this.field_73011_w = this.owner.func_145831_w().field_73011_w;
            this.field_234921_x_ = this.owner.func_145831_w().field_234921_x_;
            this.field_217494_c = new RaidManager((ServerWorld)this);
            this.isFirstTick = false;
            this.field_73061_a = this.owner.func_145831_w().func_73046_m();
            this.field_72995_K = this.owner.func_145831_w().field_72995_K;
        }
        if (this.field_72995_K) {
            for (SmallUnit value : this.blockMap.values()) {
                if (!(value.tileEntity instanceof ITickableTileEntity)) continue;
                ((ITickableTileEntity)value.tileEntity).func_73660_a();
            }
            return;
        }
        for (SmallUnit value : this.blockMap.values()) {
            if (value.tileEntity == null) continue;
            if (!this.field_147482_g.contains(value.tileEntity)) {
                this.field_147482_g.add(value.tileEntity);
                this.tileEntityChanges.add(value);
            }
            if (!this.field_72995_K || !(value.tileEntity instanceof ITickableTileEntity)) continue;
            try {
                ((ITickableTileEntity)value.tileEntity).func_73660_a();
            }
            catch (Throwable throwable) {}
        }
        if (!this.field_72995_K) {
            this.lightManager.func_215575_a(100, false, true);
        }
        this.blankProfiler.func_219894_a();
        super.func_72835_b(hasTimeLeft);
        this.blankProfiler.func_219897_b();
        for (int i = 0; i < Math.max(1, this.owner.unitsPerBlock / 4) * this.owner.field_145850_b.func_82736_K().func_223592_c(GameRules.field_223610_m); ++i) {
            int z;
            int y;
            int x = this.field_73012_v.nextInt(this.owner.unitsPerBlock);
            BlockPos randTickPos = new BlockPos(x, (y = this.field_73012_v.nextInt(this.owner.unitsPerBlock)) + 64, z = this.field_73012_v.nextInt(this.owner.unitsPerBlock));
            BlockState state = this.func_180495_p(randTickPos);
            if (!state.func_204519_t()) continue;
            state.func_227034_b_((ServerWorld)this, randTickPos, this.field_73012_v);
        }
        ArrayList<TileEntity> toRemove = new ArrayList<TileEntity>();
        for (SmallUnit unit : this.tileEntityChanges) {
            if (unit.tileEntity != null) {
                if (!this.field_175730_i.contains(unit.tileEntity) && unit.tileEntity instanceof ITickableTileEntity) {
                    this.field_175730_i.add(unit.tileEntity);
                }
                if (!this.field_147482_g.contains(unit.tileEntity)) {
                    this.field_147482_g.add(unit.tileEntity);
                }
            }
            unit.oldTE = unit.tileEntity;
        }
        for (TileEntity tileEntity : this.field_147482_g) {
            if (tileEntity.func_200662_C().func_223045_a(this.func_180495_p(tileEntity.func_174877_v()).func_177230_c())) continue;
            toRemove.add(tileEntity);
        }
        this.field_147482_g.removeAll(toRemove);
        this.field_175730_i.removeAll(toRemove);
        this.tileEntityChanges.clear();
    }

    public Difficulty func_175659_aa() {
        return this.owner.func_145831_w().func_175659_aa();
    }

    public void func_147488_Z() {
        if (this.field_72995_K) {
            return;
        }
        super.func_147488_Z();
    }

    public <T extends IParticleData> int func_195598_a(T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        if (this.owner.func_145831_w() instanceof ServerWorld) {
            return ((ServerWorld)this.owner.func_145831_w()).func_195598_a(type, (double)this.owner.func_174877_v().func_177958_n() + posX / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177956_o() + (posY - 64.0) / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177952_p() + posZ / (double)this.owner.unitsPerBlock, particleCount / this.owner.unitsPerBlock, xOffset / (double)this.owner.unitsPerBlock, yOffset / (double)this.owner.unitsPerBlock, zOffset / (double)this.owner.unitsPerBlock, speed / (double)this.owner.unitsPerBlock);
        }
        return super.func_195598_a(type, (double)this.owner.func_174877_v().func_177958_n() + posX / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177956_o() + (posY - 64.0) / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177952_p() + posZ / (double)this.owner.unitsPerBlock, particleCount / this.owner.unitsPerBlock, xOffset / (double)this.owner.unitsPerBlock, yOffset / (double)this.owner.unitsPerBlock, zOffset / (double)this.owner.unitsPerBlock, speed / (double)this.owner.unitsPerBlock);
    }

    public <T extends IParticleData> boolean func_195600_a(ServerPlayerEntity player, T type, boolean longDistance, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        if (this.owner.func_145831_w() instanceof ServerWorld) {
            return ((ServerWorld)this.owner.func_145831_w()).func_195600_a(player, type, longDistance, (double)this.owner.func_174877_v().func_177958_n() + posX / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177956_o() + (posY - 64.0) / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177952_p() + posZ / (double)this.owner.unitsPerBlock, particleCount / this.owner.unitsPerBlock, xOffset / (double)this.owner.unitsPerBlock, yOffset / (double)this.owner.unitsPerBlock, zOffset / (double)this.owner.unitsPerBlock, speed / (double)this.owner.unitsPerBlock);
        }
        return super.func_195600_a(player, type, longDistance, (double)this.owner.func_174877_v().func_177958_n() + posX / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177956_o() + (posY - 64.0) / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177952_p() + posZ / (double)this.owner.unitsPerBlock, particleCount / this.owner.unitsPerBlock, xOffset / (double)this.owner.unitsPerBlock, yOffset / (double)this.owner.unitsPerBlock, zOffset / (double)this.owner.unitsPerBlock, speed / (double)this.owner.unitsPerBlock);
    }

    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.owner.func_145831_w().func_195594_a(particleData, (double)this.owner.func_174877_v().func_177958_n() + x / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177956_o() + (y - 64.0) / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177952_p() + z / (double)this.owner.unitsPerBlock, xSpeed / (double)this.owner.unitsPerBlock, ySpeed / (double)this.owner.unitsPerBlock, zSpeed / (double)this.owner.unitsPerBlock);
    }

    public void func_195590_a(IParticleData particleData, boolean forceAlwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.owner.func_145831_w().func_195590_a(particleData, forceAlwaysRender, (double)this.owner.func_174877_v().func_177958_n() + x / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177956_o() + (y - 64.0) / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177952_p() + z / (double)this.owner.unitsPerBlock, xSpeed / (double)this.owner.unitsPerBlock, ySpeed / (double)this.owner.unitsPerBlock, zSpeed / (double)this.owner.unitsPerBlock);
    }

    public void func_195589_b(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.owner.func_145831_w().func_195589_b(particleData, (double)this.owner.func_174877_v().func_177958_n() + x / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177956_o() + (y - 64.0) / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177952_p() + z / (double)this.owner.unitsPerBlock, xSpeed / (double)this.owner.unitsPerBlock, ySpeed / (double)this.owner.unitsPerBlock, zSpeed / (double)this.owner.unitsPerBlock);
    }

    public void func_217404_b(IParticleData particleData, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.owner.func_145831_w().func_217404_b(particleData, ignoreRange, (double)this.owner.func_174877_v().func_177958_n() + x / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177956_o() + (y - 64.0) / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177952_p() + z / (double)this.owner.unitsPerBlock, xSpeed / (double)this.owner.unitsPerBlock, ySpeed / (double)this.owner.unitsPerBlock, zSpeed / (double)this.owner.unitsPerBlock);
    }

    public int func_226658_a_(LightType lightTypeIn, BlockPos blockPosIn) {
        if (lightTypeIn.equals((Object)LightType.BLOCK)) {
            ExternalUnitInteractionContext context = new ExternalUnitInteractionContext(this, blockPosIn);
            if (context.stateInRealWorld != null && context.stateInRealWorld.equals(((Block)Deferred.UNIT.get()).func_176223_P()) && !context.posInRealWorld.equals((Object)this.owner.func_174877_v()) && context.teInRealWorld != null) {
                return ((UnitTileEntity)context.teInRealWorld).field_145850_b.func_226658_a_(lightTypeIn, context.posInFakeWorld);
            }
        }
        if (lightTypeIn.equals((Object)LightType.BLOCK)) {
            return Math.max(((FakeLightingManager)this.lightManager).getBlockLight(blockPosIn.func_177967_a(Direction.DOWN, 64)), this.owner.func_145831_w().func_226658_a_(lightTypeIn, this.owner.func_174877_v()));
        }
        return Math.max(this.lightManager.func_215569_a(lightTypeIn).func_215611_b(blockPosIn), this.owner.func_145831_w().func_226658_a_(lightTypeIn, this.owner.func_174877_v()));
    }

    public int func_226659_b_(BlockPos blockPosIn, int amount) {
        return Math.max(this.lightManager.func_227470_b_(blockPosIn, amount), this.owner.func_145831_w().func_226659_b_(this.owner.func_174877_v(), amount));
    }

    public int func_217298_h(BlockPos pos) {
        return Math.max(this.func_226658_a_(LightType.BLOCK, pos), this.func_226658_a_(LightType.SKY, pos));
    }

    public Chunk func_212866_a_(int chunkX, int chunkZ) {
        return new Chunk((World)this, new ChunkPos(chunkX, chunkZ), new BiomeContainer((IObjectIntIterable)new ObjectIntIdentityMap()));
    }

    public WorldLightManager func_225524_e_() {
        return this.lightManager;
    }

    public void func_184148_a(@Nullable PlayerEntity player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        this.owner.func_145831_w().func_184148_a(player, (double)this.owner.func_174877_v().func_177958_n() + x / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177956_o() + (y - 64.0) / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177952_p() + z / (double)this.owner.unitsPerBlock, soundIn, category, volume / (float)this.owner.unitsPerBlock, pitch);
    }

    public void func_217378_a(@Nullable PlayerEntity player, int type, BlockPos pos, int data) {
        this.field_72995_K = this.owner.func_145831_w().field_72995_K;
        Random random = this.field_73012_v;
        switch (type) {
            case 1000: {
                this.func_184133_a(null, pos, SoundEvents.field_187574_as, SoundCategory.BLOCKS, 1.0f, 1.2f);
                break;
            }
            case 1001: {
                this.func_184133_a(null, pos, SoundEvents.field_187576_at, SoundCategory.BLOCKS, 1.0f, 1.2f);
                break;
            }
            case 1002: {
                this.func_184133_a(null, pos, SoundEvents.field_187578_au, SoundCategory.BLOCKS, 1.0f, 1.2f);
                break;
            }
            case 1005: {
                this.func_184133_a(null, pos, SoundEvents.field_187611_cI, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1006: {
                this.func_184133_a(null, pos, SoundEvents.field_187875_gN, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1007: {
                this.func_184133_a(null, pos, SoundEvents.field_187879_gP, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1008: {
                this.func_184133_a(null, pos, SoundEvents.field_187613_bi, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1009: {
                this.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
                break;
            }
            case 1011: {
                this.func_184133_a(null, pos, SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1012: {
                this.func_184133_a(null, pos, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1013: {
                this.func_184133_a(null, pos, SoundEvents.field_187877_gO, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1014: {
                this.func_184133_a(null, pos, SoundEvents.field_187610_bh, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            default: {
                if (!this.field_72995_K) {
                    this.owner.func_145831_w().func_73046_m().func_184103_al().func_148543_a(player, (double)this.owner.func_174877_v().func_177958_n() + (double)((float)pos.func_177958_n() / (float)this.owner.unitsPerBlock), (double)this.owner.func_174877_v().func_177956_o() + (double)((float)(pos.func_177956_o() - 64) / (float)this.owner.unitsPerBlock), (double)this.owner.func_174877_v().func_177952_p() + (double)((float)pos.func_177952_p() / (float)this.owner.unitsPerBlock), 64.0, this.owner.func_145831_w().func_234923_W_(), (IPacket)new SPlaySoundEventPacket(type, this.owner.func_174877_v(), data, false));
                    break;
                }
                this.owner.func_145831_w().func_217378_a(player, type, this.owner.func_174877_v(), data);
            }
        }
    }

    public void func_217384_a(@Nullable PlayerEntity playerIn, Entity entityIn, SoundEvent eventIn, SoundCategory categoryIn, float volume, float pitch) {
        this.func_184148_a(playerIn, entityIn.func_213303_ch().field_72450_a, entityIn.func_213303_ch().field_72448_b, entityIn.func_213303_ch().field_72449_c, eventIn, categoryIn, volume, pitch);
    }

    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        this.func_184148_a(null, x, y, z, soundIn, category, volume, pitch);
    }

    public void func_184133_a(@Nullable PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        this.func_184148_a(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), soundIn, category, volume, pitch);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        ExternalUnitInteractionContext context = new ExternalUnitInteractionContext(this, pos);
        if (context.stateInRealWorld != null && context.stateInRealWorld.equals(((Block)Deferred.UNIT.get()).func_176223_P()) && !context.posInRealWorld.equals((Object)this.owner.func_174877_v()) && context.teInRealWorld != null) {
            return ((UnitTileEntity)context.teInRealWorld).field_145850_b.func_175625_s(context.posInFakeWorld);
        }
        return this.blockMap.getOrDefault((Object)pos, (SmallUnit)new SmallUnit((BlockPos)pos, (BlockState)Blocks.field_150350_a.func_176223_P())).tileEntity;
    }

    public boolean func_241211_a_(BlockPos pos, BlockState state, int flags, int recursionLeft) {
        ExternalUnitInteractionContext context = new ExternalUnitInteractionContext(this, pos);
        if (recursionLeft < 0) {
            return false;
        }
        if (context.stateInRealWorld != null && !context.posInRealWorld.equals((Object)this.owner.func_174877_v())) {
            if (context.stateInRealWorld.equals(((Block)Deferred.UNIT.get()).func_176223_P())) {
                if (!context.posInRealWorld.equals((Object)this.owner.func_174877_v())) {
                    return ((UnitTileEntity)context.teInRealWorld).field_145850_b.func_241211_a_(context.posInFakeWorld, state, flags, recursionLeft - 1);
                }
                return false;
            }
            if (context.stateInRealWorld.isAir((IBlockReader)this.owner.func_145831_w(), context.posInRealWorld)) {
                // empty if block
            }
        }
        if (World.func_189509_E((BlockPos)context.posInRealWorld)) {
            return false;
        }
        this.owner.func_70296_d();
        this.owner.func_145831_w().func_184138_a(this.owner.func_174877_v(), state, state, 3);
        IChunk chunk = this.chunk;
        pos = pos.func_185334_h();
        BlockSnapshot blockSnapshot = null;
        if (this.captureBlockSnapshots && !this.field_72995_K) {
            blockSnapshot = BlockSnapshot.create((RegistryKey)this.field_73011_w, (IWorld)this, (BlockPos)pos, (int)flags);
            this.capturedBlockSnapshots.add(blockSnapshot);
        }
        BlockState old = this.func_180495_p(pos);
        int oldLight = old.getLightValue((IBlockReader)this, pos);
        int oldOpacity = old.func_200016_a((IBlockReader)this, pos);
        BlockState blockstate = chunk.func_177436_a(pos, state, (flags & 0x40) != 0);
        if (blockstate == null) {
            if (blockSnapshot != null) {
                this.capturedBlockSnapshots.remove(blockSnapshot);
            }
            return false;
        }
        BlockState blockstate1 = this.func_180495_p(pos);
        if ((flags & 0x80) == 0 && blockstate1 != blockstate && (blockstate1.func_200016_a((IBlockReader)this, pos) != oldOpacity || blockstate1.getLightValue((IBlockReader)this, pos) != oldLight || blockstate1.func_215691_g() || blockstate.func_215691_g())) {
            this.func_217381_Z().func_76320_a("queueCheckLight");
            this.lightManager.func_215568_a(pos);
            this.func_217381_Z().func_76319_b();
        }
        if (!state.func_204520_s().func_206888_e() && state.func_204520_s().func_206883_i().equals(state.getBlockState())) {
            Fluid fluid = state.func_204520_s().func_206886_c();
            this.field_234921_x_ = this.owner.func_145831_w().field_234921_x_;
            this.func_205219_F_().func_205360_a(pos, (Object)fluid, fluid.func_205569_a((IWorldReader)this));
        }
        if (old.func_177230_c() != state.func_177230_c()) {
            try {
                state.func_215705_a((World)this, pos, old, false);
            }
            catch (NullPointerException fluid) {
                // empty catch block
            }
            BlockState statePlace = state;
            UnitTileEntity tileEntity = this.owner;
            if (statePlace.func_177230_c() instanceof ITileEntityProvider) {
                TileEntity te = ((ITileEntityProvider)statePlace.func_177230_c()).func_196283_a_((IBlockReader)tileEntity.field_145850_b);
                tileEntity.field_145850_b.func_175690_a(pos, te);
            } else if (statePlace.func_177230_c().hasTileEntity(statePlace)) {
                TileEntity te = statePlace.func_177230_c().createTileEntity(statePlace, (IBlockReader)tileEntity.field_145850_b);
                tileEntity.field_145850_b.func_175690_a(pos, te);
            }
        }
        this.markAndNotifyBlock(pos, chunk, blockstate, state, flags, recursionLeft);
        if (state.equals(Blocks.field_150350_a.func_176223_P())) {
            this.blockMap.remove(pos);
        }
        int newLight = state.getLightValue((IBlockReader)this, pos);
        this.lightManager.field_215576_a.field_215627_c.func_215515_b(pos.func_218275_a(), newLight, oldLight > newLight);
        return true;
    }

    public DifficultyInstance func_175649_E(BlockPos pos) {
        return this.owner.func_145831_w().func_175649_E(this.owner.func_174877_v());
    }

    public Explosion func_230546_a_(@Nullable Entity exploder, @Nullable DamageSource damageSource, @Nullable ExplosionContext context, double x, double y, double z, float size, boolean causesFire, Explosion.Mode mode) {
        try {
            return super.func_230546_a_(exploder, damageSource, context, x, y, z, size, causesFire, mode);
        }
        catch (Throwable ignored) {
            return new Explosion((World)this, exploder, x, y, z, size, causesFire, mode);
        }
    }

    public boolean func_217376_c(Entity entityIn) {
        entityIn.func_223102_j((double)this.owner.func_174877_v().func_177958_n() + entityIn.func_213303_ch().func_82615_a() / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177956_o() + (entityIn.func_213303_ch().func_82617_b() - 64.0) / (double)this.owner.unitsPerBlock, (double)this.owner.func_174877_v().func_177952_p() + entityIn.func_213303_ch().func_82616_c() / (double)this.owner.unitsPerBlock);
        entityIn.func_70029_a(this.owner.func_145831_w());
        return this.owner.func_145831_w().func_217376_c(entityIn);
    }

    public void markAndNotifyBlock(BlockPos pos, @Nullable IChunk chunk, BlockState blockstate, BlockState state, int flags, int recursionLeft) {
        Block block = state.func_177230_c();
        BlockState blockstate1 = this.func_180495_p(pos);
        if (blockstate1 == state) {
            if (blockstate != blockstate1) {
                this.func_225319_b(pos, blockstate, blockstate1);
            }
            if ((flags & 2) != 0 && (!this.field_72995_K || (flags & 4) == 0) && this.field_72995_K) {
                this.func_184138_a(pos, blockstate, state, flags);
            }
            if ((flags & 1) != 0) {
                this.func_230547_a_(pos, blockstate.func_177230_c());
                if (!this.field_72995_K && state.func_185912_n()) {
                    this.func_175666_e(pos, block);
                }
            }
            if ((flags & 0x10) == 0 && recursionLeft > 0) {
                int i = flags & 0xFFFFFFDE;
                blockstate.func_241483_b_((IWorld)this, pos, i, recursionLeft - 1);
                state.func_241482_a_((IWorld)this, pos, i, recursionLeft - 1);
                state.func_241483_b_((IWorld)this, pos, i, recursionLeft - 1);
                this.func_195593_d(pos, blockstate.func_177230_c());
                for (Direction value : Direction.values()) {
                    BlockPos pos1 = pos.func_177972_a(value);
                    BlockState state1 = this.func_180495_p(pos1);
                    ExternalUnitInteractionContext context = new ExternalUnitInteractionContext(this, pos1);
                    if (!(context.teInRealWorld instanceof UnitTileEntity)) continue;
                    state1.func_196956_a(value.func_176734_d(), state, (IWorld)((UnitTileEntity)context.teInRealWorld).field_145850_b, pos1, pos);
                }
            }
            this.func_217393_a(pos, blockstate, blockstate1);
        }
    }

    public boolean func_241212_a_(BlockPos pos, boolean dropBlock, @Nullable Entity entity, int recursionLeft) {
        try {
            return super.func_241212_a_(pos, dropBlock, entity, recursionLeft);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }

    public IProfiler func_217381_Z() {
        return this.blankProfiler;
    }

    public WorldBorder func_175723_af() {
        return border;
    }

    public GameRules func_82736_K() {
        return this.owner.func_145831_w().func_82736_K();
    }

    public DimensionType func_230315_m_() {
        return this.field_234921_x_ == null ? this.owner.func_145831_w().func_230315_m_() : this.field_234921_x_;
    }

    public RegistryKey<World> func_234923_W_() {
        return this.owner.func_145831_w().func_234923_W_();
    }

    public boolean func_175700_a(TileEntity tile) {
        this.func_175690_a(tile.func_174877_v(), tile);
        return true;
    }

    public void func_147448_a(Collection<TileEntity> tileEntityCollection) {
        for (TileEntity tileEntity : tileEntityCollection) {
            this.func_175700_a(tileEntity);
        }
    }

    public ServerTickList<Block> func_205220_G_() {
        return super.func_205220_G_();
    }

    public ServerTickList<Fluid> func_205219_F_() {
        return super.func_205219_F_();
    }

    public ServerChunkProvider func_72863_F() {
        return super.func_72863_F();
    }

    public void func_175669_a(int id, BlockPos pos, int data) {
        this.owner.func_145831_w().func_175669_a(id, this.owner.func_174877_v(), data);
    }

    static {
        forcedChunks = LongSets.singleton((long)new ChunkPos(new BlockPos(0, 0, 0)).func_201841_a());
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            theUnsafe = (Unsafe)f.get(null);
        }
        catch (Throwable err) {
            throw new RuntimeException(err);
        }
    }
}

