/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public final class MathUtil {
    private MathUtil() {
    }

    public static List<class_243> fibonacciSphere(class_243 start, double radius, int samples, boolean randomize) {
        double rnd = 1.0;
        if (randomize) {
            rnd = Math.random() * (double)samples;
        }
        double offset = 2.0 / (double)samples;
        double increment = Math.PI * (3.0 - Math.sqrt(5.0));
        ArrayList points = Lists.newArrayListWithCapacity((int)samples);
        for (int i = 0; i < samples; ++i) {
            double y = (double)i * offset - 1.0 + offset / 2.0;
            double r = Math.sqrt(1.0 - y * y) * radius;
            double phi = ((double)i + rnd) % (double)samples * increment;
            double x = Math.cos(phi) * r;
            double z = Math.sin(phi) * r;
            points.add(new class_243(start.field_1352 + x, start.field_1351 + y * radius, start.field_1350 + z));
        }
        return points;
    }

    public static int posOnLine(class_243 start, class_243 end, Collection<class_2338> list) {
        list.add(new class_2338(start));
        if (start.equals((Object)end)) {
            return 1;
        }
        int c = 1;
        double ex = class_3532.method_16436((double)-1.0E-7, (double)end.field_1352, (double)start.field_1352);
        double ey = class_3532.method_16436((double)-1.0E-7, (double)end.field_1351, (double)start.field_1351);
        double ez = class_3532.method_16436((double)-1.0E-7, (double)end.field_1350, (double)start.field_1350);
        double sx = class_3532.method_16436((double)-1.0E-7, (double)start.field_1352, (double)end.field_1352);
        double sy = class_3532.method_16436((double)-1.0E-7, (double)start.field_1351, (double)end.field_1351);
        double sz = class_3532.method_16436((double)-1.0E-7, (double)start.field_1350, (double)end.field_1350);
        int x = class_3532.method_15357((double)sx);
        int y = class_3532.method_15357((double)sy);
        int z = class_3532.method_15357((double)sz);
        double subX = ex - sx;
        double subY = ey - sy;
        double subZ = ez - sz;
        int signX = class_3532.method_17822((double)subX);
        int signY = class_3532.method_17822((double)subY);
        int signZ = class_3532.method_17822((double)subZ);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / subX;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / subY;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / subZ;
        double d12 = d9 * (signX > 0 ? 1.0 - class_3532.method_15385((double)sx) : class_3532.method_15385((double)sx));
        double d13 = d10 * (signY > 0 ? 1.0 - class_3532.method_15385((double)sy) : class_3532.method_15385((double)sy));
        double d14 = d11 * (signZ > 0 ? 1.0 - class_3532.method_15385((double)sz) : class_3532.method_15385((double)sz));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            if (d12 < d13) {
                if (d12 < d14) {
                    x += signX;
                    d12 += d9;
                } else {
                    z += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                y += signY;
                d13 += d10;
            } else {
                z += signZ;
                d14 += d11;
            }
            list.add(new class_2338(x, y, z));
            ++c;
        }
        return c;
    }

    public static class_1160 RGBtoHSV(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int max = Math.max(r, Math.max(g, b));
        int min = Math.min(r, Math.min(g, b));
        float v = max;
        float delta = max - min;
        if (max == 0) {
            float s = 0.0f;
            float h = -1.0f;
            return new class_1160(h, s, 0.0f);
        }
        float s = delta / (float)max;
        float h = r == max ? (float)(g - b) / delta : (g == max ? 2.0f + (float)(b - r) / delta : 4.0f + (float)(r - g) / delta);
        h /= 6.0f;
        if (h < 0.0f) {
            h += 1.0f;
        }
        return new class_1160(h, s, v / 255.0f);
    }
}

