/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.electronwill.nightconfig.core.conversion.ReflectionException;
import com.electronwill.nightconfig.core.conversion.SpecValidator;
import com.electronwill.nightconfig.core.utils.StringUtils;
import com.google.common.base.Predicates;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import snownee.kiwi.config.KiwiConfig;

public class NightConfigUtil {
    static List<String> getPath(Field field) {
        List<String> annotatedPath = NightConfigUtil.getPath((AnnotatedElement)field);
        return annotatedPath == null ? Collections.singletonList(field.getName()) : annotatedPath;
    }

    static List<String> getPath(AnnotatedElement annotatedElement) {
        KiwiConfig.Path path = annotatedElement.getDeclaredAnnotation(KiwiConfig.Path.class);
        if (path != null) {
            return StringUtils.split((String)path.value(), (char)'.');
        }
        KiwiConfig.AdvancedPath advancedPath = annotatedElement.getDeclaredAnnotation(KiwiConfig.AdvancedPath.class);
        if (advancedPath != null) {
            return Arrays.asList(advancedPath.value());
        }
        return null;
    }

    static Predicate<Object> getValidator(Field field) {
        Predicate validatorInstance;
        try {
            SpecValidator spec = field.getAnnotation(SpecValidator.class);
            if (spec == null) {
                return Predicates.alwaysTrue();
            }
            Constructor constructor = spec.value().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            validatorInstance = (Predicate)constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException("Cannot create a converter for field " + field, (Throwable)ex);
        }
        return validatorInstance;
    }
}

