/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.data.provider;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.ModuleInfo;

public abstract class KiwiBlockLoot
extends BlockLoot {
    public static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    public static final LootItemCondition.Builder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.m_81807_();
    public static final LootItemCondition.Builder HAS_SHEARS = CanToolPerformAction.canToolPerformAction((ToolAction)ToolActions.SHEARS_DIG);
    public static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_7818_(HAS_SILK_TOUCH);
    public static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.m_81807_();
    public List<Block> knownBlocks;
    private final Map<Class<?>, Function<Block, LootTable.Builder>> handlers = Maps.newHashMap();
    private Function<Block, LootTable.Builder> defaultHandler;
    private final Set<Block> added = Sets.newHashSet();

    public KiwiBlockLoot(ResourceLocation moduleId) {
        ModuleInfo info = KiwiModules.get(moduleId);
        Objects.requireNonNull(info);
        this.knownBlocks = info.getRegistries(Block.class);
    }

    protected void handle(Class<? extends Block> clazz, Function<Block, LootTable.Builder> handler) {
        this.handlers.put(clazz, handler);
    }

    protected void handleDefault(Function<Block, LootTable.Builder> handler) {
        this.defaultHandler = handler;
    }

    protected final void addTables() {
        this._addTables();
        for (Block block : this.getKnownBlocks()) {
            if (this.added.contains(block)) continue;
            Function<Block, LootTable.Builder> handler = this.handlers.get(block.getClass());
            if (handler != null) {
                this.m_124175_(block, handler);
                continue;
            }
            if (this.defaultHandler == null) continue;
            this.m_124175_(block, this.defaultHandler);
        }
    }

    protected void m_124165_(Block block, LootTable.Builder builder) {
        super.m_124165_(block, builder);
        this.added.add(block);
    }

    protected abstract void _addTables();

    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    public static LootTable.Builder createShearsDispatchTable(Block pBlock, LootPoolEntryContainer.Builder<?> pAlternativeEntryBuilder) {
        return KiwiBlockLoot.m_124171_((Block)pBlock, (LootItemCondition.Builder)HAS_SHEARS, pAlternativeEntryBuilder);
    }

    public static LootTable.Builder createShearsOnlyDrop(ItemLike p_124287_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(HAS_SHEARS).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124287_)));
    }

    public static LootTable.Builder createSilkTouchOrShearsDispatchTable(Block pBlock, LootPoolEntryContainer.Builder<?> pAlternativeEntryBuilder) {
        return KiwiBlockLoot.m_124171_((Block)pBlock, (LootItemCondition.Builder)HAS_SHEARS_OR_SILK_TOUCH, pAlternativeEntryBuilder);
    }

    public static LootTable.Builder createLeavesDrops(Block pLeavesBlock, Block pSaplingBlock, float ... pChances) {
        return KiwiBlockLoot.createSilkTouchOrShearsDispatchTable(pLeavesBlock, ((LootPoolSingletonContainer.Builder)KiwiBlockLoot.m_124134_((ItemLike)pLeavesBlock, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)pSaplingBlock))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])pChances))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)KiwiBlockLoot.m_124131_((ItemLike)pLeavesBlock, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
    }
}

