/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.mojang.math.Vector3d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.util.EnumUtil;

public final class VoxelUtil {
    private static final Vector3d fromOrigin = new Vector3d(-0.5, -0.5, -0.5);

    private VoxelUtil() {
    }

    public static AABB rotate(AABB box, Direction side) {
        switch (side) {
            case DOWN: {
                return box;
            }
            case UP: {
                return new AABB(box.f_82288_, -box.f_82289_, -box.f_82290_, box.f_82291_, -box.f_82292_, -box.f_82293_);
            }
            case NORTH: {
                return new AABB(box.f_82288_, -box.f_82290_, box.f_82289_, box.f_82291_, -box.f_82293_, box.f_82292_);
            }
            case SOUTH: {
                return new AABB(-box.f_82288_, -box.f_82290_, -box.f_82289_, -box.f_82291_, -box.f_82293_, -box.f_82292_);
            }
            case WEST: {
                return new AABB(box.f_82289_, -box.f_82290_, -box.f_82288_, box.f_82292_, -box.f_82293_, -box.f_82291_);
            }
            case EAST: {
                return new AABB(-box.f_82289_, -box.f_82290_, box.f_82288_, -box.f_82292_, -box.f_82293_, box.f_82291_);
            }
        }
        return box;
    }

    public static AABB rotate(AABB box, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return box;
            }
            case CLOCKWISE_90: {
                return new AABB(-box.f_82290_, box.f_82289_, box.f_82288_, -box.f_82293_, box.f_82292_, box.f_82291_);
            }
            case CLOCKWISE_180: {
                return new AABB(-box.f_82288_, box.f_82289_, -box.f_82290_, -box.f_82291_, box.f_82292_, -box.f_82293_);
            }
            case COUNTERCLOCKWISE_90: {
                return new AABB(box.f_82290_, box.f_82289_, -box.f_82288_, box.f_82293_, box.f_82292_, -box.f_82291_);
            }
        }
        return box;
    }

    public static AABB rotateHorizontal(AABB box, Direction side) {
        switch (side) {
            case NORTH: {
                return VoxelUtil.rotate(box, Rotation.NONE);
            }
            case SOUTH: {
                return VoxelUtil.rotate(box, Rotation.CLOCKWISE_180);
            }
            case WEST: {
                return VoxelUtil.rotate(box, Rotation.COUNTERCLOCKWISE_90);
            }
            case EAST: {
                return VoxelUtil.rotate(box, Rotation.CLOCKWISE_90);
            }
        }
        return box;
    }

    public static VoxelShape rotate(VoxelShape shape, Direction side) {
        if (shape.m_83281_() || shape == Shapes.m_83144_()) {
            return shape;
        }
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotate(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotate(box, rotation));
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Direction side) {
        if (shape.m_83281_() || shape == Shapes.m_83144_()) {
            return shape;
        }
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotateHorizontal(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, UnaryOperator<AABB> rotateFunction) {
        ArrayList<VoxelShape> rotatedPieces = new ArrayList<VoxelShape>();
        List sourceBoundingBoxes = shape.m_83299_();
        for (AABB sourceBoundingBox : sourceBoundingBoxes) {
            rotatedPieces.add(Shapes.m_83064_((AABB)((AABB)rotateFunction.apply(sourceBoundingBox.m_82386_(VoxelUtil.fromOrigin.f_86214_, VoxelUtil.fromOrigin.f_86215_, VoxelUtil.fromOrigin.f_86216_))).m_82386_(-VoxelUtil.fromOrigin.f_86214_, -VoxelUtil.fromOrigin.f_86216_, -VoxelUtil.fromOrigin.f_86216_)));
        }
        return VoxelUtil.combine(rotatedPieces);
    }

    public static VoxelShape combine(VoxelShape ... shapes) {
        return VoxelUtil.batchCombine(Shapes.m_83040_(), BooleanOp.f_82695_, true, shapes);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes) {
        return VoxelUtil.batchCombine(Shapes.m_83040_(), BooleanOp.f_82695_, true, shapes);
    }

    public static VoxelShape exclude(VoxelShape ... shapes) {
        return VoxelUtil.batchCombine(Shapes.m_83144_(), BooleanOp.f_82685_, true, shapes);
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.m_83296_() : combinedShape;
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, VoxelShape ... shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.m_83296_() : combinedShape;
    }

    public static void setShape(VoxelShape shape, VoxelShape[] dest, boolean verticalAxis) {
        VoxelUtil.setShape(shape, dest, verticalAxis, false);
    }

    public static void setShape(VoxelShape shape, VoxelShape[] dest, boolean verticalAxis, boolean invert) {
        Direction[] dirs;
        for (Direction side : dirs = verticalAxis ? EnumUtil.DIRECTIONS : EnumUtil.HORIZONTAL_DIRECTIONS) {
            dest[verticalAxis ? side.ordinal() : side.ordinal() - 2] = verticalAxis ? VoxelUtil.rotate(shape, invert ? side.m_122424_() : side) : VoxelUtil.rotateHorizontal(shape, side);
        }
    }

    public static void setShape(VoxelShape shape, VoxelShape[] dest) {
        VoxelUtil.setShape(shape, dest, false, false);
    }
}

