/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.util.EnumUtil;
import snownee.snow.ModUtil;
import snownee.snow.block.EntitySnowLayerBlock;
import snownee.snow.block.ModSnowLayerBlock;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowFenceGateBlock;
import snownee.snow.block.SnowSlabBlock;
import snownee.snow.block.SnowStairsBlock;
import snownee.snow.block.SnowWallBlock;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.block.entity.SnowCoveredBlockEntity;
import snownee.snow.client.ClientVariables;
import snownee.snow.client.FallingSnowRenderer;
import snownee.snow.datagen.SnowBlockTagsProvider;
import snownee.snow.entity.FallingSnowEntity;
import snownee.snow.item.SnowLayerBlockItem;
import snownee.snow.loot.NormalLootEntry;
import snownee.snow.mixin.IntegerValueAccess;

@KiwiModule
@KiwiModule.Subscriber(value=KiwiModule.Subscriber.Bus.MOD)
public class CoreModule
extends AbstractModule {
    public static final Tag.Named<Block> BOTTOM_SNOW = CoreModule.blockTag((String)"snowrealmagic", (String)"bottom_snow");
    public static final Tag.Named<Block> INVALID_SUPPORTERS = CoreModule.blockTag((String)"snowrealmagic", (String)"invalid_supporters");
    public static final Tag.Named<Block> CONTAINABLES = CoreModule.blockTag((String)"snowrealmagic", (String)"containables");
    public static final Tag.Named<Block> NOT_CONTAINABLES = CoreModule.blockTag((String)"snowrealmagic", (String)"not_containables");
    @KiwiModule.NoItem
    @KiwiModule.Name(value="minecraft:snow")
    public static final ModSnowLayerBlock BLOCK = new ModSnowLayerBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50125_));
    @KiwiModule.NoItem
    @KiwiModule.Name(value="snow")
    public static final EntitySnowLayerBlock TILE_BLOCK = new EntitySnowLayerBlock(CoreModule.blockProp((BlockBehaviour)BLOCK));
    @KiwiModule.Name(value="minecraft:snow")
    public static final SnowLayerBlockItem ITEM = new SnowLayerBlockItem((Block)BLOCK);
    @KiwiModule.NoItem
    public static final SnowFenceBlock FENCE = new SnowFenceBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50132_).m_60977_());
    @KiwiModule.NoItem
    public static final SnowFenceBlock FENCE2 = new SnowFenceBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50198_).m_60977_());
    @KiwiModule.NoItem
    public static final SnowStairsBlock STAIRS = new SnowStairsBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50086_).m_60977_());
    @KiwiModule.NoItem
    public static final SnowSlabBlock SLAB = new SnowSlabBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50398_).m_60977_());
    @KiwiModule.NoItem
    public static final SnowFenceGateBlock FENCE_GATE = new SnowFenceGateBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50192_).m_60977_());
    @KiwiModule.NoItem
    public static final SnowWallBlock WALL = new SnowWallBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50274_).m_60977_());
    @KiwiModule.Name(value="snow")
    public static final BlockEntityType<SnowBlockEntity> TILE = BlockEntityType.Builder.m_155273_(SnowBlockEntity::new, (Block[])new Block[]{TILE_BLOCK}).m_58966_(null);
    public static final BlockEntityType<SnowCoveredBlockEntity> TEXTURE_TILE = BlockEntityType.Builder.m_155273_(SnowCoveredBlockEntity::new, (Block[])new Block[]{FENCE, FENCE2, STAIRS, SLAB, FENCE_GATE, WALL}).m_58966_(null);
    @KiwiModule.Name(value="snow")
    public static final EntityType<FallingSnowEntity> ENTITY = EntityType.Builder.m_20704_(FallingSnowEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory((spawnEntity, world) -> new FallingSnowEntity((Level)world)).m_20699_(0.98f, 0.001f).m_20712_("snowrealmagic.snow");
    @KiwiModule.Skip
    public static final LootPoolEntryType NORMAL = (LootPoolEntryType)Registry.m_122961_((Registry)Registry.f_122875_, (String)"snowrealmagic:normal", (Object)new LootPoolEntryType((Serializer)new NormalLootEntry.Serializer()));
    public static final GameRules.Key<GameRules.IntegerValue> BLIZZARD_STRENGTH = GameRules.m_46189_((String)"blizzardStrength", (GameRules.Category)GameRules.Category.MISC, IntegerValueAccess.callCreate(0));
    public static final GameRules.Key<GameRules.IntegerValue> BLIZZARD_FREQUENCY = GameRules.m_46189_((String)"blizzardFrequency", (GameRules.Category)GameRules.Category.MISC, IntegerValueAccess.callCreate(10000));

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ENTITY, FallingSnowRenderer::new);
    }

    protected void init(InitEvent event) {
        ModUtil.init();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientInit(ClientInitEvent event) {
        Predicate<RenderType> blockRenderTypes = EnumUtil.BLOCK_RENDER_TYPES::contains;
        for (Block block : Arrays.asList(TILE_BLOCK, FENCE, FENCE2, FENCE_GATE, SLAB, STAIRS, WALL)) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, blockRenderTypes);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerExtraModel(ModelRegistryEvent event) {
        ForgeModelBakery.addSpecialModel((ResourceLocation)ClientVariables.OVERLAY_MODEL);
    }

    protected void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            SnowBlockTagsProvider blockTagsProvider = new SnowBlockTagsProvider(generator, event.getExistingFileHelper());
            generator.m_123914_((DataProvider)blockTagsProvider);
        }
    }
}

