/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.fml.ModList;
import snownee.snow.SnowCommonConfig;
import snownee.snow.SnowRealMagic;
import snownee.snow.compat.sereneseasons.SereneSeasonsCompat;

public class ModUtil {
    public static boolean terraforged;
    public static boolean sereneseasons;

    public static void init() {
        sereneseasons = ModList.get().isLoaded("sereneseasons");
        if (sereneseasons) {
            SnowRealMagic.LOGGER.info("SereneSeasons detected. Overriding melting behavior.");
        }
    }

    public static boolean shouldMelt(Level world, BlockPos pos) {
        if (SnowCommonConfig.snowNeverMelt) {
            return false;
        }
        if (world.m_45517_(LightLayer.BLOCK, pos) >= 10) {
            return true;
        }
        Biome biome = world.m_46857_(pos);
        if (sereneseasons && SereneSeasonsCompat.shouldMelt(world, pos, biome)) {
            return true;
        }
        return ModUtil.snowMeltsInWarmBiomes(biome) && !biome.m_47519_((LevelReader)world, pos) && world.m_45527_(pos);
    }

    public static boolean snowMeltsInWarmBiomes(Biome biome) {
        return SnowCommonConfig.snowMeltsInWarmBiomes;
    }

    public static boolean iceMeltsInWarmBiomes(Biome biome) {
        return sereneseasons;
    }

    public static boolean coldEnoughToSnow(Level level, BlockPos pos, Biome biome) {
        if (sereneseasons) {
            return SereneSeasonsCompat.coldEnoughToSnow(level, pos, biome);
        }
        return biome.m_198904_(pos);
    }
}

