/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.WitherRoseBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.snow.CoreModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.ModSnowLayerBlock;
import snownee.snow.block.entity.SnowBlockEntity;

public class EntitySnowLayerBlock
extends ModSnowLayerBlock
implements EntityBlock,
BonemealableBlock {
    public EntitySnowLayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SnowBlockEntity(pos, state);
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape = super.m_5939_(state, worldIn, pos, context);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)this.getRaw(state, worldIn, pos).m_60812_(worldIn, pos), (BooleanOp)BooleanOp.f_82695_);
        return Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83144_(), (BooleanOp)BooleanOp.f_82689_);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape = super.m_5909_(state, worldIn, pos, context);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)this.getRaw(state, worldIn, pos).m_60812_(worldIn, pos), (BooleanOp)BooleanOp.f_82695_);
        return Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83144_(), (BooleanOp)BooleanOp.f_82689_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape = super.m_5940_(state, worldIn, pos, context);
        return Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.getRaw(state, worldIn, pos).m_60651_(worldIn, pos, context), (BooleanOp)BooleanOp.f_82695_);
    }

    @Override
    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        if (useContext.m_43722_().m_150930_(CoreModule.BLOCK.m_5456_())) {
            return super.m_6864_(state, useContext);
        }
        if (!super.m_6864_(state, useContext)) {
            return false;
        }
        Level world = useContext.m_43725_();
        BlockPos pos = useContext.m_8083_();
        return this.getRaw(state, (BlockGetter)world, pos).m_60629_(useContext);
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState containedNew;
        BlockState contained;
        BlockState state = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (state.m_60734_() instanceof EntitySnowLayerBlock && (contained = this.getRaw(state, (BlockGetter)worldIn, currentPos)) != (containedNew = contained.m_60728_(facing, facingState, worldIn, currentPos, facingPos))) {
            this.setContainedState(worldIn, currentPos, containedNew, state);
        }
        return state;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return this.getRaw(state, worldIn, pos).m_60647_(worldIn, pos, type);
    }

    public void setContainedState(LevelAccessor world, BlockPos pos, BlockState state, BlockState snow) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof SnowBlockEntity) {
            if (state.m_60795_()) {
                snow = (BlockState)CoreModule.BLOCK.m_49966_().m_61124_((Property)f_56581_, (Comparable)((Integer)snow.m_61143_((Property)f_56581_)));
                world.m_7731_(pos, snow, 3);
            } else {
                ((SnowBlockEntity)tile).setState(state);
            }
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (willHarvest) {
            this.m_5707_(world, pos, state, player);
        } else if (player != null) {
            this.m_142387_(world, player, pos, state);
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof SnowBlockEntity) {
            BlockState newState = ((SnowBlockEntity)tile).getState();
            world.m_46597_(pos, newState);
        }
        return true;
    }

    public String m_7705_() {
        return CoreModule.BLOCK.m_7705_();
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            BlockState stateIn;
            if (!worldIn.f_46443_ && worldIn.m_46791_() != Difficulty.PEACEFUL) {
                LivingEntity livingentity;
                if (this.getRaw(state, (BlockGetter)worldIn, pos).m_60734_() instanceof WitherRoseBlock && !(livingentity = (LivingEntity)entityIn).m_6673_(DamageSource.f_19320_)) {
                    livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 40));
                }
            } else if (entityIn.m_6095_() != EntityType.f_20452_ && entityIn.m_6095_() != EntityType.f_20550_ && (stateIn = this.getRaw(state, (BlockGetter)worldIn, pos)).m_60734_() instanceof SweetBerryBushBlock) {
                entityIn.m_7601_(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
                if (!(worldIn.f_46443_ || (Integer)stateIn.m_61143_((Property)SweetBerryBushBlock.f_57244_) <= 0 || entityIn.f_19790_ == entityIn.m_20185_() && entityIn.f_19792_ == entityIn.m_20189_())) {
                    double d0 = Math.abs(entityIn.m_20185_() - entityIn.f_19790_);
                    double d1 = Math.abs(entityIn.m_20189_() - entityIn.f_19792_);
                    if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                        entityIn.m_6469_(DamageSource.f_19325_, 1.0f);
                    }
                }
            }
        }
    }

    @Override
    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        BlockState stateIn = this.getRaw(state, (BlockGetter)worldIn, pos);
        if (SnowCommonConfig.retainOriginalBlocks) {
            worldIn.m_46597_(pos, stateIn);
            return;
        }
        super.m_7455_(state, worldIn, pos, random);
        if (stateIn.m_60734_() instanceof TallGrassBlock || stateIn.m_60734_() instanceof DoublePlantBlock) {
            return;
        }
        BlockState stateNow = worldIn.m_8055_(pos);
        if (!stateNow.m_60713_((Block)this)) {
            return;
        }
        stateIn.m_60735_(worldIn, pos, random);
        BlockState stateNow2 = worldIn.m_8055_(pos);
        if (!stateNow2.m_60713_((Block)this)) {
            EntitySnowLayerBlock.convert((LevelAccessor)worldIn, pos, stateNow2, (Integer)stateNow.m_61143_((Property)f_56581_), 18);
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        InteractionResult result = this.getRaw(state, (BlockGetter)worldIn, pos).m_60664_(worldIn, player, handIn, hit);
        if (result.m_19077_()) {
            BlockState stateNow = worldIn.m_8055_(pos);
            if (!stateNow.m_60713_((Block)this)) {
                EntitySnowLayerBlock.convert((LevelAccessor)worldIn, pos, stateNow, (Integer)state.m_61143_((Property)f_56581_), 18);
            }
            return result;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        if (worldIn.f_46443_) {
            return;
        }
        try {
            BlockState contained = this.getRaw(state, (BlockGetter)worldIn, pos);
            if (!contained.m_60795_() && contained.m_60800_((BlockGetter)worldIn, pos) == 0.0f) {
                worldIn.m_46796_(2001, pos, Block.m_49956_((BlockState)contained));
                Block.m_49881_((BlockState)contained, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)ItemStack.f_41583_);
                int layers = (Integer)state.m_61143_((Property)f_56581_);
                worldIn.m_46597_(pos, (BlockState)CoreModule.BLOCK.m_49966_().m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(layers)));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        BlockState contained = this.getRaw(state, worldIn, pos);
        Block block = contained.m_60734_();
        return block instanceof BonemealableBlock && ((BonemealableBlock)block).m_7370_(worldIn, pos, contained, isClient);
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockState contained = this.getRaw(state, (BlockGetter)worldIn, pos);
        Block block = contained.m_60734_();
        return block instanceof BonemealableBlock && ((BonemealableBlock)block).m_5491_(worldIn, rand, pos, contained);
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockState contained = this.getRaw(state, (BlockGetter)worldIn, pos);
        Block block = contained.m_60734_();
        if (block instanceof BonemealableBlock) {
            ((BonemealableBlock)block).m_7719_(worldIn, rand, pos, contained);
            BlockState stateNow = worldIn.m_8055_(pos);
            if (stateNow.m_60734_() != state.m_60734_()) {
                EntitySnowLayerBlock.convert((LevelAccessor)worldIn, pos, stateNow, (Integer)state.m_61143_((Property)f_56581_), 3);
            }
        }
    }

    public Item m_5456_() {
        return CoreModule.ITEM;
    }
}

