/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import java.util.Map;
import java.util.Random;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.snow.CoreModule;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.client.SnowClientConfig;
import snownee.snow.entity.FallingSnowEntity;

public class ModSnowLayerBlock
extends SnowLayerBlock
implements SnowVariant {
    public static final VoxelShape[] SNOW_SHAPES_MAGIC = new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0)};

    public ModSnowLayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (ModUtil.terraforged || !SnowCommonConfig.thinnerBoundingBox) {
            return super.m_5939_(state, worldIn, pos, context);
        }
        int layers = (Integer)state.m_61143_((Property)f_56581_);
        if (layers == 8) {
            return Shapes.m_83144_();
        }
        return SNOW_SHAPES_MAGIC[layers - 1];
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (SnowCommonConfig.snowGravity) {
            worldIn.m_186460_(pos, (Block)this, this.tickRate());
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (SnowCommonConfig.snowGravity) {
            worldIn.m_186460_(currentPos, (Block)this, this.tickRate());
            return stateIn;
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.canSurvive(state, (BlockGetter)worldIn, pos, false);
    }

    public boolean canSurvive(BlockState state, BlockGetter worldIn, BlockPos pos, boolean ignoreSelf) {
        BlockState blockstate = worldIn.m_8055_(pos.m_7495_());
        Block block = blockstate.m_60734_();
        if (block instanceof SnowLayerBlock && (Integer)blockstate.m_61143_((Property)f_56581_) == 8) {
            return true;
        }
        return !((!SnowCommonConfig.snowOnIce || !blockstate.m_60713_(Blocks.f_50126_) && !blockstate.m_60713_(Blocks.f_50354_)) && blockstate.m_60620_(CoreModule.INVALID_SUPPORTERS) || !ignoreSelf && !state.m_60767_().m_76336_() && !ModSnowLayerBlock.canContainState(state) || !blockstate.m_60620_((Tag)BlockTags.f_13035_) && !Block.m_49918_((VoxelShape)blockstate.m_60812_(worldIn, pos.m_7495_()), (Direction)Direction.UP));
    }

    protected int tickRate() {
        return 2;
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        this.checkFallable((Level)worldIn, pos, state);
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (ModUtil.shouldMelt((Level)worldIn, pos)) {
            BlockState upState;
            int layers = (Integer)state.m_61143_((Property)f_56581_);
            if (layers == 8 && (upState = worldIn.m_8055_(pos.m_7494_())).m_60734_() instanceof SnowLayerBlock) {
                return;
            }
            if (state.m_60713_((Block)CoreModule.TILE_BLOCK)) {
                state.onDestroyedByPlayer((Level)worldIn, pos, null, false, null);
            } else {
                ModSnowLayerBlock.m_49950_((BlockState)state, (Level)worldIn, (BlockPos)pos);
                worldIn.m_7471_(pos, false);
            }
            return;
        }
        if (ModUtil.terraforged) {
            return;
        }
        if (!SnowCommonConfig.snowAccumulationDuringSnowfall && !SnowCommonConfig.snowAccumulationDuringSnowstorm) {
            return;
        }
        if (random.nextInt(8) > 0) {
            return;
        }
        int layers = (Integer)state.m_61143_((Property)f_56581_);
        BlockPos height = worldIn.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos);
        if (layers == 8) {
            if (height.m_123342_() - 1 != pos.m_123342_()) {
                return;
            }
            BlockState upState = worldIn.m_8055_(pos.m_7494_());
            if (upState.m_60734_() instanceof SnowLayerBlock) {
                return;
            }
        } else if (height.m_123342_() != pos.m_123342_()) {
            return;
        }
        Biome biome = worldIn.m_46857_(pos);
        boolean flag = false;
        if (worldIn.m_46471_() && ModUtil.coldEnoughToSnow((Level)worldIn, pos, biome)) {
            if (SnowCommonConfig.snowAccumulationDuringSnowfall) {
                flag = true;
            } else if (SnowCommonConfig.snowAccumulationDuringSnowstorm && worldIn.m_46470_()) {
                flag = true;
            }
        }
        if (flag && layers < SnowCommonConfig.snowAccumulationMaxLayers) {
            ModSnowLayerBlock.accumulate((Level)worldIn, pos, state, (w, p) -> (SnowCommonConfig.snowAccumulationMaxLayers > 8 || !(w.m_8055_(p.m_7495_()).m_60734_() instanceof ModSnowLayerBlock)) && w.m_45517_(LightLayer.BLOCK, p) < 10, true);
        } else if (!SnowCommonConfig.snowNeverMelt && SnowCommonConfig.snowNaturalMelt && !worldIn.m_46471_()) {
            if (layers == 1) {
                if (SnowCommonConfig.snowAccumulationMaxLayers > 8 && worldIn.m_8055_(pos.m_7495_()).m_60734_() instanceof ModSnowLayerBlock) {
                    worldIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
                }
            } else {
                ModSnowLayerBlock.accumulate((Level)worldIn, pos, state, (w, p) -> !(w.m_8055_(p.m_7494_()).m_60734_() instanceof ModSnowLayerBlock), false);
            }
        }
    }

    private static void accumulate(Level world, BlockPos pos, BlockState centerState, BiPredicate<LevelAccessor, BlockPos> filter, boolean accumulate) {
        int i = (Integer)centerState.m_61143_((Property)f_56581_);
        for (int j = 0; j < 8; ++j) {
            int k = j / 2;
            Direction direction = Direction.m_122407_((int)k);
            BlockPos pos2 = pos.m_142300_(direction);
            if (j % 2 == 1) {
                pos2 = pos2.m_142300_(Direction.m_122407_((int)(k + 1)));
            }
            if (!world.m_46749_(pos2) || !filter.test((LevelAccessor)world, pos2)) continue;
            BlockState state = world.m_8055_(pos2);
            BlockPos height = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos2);
            if (height.m_123342_() != pos2.m_123342_() || !CoreModule.BLOCK.m_7898_(state, (LevelReader)world, pos2)) continue;
            int l = state.m_60734_() instanceof SnowLayerBlock ? (Integer)state.m_61143_((Property)f_56581_) : 0;
            if (!(accumulate ? i > l : i < l)) continue;
            if (accumulate) {
                ModSnowLayerBlock.placeLayersOn(world, pos2, 1, false, (BlockPlaceContext)new DirectionalPlaceContext(world, pos2, Direction.UP, ItemStack.f_41583_, Direction.DOWN), false);
            } else {
                world.m_46597_(pos2, (BlockState)state.m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(l - 1)));
            }
            return;
        }
        if (accumulate) {
            ModSnowLayerBlock.placeLayersOn(world, pos, 1, false, (BlockPlaceContext)new DirectionalPlaceContext(world, pos, Direction.UP, ItemStack.f_41583_, Direction.DOWN), false);
        } else {
            world.m_46597_(pos, (BlockState)centerState.m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(i - 1)));
        }
    }

    protected boolean checkFallable(Level worldIn, BlockPos pos, BlockState state) {
        BlockPos posDown = pos.m_7495_();
        if (ModSnowLayerBlock.canFallThrough(worldIn.m_8055_(posDown), worldIn, posDown)) {
            if (!worldIn.f_46443_) {
                worldIn.m_46597_(pos, this.getRaw(state, (BlockGetter)worldIn, pos));
                FallingSnowEntity entity = new FallingSnowEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() + 0.5, (Integer)state.m_61143_((Property)f_56581_));
                worldIn.m_7967_((Entity)entity);
            }
            return true;
        }
        return false;
    }

    public static boolean placeLayersOn(Level world, BlockPos pos, int layers, boolean fallingEffect, BlockPlaceContext useContext, boolean playSound) {
        layers = Mth.m_14045_((int)layers, (int)1, (int)8);
        BlockState state = world.m_8055_(pos);
        int originLayers = 0;
        if (state.m_60734_() instanceof SnowLayerBlock) {
            originLayers = (Integer)state.m_61143_((Property)f_56581_);
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(Mth.m_14045_((int)(originLayers + layers), (int)1, (int)8))));
        } else if (ModSnowLayerBlock.canContainState(state) && state.m_60710_((LevelReader)world, pos)) {
            ModSnowLayerBlock.convert((LevelAccessor)world, pos, state, Mth.m_14045_((int)layers, (int)1, (int)8), 3);
        } else if (CoreModule.BLOCK.m_7898_(state, (LevelReader)world, pos)) {
            world.m_46597_(pos, (BlockState)CoreModule.BLOCK.m_49966_().m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(Mth.m_14045_((int)layers, (int)1, (int)8))));
        } else {
            return false;
        }
        if (fallingEffect) {
            world.m_7696_(pos, (Block)CoreModule.BLOCK, originLayers, layers);
        } else if (playSound) {
            SoundType soundtype = CoreModule.BLOCK.m_49962_(CoreModule.BLOCK.m_49966_());
            world.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        }
        if (originLayers + layers > 8) {
            pos = pos.m_7494_();
            if (CoreModule.BLOCK.m_7898_(CoreModule.BLOCK.m_49966_(), (LevelReader)world, pos) && world.m_8055_(pos).m_60629_(useContext)) {
                ModSnowLayerBlock.placeLayersOn(world, pos, layers - (8 - originLayers), fallingEffect, useContext, playSound);
            }
        }
        return true;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        int i = (Integer)state.m_61143_((Property)f_56581_);
        if (useContext.m_43722_().m_150930_(CoreModule.BLOCK.m_5456_()) && i < 8) {
            if (useContext.m_7058_() && state.m_60734_() == CoreModule.BLOCK) {
                return useContext.m_43719_() == Direction.UP;
            }
            return true;
        }
        return SnowCommonConfig.snowAlwaysReplaceable && (Integer)state.m_61143_((Property)f_56581_) < 8 || i == 1;
    }

    public boolean m_8133_(BlockState state, Level worldIn, BlockPos pos, int originLayers, int layers) {
        double offsetY = (double)originLayers / 8.0;
        layers *= 10;
        for (int i = 0; i < layers; ++i) {
            double d0 = this.RANDOM.nextGaussian() * 0.1;
            double d1 = this.RANDOM.nextGaussian() * 0.02;
            double d2 = this.RANDOM.nextGaussian() * 0.1;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_175821_, (double)((float)pos.m_123341_() + this.RANDOM.nextFloat()), (double)pos.m_123342_() + offsetY, (double)((float)pos.m_123343_() + this.RANDOM.nextFloat()), d0, d1, d2);
        }
        SoundType soundtype = this.getSoundType(state, (LevelReader)worldIn, pos, null);
        worldIn.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (!SnowClientConfig.particleThroughLeaves || rand.nextInt(32) > 0) {
            return;
        }
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (entity != null && entity.m_142538_().m_123331_((Vec3i)pos) > 256.0) {
            return;
        }
        BlockState stateDown = worldIn.m_8055_(pos.m_7495_());
        if (stateDown.m_60620_((Tag)BlockTags.f_13035_)) {
            double d0 = (double)pos.m_123341_() + rand.nextDouble();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (double)pos.m_123343_() + rand.nextDouble();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_175821_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state) {
        return -1;
    }

    public static boolean canFallThrough(BlockState state, Level worldIn, BlockPos pos) {
        if (state.m_60812_((BlockGetter)worldIn, pos).m_83281_() && (FallingBlock.m_53241_((BlockState)state) || ModSnowLayerBlock.canContainState(state))) {
            return true;
        }
        return state.m_60734_() instanceof SnowLayerBlock && (Integer)state.m_61143_((Property)f_56581_) < 8;
    }

    @Override
    public BlockState onShovel(BlockState state, Level world, BlockPos pos) {
        int layers = (Integer)state.m_61143_((Property)f_56581_) - 1;
        if (layers > 0) {
            return (BlockState)state.m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(layers));
        }
        return this.getRaw(state, (BlockGetter)world, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockState state2;
        BlockPlaceContext context;
        Block block;
        BlockState stateDown;
        if (player.m_21205_().m_41619_() && player.m_21206_().m_41619_() && !((stateDown = worldIn.m_8055_(pos.m_7495_())).m_60734_() instanceof SnowLayerBlock) && !stateDown.m_61138_((Property)BlockStateProperties.f_61451_)) {
            BlockEntity blockEntity;
            if (state.m_60734_() == CoreModule.BLOCK) {
                worldIn.m_7731_(pos, ModSnowLayerBlock.copyProperties(state, CoreModule.TILE_BLOCK.m_49966_()), 48);
            }
            if ((blockEntity = worldIn.m_7702_(pos)) instanceof SnowBlockEntity) {
                SnowBlockEntity snowTile = (SnowBlockEntity)blockEntity;
                if (state.m_60734_() == CoreModule.TILE_BLOCK && snowTile.getState().m_60795_()) {
                    worldIn.m_7731_(pos, ModSnowLayerBlock.copyProperties(state, CoreModule.BLOCK.m_49966_()), 48);
                } else {
                    boolean bl = snowTile.options.renderOverlay = !snowTile.options.renderOverlay;
                    if (worldIn.f_46443_) {
                        worldIn.markAndNotifyBlock(pos, worldIn.m_46745_(pos), state, state, 11, 512);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (state.m_60734_() == CoreModule.BLOCK && (block = Block.m_49814_((Item)(context = new BlockPlaceContext(player, handIn, player.m_21120_(handIn), hit)).m_43722_().m_41720_())) != null && block != Blocks.f_50016_ && context.m_7058_() && (state2 = block.m_5573_(context)) != null && ModSnowLayerBlock.canContainState(state2) && state2.m_60710_((LevelReader)worldIn, pos)) {
            if (!worldIn.f_46443_) {
                worldIn.m_7731_(pos, state2, 48);
                block.m_6402_(worldIn, pos, state, (LivingEntity)player, context.m_43722_());
                int i = (Integer)state.m_61143_((Property)f_56581_);
                if (ModSnowLayerBlock.placeLayersOn(worldIn, pos, i, false, context, true) && !player.m_7500_()) {
                    context.m_43722_().m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60734_() instanceof SnowLayerBlock) {
            int i = (Integer)blockstate.m_61143_((Property)f_56581_);
            return (BlockState)blockstate.m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        ItemStack stack = context.m_43722_();
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag != null && tag.m_128461_("id").equals("snowrealmagic:snow")) {
            return CoreModule.TILE_BLOCK.m_49966_();
        }
        return this.m_49966_();
    }

    public static boolean canContainState(BlockState state) {
        if (!SnowCommonConfig.canPlaceSnowInBlock() || state.m_155947_() || !state.m_60819_().m_76178_()) {
            return false;
        }
        Block block = state.m_60734_();
        if (state.m_60620_(CoreModule.NOT_CONTAINABLES)) {
            return false;
        }
        if (state.m_60620_(CoreModule.CONTAINABLES) || block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof MushroomBlock || block instanceof SweetBerryBushBlock) {
            return true;
        }
        if (block instanceof FenceBlock && state.m_60620_((Tag)BlockTags.f_13039_)) {
            return ModSnowLayerBlock.hasAllProperties(state, CoreModule.FENCE.m_49966_());
        }
        if (block instanceof FenceGateBlock && state.m_60620_((Tag)BlockTags.f_13055_)) {
            return ModSnowLayerBlock.hasAllProperties(state, CoreModule.FENCE_GATE.m_49966_());
        }
        if (block instanceof WallBlock && state.m_60620_((Tag)BlockTags.f_13032_)) {
            return ModSnowLayerBlock.hasAllProperties(state, CoreModule.WALL.m_49966_());
        }
        if (block instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM && state.m_60620_((Tag)BlockTags.f_13031_)) {
            return true;
        }
        if (block instanceof StairBlock && state.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM && state.m_60620_((Tag)BlockTags.f_13030_)) {
            return ModSnowLayerBlock.hasAllProperties(state, CoreModule.STAIRS.m_49966_());
        }
        return false;
    }

    public static boolean convert(LevelAccessor world, BlockPos pos, BlockState state, int layers, int flags) {
        if (!SnowCommonConfig.canPlaceSnowInBlock() || state.m_155947_()) {
            return false;
        }
        Block block = state.m_60734_();
        if (state.m_60795_()) {
            world.m_7731_(pos, (BlockState)CoreModule.BLOCK.m_49966_().m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(layers)), flags);
            return true;
        }
        if (state.m_60620_(CoreModule.CONTAINABLES) || block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof MushroomBlock || block instanceof SweetBerryBushBlock) {
            world.m_7731_(pos, (BlockState)CoreModule.TILE_BLOCK.m_49966_().m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(layers)), flags);
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof SnowBlockEntity) {
                ((SnowBlockEntity)tile).setState(state);
            }
            return true;
        }
        BlockPos posDown = pos.m_7495_();
        BlockState stateDown = world.m_8055_(posDown);
        if (block instanceof StairBlock && block != CoreModule.STAIRS && state.m_60620_((Tag)BlockTags.f_13030_)) {
            newState = CoreModule.STAIRS.m_49966_();
            newState = ModSnowLayerBlock.copyProperties(state, newState);
            world.m_7731_(pos, newState, flags);
        } else if (block instanceof SlabBlock && block != CoreModule.SLAB && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM && state.m_60620_((Tag)BlockTags.f_13031_)) {
            world.m_7731_(pos, CoreModule.SLAB.m_49966_(), flags);
        } else if (block instanceof FenceBlock && block.getClass() != SnowFenceBlock.class && state.m_60620_((Tag)BlockTags.f_13039_)) {
            SnowFenceBlock newBlock = state.m_60620_((Tag)BlockTags.f_13098_) ? CoreModule.FENCE : CoreModule.FENCE2;
            BlockState newState = newBlock.m_49966_();
            newState = ModSnowLayerBlock.copyProperties(state, newState);
            newState = newState.m_60728_(Direction.DOWN, stateDown, world, pos, posDown);
            world.m_7731_(pos, newState, flags);
        } else if (block instanceof FenceGateBlock && block != CoreModule.FENCE_GATE && state.m_60620_((Tag)BlockTags.f_13055_)) {
            newState = CoreModule.FENCE_GATE.m_49966_();
            newState = ModSnowLayerBlock.copyProperties(state, newState);
            newState = newState.m_60728_(Direction.DOWN, stateDown, world, pos, posDown);
            world.m_7731_(pos, newState, flags);
        } else if (block instanceof WallBlock && block != CoreModule.WALL && state.m_60620_((Tag)BlockTags.f_13032_)) {
            newState = CoreModule.WALL.m_49966_();
            newState = ModSnowLayerBlock.copyProperties(state, newState);
            newState = newState.m_60728_(Direction.DOWN, stateDown, world, pos, posDown);
            world.m_7731_(pos, newState, flags);
        } else {
            return false;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof SnowBlockEntity) {
            ((SnowBlockEntity)tile).setState(state);
        }
        return true;
    }

    private static <T extends Comparable<T>> boolean hasAllProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : oldState.m_61148_().entrySet()) {
            Property property = (Property)entry.getKey();
            if (newState.m_61138_(property)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> BlockState copyProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : oldState.m_61148_().entrySet()) {
            Property property = (Property)entry.getKey();
            if (!newState.m_61138_(property)) continue;
            newState = (BlockState)newState.m_61124_(property, (Comparable)property.m_61709_().cast(entry.getValue()));
        }
        return newState;
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (SnowCommonConfig.snowReduceFallDamage) {
            if (!state.m_60713_((Block)this)) {
                return;
            }
            if (state.m_60734_() == CoreModule.BLOCK || state.m_60734_() == CoreModule.TILE_BLOCK) {
                entityIn.m_142535_(fallDistance, 0.2f, DamageSource.f_19315_);
                return;
            }
            state = worldIn.m_8055_(pos);
            entityIn.m_142535_(fallDistance, 1.0f - (float)((Integer)state.m_61143_((Property)f_56581_)).intValue() * 0.1f, DamageSource.f_19315_);
            return;
        }
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance);
    }

    public void m_141947_(Level worldIn, BlockPos pos, BlockState state, Entity entityIn) {
        double d0;
        if (SnowCommonConfig.thinnerBoundingBox && (d0 = Math.abs(entityIn.m_20184_().f_82480_)) < 0.1 && !entityIn.m_20161_()) {
            if (!state.m_60713_((Block)this)) {
                return;
            }
            int layers = (Integer)state.m_61143_((Property)f_56581_) - 1;
            double d1 = 1.0f - (float)layers * 0.05f;
            entityIn.m_20256_(entityIn.m_20184_().m_82542_(d1, 1.0, d1));
        }
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = this.getRaw(state, world, pos).getCloneItemStack(target, world, pos, player);
        return stack.m_41619_() ? new ItemStack((ItemLike)CoreModule.ITEM) : stack;
    }
}

