/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.kiwi.block.entity.BaseBlockEntity;
import snownee.kiwi.util.Util;
import snownee.snow.CoreModule;
import snownee.snow.block.SnowVariant;

public class SnowBlockEntity
extends BaseBlockEntity {
    public Options options = new Options();
    public static final ModelProperty<Options> OPTIONS = new ModelProperty();
    public static final ModelProperty<BlockState> BLOCKSTATE = new ModelProperty();
    protected BlockState state = Blocks.f_50016_.m_49966_();
    protected IModelData modelData;

    public SnowBlockEntity(BlockPos pos, BlockState state) {
        this(CoreModule.TILE, pos, state);
    }

    public SnowBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BlockState getState() {
        return this.state;
    }

    public void setState(BlockState state) {
        this.setState(state, true);
    }

    public boolean setState(BlockState state, boolean update) {
        if (state == null) {
            state = Blocks.f_50016_.m_49966_();
        }
        if (this.state == state || state.m_60734_() instanceof SnowVariant) {
            return false;
        }
        this.state = state;
        if (this.m_58898_()) {
            if (this.f_58857_.f_46443_) {
                this.getModelData().setData(BLOCKSTATE, (Object)state);
                this.onStateChanged();
            }
            if (update) {
                if (this.f_58857_.f_46443_) {
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
                } else {
                    this.refresh();
                }
            }
        }
        return true;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadState(compound, false);
    }

    protected void readPacketData(CompoundTag data) {
        this.loadState(data, true);
    }

    public void loadState(CompoundTag data, boolean network) {
        boolean changed = false;
        if (data.m_128441_("RO") && (changed = this.options.update(data.m_128471_("RO"), false)) && network && this.m_58898_() && this.f_58857_.f_46443_) {
            this.requestModelDataUpdate();
        }
        if (data.m_128441_("Block")) {
            ResourceLocation id = Util.RL((String)data.m_128461_("Block"));
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            if (block != null && block != Blocks.f_50016_) {
                changed |= this.setState(block.m_49966_(), network);
            }
        } else {
            changed |= this.setState(NbtUtils.m_129241_((CompoundTag)data.m_128469_("State")), network);
        }
        if (changed && network) {
            this.refresh();
        }
    }

    public void saveState(CompoundTag data, boolean network) {
        if (this.getState() == this.getState().m_60734_().m_49966_()) {
            data.m_128359_("Block", this.getState().m_60734_().getRegistryName().toString());
        } else {
            data.m_128365_("State", (Tag)NbtUtils.m_129202_((BlockState)this.getState()));
        }
        if (this.options.renderOverlay) {
            data.m_128379_("RO", this.options.renderOverlay);
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveState(compound, false);
    }

    protected CompoundTag writePacketData(CompoundTag data) {
        this.saveState(data, true);
        return data;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_);
    }

    public IModelData getModelData() {
        if (this.modelData == null) {
            this.modelData = new ModelDataMap.Builder().withInitial(BLOCKSTATE, (Object)this.state).withInitial(OPTIONS, (Object)this.options).build();
        }
        return this.modelData;
    }

    public void onStateChanged() {
        this.requestModelDataUpdate();
    }

    public static class Options {
        public boolean renderOverlay;
        public boolean renderBottom;

        public boolean update(boolean ro, boolean rb) {
            boolean changed = ro != this.renderOverlay || rb != this.renderBottom;
            this.renderOverlay = ro;
            this.renderBottom = rb;
            return changed;
        }
    }
}

