/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.ConfigUI;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.util.Util;

public class ClothConfigIntegration {
    private static final class_2561 requiresRestart = new class_2588("kiwi.config.requiresRestart").method_27692(class_124.field_1061);

    public static class_437 create(class_437 parent, String namespace) {
        ConfigBuilder builder = ConfigBuilder.create();
        builder.setParentScreen(parent);
        List<ConfigHandler> configs = KiwiConfigManager.allConfigs.stream().filter($ -> $.getModId().equals(namespace)).toList();
        Joiner joiner = Joiner.on((char)'.');
        for (ConfigHandler config : configs) {
            String titleKey = config.getFileName().equals(config.getModId() + "-" + config.getType().extension()) ? config.getType().extension() : (config.getFileName().equals(config.getModId() + "-modules") ? "modules" : config.getFileName());
            Object title = class_1074.method_4663((String)("kiwi.config." + titleKey)) ? new class_2588("kiwi.config." + titleKey) : new class_2585(Util.friendlyText(titleKey));
            ConfigCategory category = builder.getOrCreateCategory((class_2561)title);
            HashMap subCatsMap = Maps.newHashMap();
            ArrayList subCats = Lists.newArrayList();
            subCatsMap.put("", arg_0 -> ((ConfigCategory)category).addEntry(arg_0));
            for (ConfigHandler.Value<?> value : config.valueMap.values()) {
                ConfigUI.Hide hide = value.getAnnotation(ConfigUI.Hide.class);
                if (hide != null) continue;
                ArrayList path = Lists.newArrayList((Object[])value.path.split("\\."));
                String key = config.getModId() + ".config." + value.translation;
                title = class_1074.method_4663((String)key) ? new class_2588(key) : new class_2585(Util.friendlyText((String)path.get(path.size() - 1)));
                ConfigEntryBuilder entryBuilder = builder.entryBuilder();
                path.remove(path.size() - 1);
                String subCatKey = joiner.join((Iterable)path);
                Consumer subCat = subCatsMap.computeIfAbsent(subCatKey, $ -> {
                    String key0 = config.getModId() + ".config." + $;
                    Object title0 = class_1074.method_4663((String)key0) ? new class_2588(key0) : new class_2585(Util.friendlyText((String)path.get(path.size() - 1)));
                    SubCategoryBuilder builder0 = entryBuilder.startSubCategory((class_2561)title0);
                    builder0.setExpanded(true);
                    subCats.add(builder0);
                    return arg_0 -> ((SubCategoryBuilder)builder0).add(arg_0);
                });
                BooleanListEntry entry = null;
                Class<?> type = value.getType();
                if (type == Boolean.TYPE) {
                    BooleanToggleBuilder toggle = entryBuilder.startBooleanToggle((class_2561)title, ((Boolean)value.value).booleanValue());
                    toggle.setTooltip(ClothConfigIntegration.createComment(value));
                    toggle.setSaveConsumer($ -> value.accept($, config.onChanged));
                    entry = toggle.build();
                } else if (type == Integer.TYPE) {
                    ConfigUI.Color color = value.getAnnotation(ConfigUI.Color.class);
                    if (color != null) {
                        field = entryBuilder.startAlphaColorField((class_2561)title, ((Integer)value.value).intValue());
                        field.setAlphaMode(color.alpha());
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        entry = field.build();
                    } else if (value.getAnnotation(ConfigUI.Slider.class) != null) {
                        field = entryBuilder.startIntSlider((class_2561)title, ((Integer)value.value).intValue(), (int)value.min, (int)value.max);
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        entry = field.build();
                    } else {
                        field = entryBuilder.startIntField((class_2561)title, ((Integer)value.value).intValue());
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        if (!Double.isNaN(value.min)) {
                            field.setMin((int)value.min);
                        }
                        if (!Double.isNaN(value.max)) {
                            field.setMax((int)value.max);
                        }
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        entry = field.build();
                    }
                } else if (type == Double.TYPE) {
                    field = entryBuilder.startDoubleField((class_2561)title, ((Double)value.value).doubleValue());
                    field.setTooltip(ClothConfigIntegration.createComment(value));
                    if (!Double.isNaN(value.min)) {
                        field.setMin(value.min);
                    }
                    if (!Double.isNaN(value.max)) {
                        field.setMax(value.max);
                    }
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    entry = field.build();
                } else if (type == Float.TYPE) {
                    field = entryBuilder.startFloatField((class_2561)title, ((Float)value.value).floatValue());
                    field.setTooltip(ClothConfigIntegration.createComment(value));
                    if (!Double.isNaN(value.min)) {
                        field.setMin((float)value.min);
                    }
                    if (!Double.isNaN(value.max)) {
                        field.setMax((float)value.max);
                    }
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    entry = field.build();
                } else if (type == Long.TYPE) {
                    if (value.getAnnotation(ConfigUI.Slider.class) != null) {
                        field = entryBuilder.startLongSlider((class_2561)title, ((Long)value.value).longValue(), (long)value.min, (long)value.max);
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        entry = field.build();
                    } else {
                        field = entryBuilder.startLongField((class_2561)title, ((Long)value.value).longValue());
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        if (!Double.isNaN(value.min)) {
                            field.setMin((long)value.min);
                        }
                        if (!Double.isNaN(value.max)) {
                            field.setMax((long)value.max);
                        }
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        entry = field.build();
                    }
                } else if (type == String.class) {
                    field = entryBuilder.startTextField((class_2561)title, (String)value.value);
                    field.setTooltip(ClothConfigIntegration.createComment(value));
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    entry = field.build();
                }
                if (entry == null) continue;
                entry.setRequiresRestart(value.requiresRestart);
                subCat.accept(entry);
            }
            subCats.forEach($ -> category.addEntry((AbstractConfigListEntry)$.build()));
        }
        builder.setSavingRunnable(() -> configs.forEach(ConfigHandler::save));
        return builder.build();
    }

    private static Optional<class_2561[]> createComment(ConfigHandler.Value<?> value) {
        List<Object> tooltip = Lists.newArrayList();
        if (value.comment != null) {
            for (String comment : value.comment) {
                tooltip.add(new class_2585(comment));
            }
        }
        if (value.requiresRestart) {
            tooltip.add(requiresRestart);
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int width = KiwiClientConfig.tooltipWrapWidth;
        return (tooltip = tooltip.stream().map(s -> fontRenderer.method_27527().method_27495((class_5348)s, width, class_2583.field_24360)).flatMap(Collection::stream).map(class_5348::getString).map(class_2585::new).collect(Collectors.toList())).isEmpty() ? Optional.empty() : Optional.of(tooltip.toArray(new class_2561[0]));
    }
}

