/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.mixin.sodium;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.pipeline.BlockRenderer;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.snow.CoreModule;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.WatcherSnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.client.ClientVariables;
import snownee.snow.client.SnowClientConfig;
import snownee.snow.client.model.SnowVariantModel;

@Mixin(value={BlockRenderer.class}, remap=false)
public abstract class BlockRendererMixin {
    @Shadow
    private LightPipelineProvider lighters;
    @Shadow
    private Random random;
    @Shadow
    private BlockOcclusionCache occlusionCache;

    @Inject(method={"renderModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void srm_renderModel(BlockAndTintGetter lightReaderIn, BlockState blockStateIn, BlockPos posIn, BlockPos origin, BakedModel modelIn, ChunkModelBuilder buffers, boolean cull, long seed, IModelData modelData, CallbackInfoReturnable<Boolean> ci) {
        BlockState state;
        if (!(blockStateIn.m_60734_() instanceof SnowVariant)) {
            return;
        }
        if (!blockStateIn.m_155947_()) {
            return;
        }
        if (blockStateIn.m_61138_((Property)SnowLayerBlock.f_56581_) && (Integer)blockStateIn.m_61143_((Property)SnowLayerBlock.f_56581_) == 8) {
            return;
        }
        if (modelData == null) {
            modelData = EmptyModelData.INSTANCE;
        }
        if ((state = (BlockState)modelData.getData(SnowBlockEntity.BLOCKSTATE)) == null || !state.m_60795_() && state.m_60799_() != RenderShape.MODEL) {
            return;
        }
        boolean useSnowVariant = false;
        try {
            boolean canRender;
            RenderType cutoutMipped = RenderType.m_110457_();
            RenderType solid = RenderType.m_110451_();
            RenderType layer = MinecraftForgeClient.getRenderType();
            boolean ret = false;
            Block blockIn = blockStateIn.m_60734_();
            SnowBlockEntity.Options options = Optional.ofNullable((SnowBlockEntity.Options)modelData.getData(SnowBlockEntity.OPTIONS)).orElse(ClientVariables.fallbackOptions);
            if (layer == null) {
                canRender = layer == cutoutMipped;
            } else {
                if (layer == solid && blockIn instanceof WatcherSnowVariant) {
                    ((WatcherSnowVariant)blockIn).updateOptions(blockStateIn, (BlockGetter)lightReaderIn, posIn, options);
                }
                canRender = ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)layer);
            }
            double yOffset = 0.0;
            boolean slab = CoreModule.SLAB.is(blockStateIn);
            if (canRender && !state.m_60795_()) {
                BakedModel snowVariant;
                if (blockStateIn.m_61138_((Property)SnowLayerBlock.f_56581_) && state.m_204336_(CoreModule.OFFSET_Y)) {
                    if ((Integer)blockStateIn.m_61143_((Property)SnowLayerBlock.f_56581_) > 3) {
                        return;
                    }
                    yOffset = 0.1;
                }
                BakedModel model = this.getBlockModel(state);
                if (SnowClientConfig.snowVariants && model instanceof SnowVariantModel && (snowVariant = ((SnowVariantModel)model).getSnowVariant()) != null) {
                    model = snowVariant;
                    useSnowVariant = true;
                }
                ret |= this.renderModelWithYOffset(lightReaderIn, state, posIn, origin, model, buffers, cull, seed, modelData, yOffset);
            }
            if (options.renderBottom && (layer == null || layer == solid)) {
                if (ClientVariables.cachedSnowModel == null) {
                    ClientVariables.cachedSnowModel = this.getBlockModel(CoreModule.BLOCK.defaultBlockState());
                }
                ret |= this.renderModel(lightReaderIn, CoreModule.BLOCK.defaultBlockState(), posIn, origin, ClientVariables.cachedSnowModel, buffers, cull, seed, modelData);
            }
            if (slab || blockIn instanceof SnowLayerBlock) {
                if (options.renderOverlay && layer == cutoutMipped) {
                    if (ClientVariables.cachedOverlayModel == null) {
                        ClientVariables.cachedOverlayModel = Minecraft.m_91087_().m_91304_().getModel(ClientVariables.OVERLAY_MODEL);
                    }
                    BlockPos pos = posIn;
                    if (slab) {
                        yOffset = -0.375;
                    } else {
                        yOffset = -1.0;
                        pos = pos.m_7495_();
                    }
                    ret |= this.renderModelWithYOffset(lightReaderIn, CoreModule.BLOCK.defaultBlockState(), posIn, origin, ClientVariables.cachedOverlayModel, buffers, cull, seed, modelData, yOffset);
                }
            } else if (!options.renderOverlay || useSnowVariant) {
                ci.setReturnValue((Object)ret);
                return;
            }
            if (CoreModule.TILE_BLOCK.is(blockStateIn)) {
                if (layer != solid) {
                    ci.setReturnValue((Object)ret);
                    return;
                }
            } else if (layer != cutoutMipped) {
                ci.setReturnValue((Object)ret);
                return;
            }
            yOffset = ((SnowVariant)blockIn).getYOffset();
            ci.setReturnValue((Object)(ret |= this.renderModelWithYOffset(lightReaderIn, blockStateIn, posIn, origin, modelIn, buffers, cull, seed, modelData, yOffset)));
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being tesselated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)lightReaderIn, (BlockPos)posIn, (BlockState)blockStateIn);
            throw new ReportedException(crashreport);
        }
    }

    private BakedModel getBlockModel(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }

    private boolean renderModelWithYOffset(BlockAndTintGetter world, BlockState state, BlockPos pos, BlockPos origin, BakedModel model, ChunkModelBuilder buffers, boolean cull, long seed, IModelData modelData, double yOffset) {
        Vec3 offset = state.m_60824_((BlockGetter)world, pos);
        if (yOffset != 0.0) {
            offset = offset.m_82520_(0.0, yOffset, 0.0);
        }
        LightPipeline lighter = this.lighters.getLighter(this.getLightingMode(state, model, world, pos));
        boolean rendered = false;
        for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
            this.random.setSeed(seed);
            List sided = model.getQuads(state, dir, this.random, modelData);
            if (sided.isEmpty() || cull && !this.occlusionCache.shouldDrawSide(state, (BlockGetter)world, pos, dir)) continue;
            this.renderQuadList(world, state, pos, origin, lighter, offset, buffers, sided, dir);
            rendered = true;
        }
        this.random.setSeed(seed);
        List all = model.getQuads(state, null, this.random, modelData);
        if (!all.isEmpty()) {
            this.renderQuadList(world, state, pos, origin, lighter, offset, buffers, all, null);
            rendered = true;
        }
        return rendered;
    }

    @Shadow
    abstract boolean renderModel(BlockAndTintGetter var1, BlockState var2, BlockPos var3, BlockPos var4, BakedModel var5, ChunkModelBuilder var6, boolean var7, long var8, IModelData var10);

    @Shadow
    abstract LightMode getLightingMode(BlockState var1, BakedModel var2, BlockAndTintGetter var3, BlockPos var4);

    @Shadow
    abstract void renderQuadList(BlockAndTintGetter var1, BlockState var2, BlockPos var3, BlockPos var4, LightPipeline var5, Vec3 var6, ChunkModelBuilder var7, List<BakedQuad> var8, Direction var9);
}

