/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLPaths;
import snownee.kiwi.Kiwi;
import snownee.kiwi.config.KiwiConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.config.NightConfigUtil;
import snownee.kiwi.loader.Platform;

public class ConfigHandler {
    private boolean master;
    private final String modId;
    private final String fileName;
    private final KiwiConfig.ConfigType type;
    private ModConfig config;
    @Nullable
    private final Class<?> clazz;
    private final BiMap<Field, ForgeConfigSpec.ConfigValue<?>> valueMap = HashBiMap.create();
    private Method onChanged;

    public ConfigHandler(String modId, String fileName, KiwiConfig.ConfigType type, Class<?> clazz, boolean master) {
        this.master = master;
        this.modId = modId;
        this.clazz = clazz;
        this.fileName = fileName;
        this.type = type;
        KiwiConfigManager.register(this);
        if (clazz != null) {
            try {
                this.onChanged = clazz.getDeclaredMethod("onChanged", String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void init() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.build(builder);
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(this.modId).orElseThrow(NullPointerException::new);
        this.config = new ModConfig(ModConfig.Type.valueOf((String)this.type.name()), (IConfigSpec)builder.build(), modContainer, this.fileName + ".toml");
        modContainer.addConfig(this.config);
        if (modContainer instanceof FMLModContainer) {
            ((FMLModContainer)modContainer).getEventBus().addListener(this::onFileChange);
        }
    }

    private void build(ForgeConfigSpec.Builder builder) {
        if (this.master) {
            KiwiConfigManager.defineModules(this.modId, builder);
        }
        if (this.clazz == null) {
            return;
        }
        for (Field field : this.clazz.getFields()) {
            KiwiConfig.Translation translation;
            KiwiConfig.Comment comment;
            Class<?> type;
            int mods = field.getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || Modifier.isFinal(mods) || (type = field.getType()) != Integer.TYPE && type != Long.TYPE && type != Double.TYPE && type != Float.TYPE && type != Boolean.TYPE && type != String.class && !Enum.class.isAssignableFrom(type) && !List.class.isAssignableFrom(type)) continue;
            if (field.getAnnotation(KiwiConfig.LevelRestart.class) != null) {
                builder.worldRestart();
            }
            if ((comment = field.getAnnotation(KiwiConfig.Comment.class)) != null) {
                builder.comment(comment.value());
            }
            if ((translation = field.getAnnotation(KiwiConfig.Translation.class)) != null) {
                builder.translation(this.modId + ".config." + translation.value());
            }
            List<String> path = NightConfigUtil.getPath(field);
            ForgeConfigSpec.BooleanValue value = null;
            try {
                if (type == Integer.TYPE || type == Long.TYPE || type == Double.TYPE || type == Float.TYPE) {
                    double min = Double.NaN;
                    double max = Double.NaN;
                    KiwiConfig.Range range = field.getAnnotation(KiwiConfig.Range.class);
                    if (range != null) {
                        min = range.min();
                        max = range.max();
                    }
                    if (type == Integer.TYPE) {
                        value = builder.defineInRange(path, field.getInt(null), Double.isNaN(min) ? Integer.MIN_VALUE : (int)min, Double.isNaN(max) ? Integer.MAX_VALUE : (int)max);
                    } else if (type == Long.TYPE) {
                        value = builder.defineInRange(path, field.getLong(null), Double.isNaN(min) ? Long.MIN_VALUE : (long)min, Double.isNaN(max) ? Long.MAX_VALUE : (long)max);
                    } else if (type == Double.TYPE) {
                        value = builder.defineInRange(path, field.getDouble(null), Double.isNaN(min) ? Double.MIN_VALUE : min, Double.isNaN(max) ? Double.MAX_VALUE : max);
                    } else if (type == Float.TYPE) {
                        value = builder.defineInRange(path, (double)field.getFloat(null), Double.isNaN(min) ? Double.MIN_VALUE : min, Double.isNaN(max) ? Double.MAX_VALUE : max);
                    }
                } else if (type == String.class) {
                    String defaultVal = (String)field.get(null);
                    if (defaultVal == null) {
                        defaultVal = "";
                    }
                    value = builder.define(path, (Object)defaultVal);
                } else if (type == Boolean.TYPE) {
                    value = builder.define(path, field.getBoolean(null));
                } else if (Enum.class.isAssignableFrom(type)) {
                    value = builder.defineEnum(path, (Enum)field.get(null));
                } else if (List.class.isAssignableFrom(type)) {
                    List defaultVal = (List)field.get(null);
                    if (defaultVal == null) {
                        defaultVal = List.of();
                    }
                    value = builder.defineList(path, defaultVal, NightConfigUtil.getValidator(field));
                }
                this.valueMap.put((Object)field, (Object)value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Kiwi.logger.catching((Throwable)e);
            }
        }
    }

    public void refresh() {
        this.valueMap.forEach((field, value) -> {
            try {
                if (field.getType() == Float.TYPE) {
                    if (Objects.equals(Float.valueOf(((Double)value.get()).floatValue()), field.get(null))) {
                        return;
                    }
                    field.setFloat(null, ((Double)value.get()).floatValue());
                } else {
                    if (field.getType() != List.class && Objects.equals(value.get(), field.get(null))) {
                        return;
                    }
                    field.set(null, value.get());
                }
                Kiwi.logger.debug("Set " + field.getName() + " to " + value.get());
                if (this.onChanged != null) {
                    this.onChanged.invoke(null, Joiner.on((char)'.').join((Iterable)value.getPath()));
                }
            }
            catch (Exception e) {
                Kiwi.logger.catching((Throwable)e);
            }
        });
    }

    public void forceLoad() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Path path = this.type == KiwiConfig.ConfigType.SERVER ? Platform.getServer().m_129971_("serverconfig").toPath() : FMLPaths.CONFIGDIR.get();
        CommentedFileConfig configData = (CommentedFileConfig)this.config.getHandler().reader(path).apply(this.config);
        Field fCfg = ModConfig.class.getDeclaredField("configData");
        fCfg.setAccessible(true);
        fCfg.set(this.config, configData);
        this.config.getSpec().acceptConfig((CommentedConfig)configData);
        this.config.getHandler().unload(path, this.config);
    }

    protected void onFileChange(ModConfigEvent.Reloading event) {
        if (event.getConfig() == this.config) {
            ((CommentedFileConfig)event.getConfig().getConfigData()).load();
            this.refresh();
        }
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public boolean isMaster() {
        return this.master;
    }

    public String getModId() {
        return this.modId;
    }

    public KiwiConfig.ConfigType getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ModConfig getConfig() {
        return this.config;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public ForgeConfigSpec.ConfigValue<?> getValueByPath(String path) {
        Joiner joiner = Joiner.on((String)".");
        for (ForgeConfigSpec.ConfigValue value : this.valueMap.values()) {
            if (!path.equals(joiner.join((Iterable)value.getPath()))) continue;
            return value;
        }
        return null;
    }
}

