/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1535;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2582;
import net.minecraft.class_2591;
import net.minecraft.class_2806;
import net.minecraft.class_2939;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3773;
import net.minecraft.class_3816;
import net.minecraft.class_3827;
import net.minecraft.class_3828;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4648;
import net.minecraft.class_4652;
import net.minecraft.class_4663;
import net.minecraft.class_4996;
import net.minecraft.class_5142;
import net.minecraft.class_5202;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_5339;
import net.minecraft.class_5342;
import net.minecraft.class_5650;
import net.minecraft.class_5657;
import net.minecraft.class_5669;
import net.minecraft.class_5712;
import net.minecraft.class_5717;
import net.minecraft.class_5864;
import net.minecraft.class_6018;
import net.minecraft.class_6123;
import net.minecraft.class_6647;
import net.minecraft.class_6798;
import net.minecraft.class_6875;
import net.minecraft.class_7106;
import net.minecraft.class_7151;
import net.minecraft.class_7375;
import net.minecraft.class_7388;
import net.minecraft.class_7444;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiAnnotationData;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.LoadingContext;
import snownee.kiwi.Mod;
import snownee.kiwi.ModContext;
import snownee.kiwi.ModuleInfo;
import snownee.kiwi.RegistryLookup;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.block.def.SimpleBlockDefinition;
import snownee.kiwi.command.KiwiCommand;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.AnnotatedTypeLoader;
import snownee.kiwi.loader.KiwiConfiguration;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.loader.event.ServerInitEvent;
import snownee.kiwi.network.Networking;
import snownee.kiwi.util.Util;

@Mod(value="kiwi")
public class Kiwi
implements ModInitializer {
    public static final String MODID = "kiwi";
    public static final String NAME = "Kiwi";
    public static Logger logger = LogManager.getLogger((String)"Kiwi");
    static final Marker MARKER = MarkerManager.getMarker((String)"Init");
    private static Multimap<String, KiwiAnnotationData> moduleData = ArrayListMultimap.create();
    public static Map<class_2960, Boolean> defaultOptions = Maps.newHashMap();
    private static Map<KiwiAnnotationData, String> conditions = Maps.newHashMap();
    public static final RegistryLookup registryLookup = new RegistryLookup();
    private static Map<String, class_1761> GROUP_CACHE = Maps.newHashMap();
    public static MinecraftServer currentServer;
    private static boolean tagsUpdated;

    public void onInitialize() {
        try {
            Kiwi.registerRegistries();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap classOptionalMap = Maps.newHashMap();
        String dist = Platform.isPhysicalClient() ? "client" : "server";
        List<String> mods = FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).filter($ -> !"builtin".equals($.getType())).map(ModMetadata::getId).toList();
        for (String mod : mods) {
            AnnotatedTypeLoader loader;
            KiwiConfiguration configuration;
            if (mod.startsWith("fabric") || (configuration = (loader = new AnnotatedTypeLoader(mod)).get()) == null) continue;
            for (KiwiAnnotationData module : configuration.modules) {
                if (!Kiwi.checkDist(module, dist)) continue;
                moduleData.put((Object)mod, (Object)module);
            }
            for (KiwiAnnotationData optional : configuration.optionals) {
                if (!Kiwi.checkDist(optional, dist)) continue;
                classOptionalMap.put(optional.target(), optional);
            }
            for (KiwiAnnotationData condition : configuration.conditions) {
                if (!Kiwi.checkDist(condition, dist)) continue;
                conditions.put(condition, mod);
            }
            for (KiwiAnnotationData config : configuration.configs) {
                if (!Kiwi.checkDist(config, dist)) continue;
                KiwiConfig.ConfigType type = null;
                try {
                    type = KiwiConfig.ConfigType.valueOf((String)config.data().get("type"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                KiwiConfig.ConfigType configType = type = type == null ? KiwiConfig.ConfigType.COMMON : type;
                if (type == KiwiConfig.ConfigType.CLIENT && !Platform.isPhysicalClient()) continue;
                try {
                    boolean hasModules;
                    Class<?> clazz = Class.forName(config.target());
                    String fileName = (String)config.data().get("value");
                    boolean bl = hasModules = type == KiwiConfig.ConfigType.COMMON && Strings.isNullOrEmpty((String)fileName);
                    if (Strings.isNullOrEmpty((String)fileName)) {
                        fileName = String.format("%s-%s", mod, type.extension());
                    }
                    new ConfigHandler(mod, fileName, type, clazz, hasModules);
                }
                catch (ClassNotFoundException e) {
                    logger.catching((Throwable)e);
                }
            }
            for (KiwiAnnotationData packet : configuration.packets) {
                if (!Kiwi.checkDist(packet, dist)) continue;
                Networking.processClass(packet.target(), mod);
            }
        }
        logger.info(MARKER, "Processing " + moduleData.size() + " KiwiModule annotations");
        for (Map.Entry entry : moduleData.entries()) {
            Boolean defaultEnabled;
            String modid;
            KiwiAnnotationData optional = (KiwiAnnotationData)classOptionalMap.get(((KiwiAnnotationData)entry.getValue()).target());
            if (optional == null || !Platform.isModLoaded(modid = (String)entry.getKey())) continue;
            String name = (String)((KiwiAnnotationData)entry.getValue()).data().get("value");
            if (Strings.isNullOrEmpty((String)name)) {
                name = "core";
            }
            if ((defaultEnabled = (Boolean)optional.data().get("defaultEnabled")) == null) {
                defaultEnabled = Boolean.TRUE;
            }
            defaultOptions.put(new class_2960(modid, name), defaultEnabled);
        }
        KiwiConfigManager.init();
        CommandRegistrationCallback.EVENT.register(KiwiCommand::register);
        ServerLifecycleEvents.SERVER_STARTING.register(this::serverInit);
        ServerLifecycleEvents.SERVER_STOPPED.register($ -> {
            currentServer = null;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> Util.onAttackEntity(player, world, hand, entity, hitResult));
        if (Platform.isPhysicalClient()) {
            KiwiModule.RenderLayer.Layer.CUTOUT.value = class_1921.method_23581();
            KiwiModule.RenderLayer.Layer.CUTOUT_MIPPED.value = class_1921.method_23579();
            KiwiModule.RenderLayer.Layer.TRANSLUCENT.value = class_1921.method_23583();
            ClientLifecycleEvents.CLIENT_STARTED.register(this::clientInit);
        }
        this.preInit();
    }

    private static boolean checkDist(KiwiAnnotationData annotationData, String dist) {
        try {
            ClassNode clazz = new ClassNode(458752);
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(annotationData.target().replace('.', '/') + ".class");
            ClassReader classReader = new ClassReader(is);
            classReader.accept((ClassVisitor)clazz, 0);
            if (clazz.visibleAnnotations != null) {
                String ONLYIN = Type.getDescriptor(Environment.class);
                for (AnnotationNode node : clazz.visibleAnnotations) {
                    int i;
                    if (node.values == null || !ONLYIN.equals(node.desc) || (i = node.values.indexOf("value")) == -1 || node.values.get(i + 1).equals(dist)) continue;
                    return false;
                }
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    private void preInit() {
        HashSet disabledModules = Sets.newHashSet();
        conditions.forEach((k, v) -> {
            try {
                Class<?> clazz = Class.forName(k.target());
                String methodName = (String)k.data().get("method");
                List<String> values = (List<String>)k.data().get("value");
                if (values == null) {
                    values = Arrays.asList(v);
                }
                List<class_2960> ids = values.stream().map(s -> Kiwi.checkPrefix(s, v)).toList();
                for (class_2960 id : ids) {
                    LoadingContext context = new LoadingContext(id);
                    try {
                        Boolean bl = (Boolean)MethodUtils.invokeExactStaticMethod(clazz, (String)methodName, (Object[])new Object[]{context});
                        if (bl.booleanValue()) continue;
                        disabledModules.add(id);
                    }
                    catch (Exception e) {
                        disabledModules.add(id);
                        throw e;
                        return;
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.error(MARKER, "Failed to access to LoadingCondition: {}", k);
                logger.catching((Throwable)e);
            }
        });
        HashMap infos = Maps.newHashMap();
        boolean checkDep = false;
        block8: for (Object entry : moduleData.entries()) {
            class_2960 rl;
            KiwiAnnotationData module = (KiwiAnnotationData)entry.getValue();
            String string = (String)entry.getKey();
            if (!Platform.isModLoaded(string)) continue;
            String name = (String)module.data().get("value");
            if (Strings.isNullOrEmpty((String)name)) {
                name = "core";
            }
            if (disabledModules.contains(rl = new class_2960(string, name))) {
                if (KiwiConfigManager.modules.containsKey(rl)) continue;
                throw new RuntimeException("Cannot load mandatory module: " + rl);
            }
            if (KiwiConfigManager.modules.containsKey(rl) && !KiwiConfigManager.modules.get(rl).get().booleanValue()) continue;
            Info info = new Info(rl, module.target());
            String dependencies = (String)module.data().get("dependencies");
            List<String> rules = List.of(Strings.nullToEmpty((String)dependencies).split(";")).stream().filter(s -> !Strings.isNullOrEmpty((String)s)).toList();
            for (String rule : rules) {
                if (rule.startsWith("@")) {
                    info.moduleRules.add(Util.RL(rule.substring(1), string));
                    checkDep = true;
                    continue;
                }
                if (Platform.isModLoaded(rule)) continue;
                continue block8;
            }
            infos.put(rl, info);
        }
        ImmutableList moduleLoadingQueue = null;
        moduleLoadingQueue = checkDep ? ImmutableList.copyOf(infos.keySet()) : ImmutableList.copyOf(infos.keySet());
        for (class_2960 id : moduleLoadingQueue) {
            Info info = (Info)infos.get(id);
            ModContext context = ModContext.get(id.method_12836());
            context.setActiveContainer();
            try {
                Class<?> clazz = Class.forName(info.className);
                AbstractModule instance = (AbstractModule)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                KiwiModules.add(id, instance, context);
            }
            catch (Exception e) {
                logger.error(MARKER, "Kiwi failed to initialize module class: {}", (Object)info.className);
                logger.catching((Throwable)e);
            }
        }
        moduleData.clear();
        moduleData = null;
        defaultOptions.clear();
        defaultOptions = null;
        conditions.clear();
        conditions = null;
        Object2IntArrayMap counter = new Object2IntArrayMap();
        for (ModuleInfo moduleInfo : KiwiModules.get()) {
            String val;
            KiwiModule.Category group;
            boolean useOwnGroup;
            counter.clear();
            moduleInfo.context.setActiveContainer();
            boolean bl = useOwnGroup = moduleInfo.category == null;
            if (useOwnGroup && (group = moduleInfo.module.getClass().getDeclaredAnnotation(KiwiModule.Category.class)) != null && !(val = group.value()).isEmpty()) {
                useOwnGroup = false;
                class_1761 itemGroup = Kiwi.getGroup(val);
                if (itemGroup != null) {
                    moduleInfo.category = itemGroup;
                }
            }
            String modid = moduleInfo.module.uid.method_12836();
            String name = moduleInfo.module.uid.method_12832();
            class_1792.class_1793 tmpBuilder = null;
            Field tmpBuilderField = null;
            for (Field field : moduleInfo.module.getClass().getFields()) {
                class_2378 registry;
                int mods;
                if (field.getAnnotation(KiwiModule.Skip.class) != null || !Modifier.isPublic(mods = field.getModifiers()) || !Modifier.isStatic(mods)) continue;
                KiwiModule.Name nameAnnotation = field.getAnnotation(KiwiModule.Name.class);
                class_2960 regName = nameAnnotation != null ? Kiwi.checkPrefix(nameAnnotation.value(), modid) : Kiwi.checkPrefix(field.getName().toLowerCase(Locale.ENGLISH), modid);
                if (field.getType() == moduleInfo.module.getClass() && "instance".equals(regName.method_12832()) && regName.method_12836().equals(modid)) {
                    try {
                        field.set(null, moduleInfo.module);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        logger.error(MARKER, "Kiwi failed to inject module instance to module class: {}", (Object)moduleInfo.module.uid);
                        logger.catching((Throwable)e);
                    }
                    continue;
                }
                Object o = null;
                try {
                    o = field.get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    logger.error(MARKER, "Kiwi failed to catch game object: {}", (Object)field);
                    logger.catching((Throwable)e);
                }
                if (o == null) continue;
                if (useOwnGroup && moduleInfo.category == null && o instanceof class_1761) {
                    moduleInfo.category = (class_1761)o;
                } else if (o instanceof class_1792.class_1793) {
                    tmpBuilder = (class_1792.class_1793)o;
                    tmpBuilderField = field;
                    continue;
                }
                if (o instanceof KiwiGO) {
                    KiwiGO kiwiGO = (KiwiGO)o;
                    o = kiwiGO.create(regName);
                    registry = (class_2378)kiwiGO.registry();
                } else {
                    registry = registryLookup.findRegistry(o);
                }
                if (registry != null) {
                    if (o instanceof class_2248) {
                        if (field.getAnnotation(KiwiModule.NoItem.class) != null) {
                            moduleInfo.noItems.add((class_2248)o);
                        }
                        Kiwi.checkNoGroup(moduleInfo, field, o);
                        if (tmpBuilder != null) {
                            moduleInfo.blockItemBuilders.put((class_2248)o, tmpBuilder);
                            try {
                                tmpBuilderField.set(moduleInfo.module, null);
                            }
                            catch (Exception e) {
                                logger.error(MARKER, "Kiwi failed to clean used item builder: {}", (Object)tmpBuilderField);
                                logger.catching((Throwable)e);
                            }
                        }
                    } else if (o instanceof class_1792) {
                        Kiwi.checkNoGroup(moduleInfo, field, o);
                    }
                    class_5321 superType = registry.method_30517();
                    int i = counter.getOrDefault((Object)superType, 0);
                    counter.put((Object)superType, i + 1);
                    moduleInfo.register(o, regName, registry, field);
                }
                tmpBuilder = null;
                tmpBuilderField = null;
            }
            logger.info(MARKER, "Module [{}:{}] initialized", (Object)modid, (Object)name);
            for (class_5321 key : counter.keySet()) {
                String keyName = Util.trimRL(key.method_29177());
                logger.info(MARKER, "    {}: {}", (Object)keyName, (Object)counter.getInt((Object)key));
            }
        }
        KiwiModules.ALL_USED_REGISTRIES.add(class_2378.field_11142);
        KiwiModules.fire(ModuleInfo::preInit);
    }

    public static <T> void registerRegistry(class_2378<? extends T> registry, Class<? extends T> baseClass) {
        Objects.requireNonNull(registryLookup);
        Kiwi.registryLookup.registries.put(baseClass, registry);
    }

    private static <T> void registerRegistries() throws Exception {
        Kiwi.registerRegistry(class_2378.field_28264, class_5712.class);
        Kiwi.registerRegistry(class_2378.field_11156, class_3414.class);
        Kiwi.registerRegistry(class_2378.field_11154, class_3611.class);
        Kiwi.registerRegistry(class_2378.field_11159, class_1291.class);
        Kiwi.registerRegistry(class_2378.field_11146, class_2248.class);
        Kiwi.registerRegistry(class_2378.field_11160, class_1887.class);
        Kiwi.registerRegistry(class_2378.field_11145, class_1299.class);
        Kiwi.registerRegistry(class_2378.field_11142, class_1792.class);
        Kiwi.registerRegistry(class_2378.field_11143, class_1842.class);
        Kiwi.registerRegistry(class_2378.field_11141, class_2396.class);
        Kiwi.registerRegistry(class_2378.field_11137, class_2591.class);
        Kiwi.registerRegistry(class_2378.field_11150, class_1535.class);
        Kiwi.registerRegistry(class_2378.field_11158, class_2960.class);
        Kiwi.registerRegistry(class_2378.field_16643, class_2806.class);
        Kiwi.registerRegistry(class_2378.field_16792, class_3827.class);
        Kiwi.registerRegistry(class_2378.field_23398, class_4996.class);
        Kiwi.registerRegistry(class_2378.field_17429, class_3917.class);
        Kiwi.registerRegistry(class_2378.field_17597, class_3956.class);
        Kiwi.registerRegistry(class_2378.field_17598, class_1865.class);
        Kiwi.registerRegistry(class_2378.field_23781, class_1320.class);
        Kiwi.registerRegistry(class_2378.field_28265, class_5717.class);
        Kiwi.registerRegistry(class_2378.field_38000, class_2314.class);
        Kiwi.registerRegistry(class_2378.field_11152, class_3448.class);
        Kiwi.registerRegistry(class_2378.field_17166, class_3854.class);
        Kiwi.registerRegistry(class_2378.field_17167, class_3852.class);
        Kiwi.registerRegistry(class_2378.field_18792, class_4158.class);
        Kiwi.registerRegistry(class_2378.field_18793, class_4140.class);
        Kiwi.registerRegistry(class_2378.field_18794, class_4149.class);
        Kiwi.registerRegistry(class_2378.field_18795, class_4170.class);
        Kiwi.registerRegistry(class_2378.field_18796, class_4168.class);
        Kiwi.registerRegistry(class_2378.field_25293, class_5338.class);
        Kiwi.registerRegistry(class_2378.field_25294, class_5339.class);
        Kiwi.registerRegistry(class_2378.field_25299, class_5342.class);
        Kiwi.registerRegistry(class_2378.field_28008, class_5657.class);
        Kiwi.registerRegistry(class_2378.field_28009, class_5650.class);
        Kiwi.registerRegistry(class_2378.field_28010, class_5669.class);
        Kiwi.registerRegistry(class_2378.field_29076, class_5864.class);
        Kiwi.registerRegistry(class_2378.field_33093, class_6018.class);
        Kiwi.registerRegistry(class_2378.field_33095, class_6123.class);
        Kiwi.registerRegistry(class_2378.field_35090, class_6647.class);
        Kiwi.registerRegistry(class_2378.field_11157, class_2939.class);
        Kiwi.registerRegistry(class_2378.field_11138, class_3031.class);
        Kiwi.registerRegistry(class_2378.field_36467, class_6875.class);
        Kiwi.registerRegistry(class_2378.field_16645, class_3773.class);
        Kiwi.registerRegistry(class_2378.field_16644, class_7151.class);
        Kiwi.registerRegistry(class_2378.field_35760, class_6798.class);
        Kiwi.registerRegistry(class_2378.field_21445, class_4652.class);
        Kiwi.registerRegistry(class_2378.field_21447, class_4648.class);
        Kiwi.registerRegistry(class_2378.field_23782, class_5142.class);
        Kiwi.registerRegistry(class_2378.field_38807, class_7388.class);
        Kiwi.registerRegistry(class_2378.field_21448, class_4663.class);
        Kiwi.registerRegistry(class_2378.field_24331, class_5202.class);
        Kiwi.registerRegistry(class_2378.field_16794, class_3828.class);
        Kiwi.registerRegistry(class_2378.field_16793, class_3816.class);
        Kiwi.registerRegistry(class_2378.field_38803, class_7375.class);
        Kiwi.registerRegistry(class_2378.field_38805, class_7106.class);
        Kiwi.registerRegistry(class_2378.field_39208, class_2582.class);
        Kiwi.registerRegistry(class_2378.field_39210, class_7444.class);
    }

    static class_1761 getGroup(String path) {
        if (GROUP_CACHE == null) {
            return null;
        }
        return GROUP_CACHE.computeIfAbsent(path, $ -> {
            for (class_1761 group : class_1761.field_7921) {
                if (!path.equals(group.method_7751())) continue;
                return group;
            }
            return null;
        });
    }

    private static void checkNoGroup(ModuleInfo info, Field field, Object o) {
        if (field.getAnnotation(KiwiModule.NoCategory.class) != null) {
            info.noCategories.add(o);
        }
    }

    private void init() {
        KiwiConfigManager.refresh();
        InitEvent e = new InitEvent();
        KiwiModules.fire(m -> m.init(e));
        BlockDefinition.registerFactory(SimpleBlockDefinition.Factory.INSTANCE);
    }

    @Environment(value=EnvType.CLIENT)
    private void clientInit(class_310 mc) {
        if (GROUP_CACHE == null) {
            return;
        }
        this.init();
        ClientInitEvent e = new ClientInitEvent();
        KiwiModules.fire(m -> m.clientInit(e));
        this.postInit();
        this.loadComplete();
    }

    private void serverInit(MinecraftServer server) {
        currentServer = server;
        if (GROUP_CACHE == null) {
            return;
        }
        if (server.method_3816()) {
            this.init();
        }
        ServerInitEvent e = new ServerInitEvent();
        KiwiModules.fire(m -> m.serverInit(e));
        if (server.method_3816()) {
            this.postInit();
            this.loadComplete();
        }
    }

    private void postInit() {
        PostInitEvent e = new PostInitEvent();
        KiwiModules.fire(m -> m.postInit(e));
        KiwiModules.clear();
    }

    private void loadComplete() {
        GROUP_CACHE.clear();
        GROUP_CACHE = null;
        Kiwi.registryLookup.cache.invalidateAll();
    }

    public static boolean isLoaded(class_2960 module) {
        return KiwiModules.isLoaded(module);
    }

    private static class_2960 checkPrefix(String name, String defaultModid) {
        if (name.contains(":")) {
            return new class_2960(name);
        }
        return new class_2960(defaultModid, name);
    }

    public static void onTagsUpdated() {
        tagsUpdated = true;
    }

    public static boolean areTagsUpdated() {
        return tagsUpdated;
    }

    private static final class Info {
        final class_2960 id;
        final String className;
        final List<class_2960> moduleRules = Lists.newLinkedList();

        public Info(class_2960 id, String className) {
            this.id = id;
            this.className = className;
        }
    }
}

