/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.block.def;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4538;
import net.minecraft.class_4696;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.loader.Platform;

public class SimpleBlockDefinition
implements BlockDefinition {
    public static final MethodHandle GET_STATE_FOR_PLACEMENT;
    public static final String TYPE = "Block";
    private static final Map<class_2680, SimpleBlockDefinition> MAP;
    public final class_2680 state;
    @Environment(value=EnvType.CLIENT)
    private class_4730[] materials;

    @Nullable
    private static class_2680 getStateForPlacement(class_1747 blockItem, class_1750 context) {
        try {
            return GET_STATE_FOR_PLACEMENT.invokeExact(blockItem, context);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static SimpleBlockDefinition of(class_2680 state) {
        if (state.method_26204() == class_2246.field_10219) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(false));
        }
        return MAP.computeIfAbsent(state, SimpleBlockDefinition::new);
    }

    private SimpleBlockDefinition(class_2680 state) {
        this.state = state;
        if (Platform.isPhysicalClient()) {
            this.materials = new class_4730[7];
        }
    }

    @Override
    public BlockDefinition.Factory<?> getFactory() {
        return Factory.INSTANCE;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1087 model() {
        return class_310.method_1551().method_1541().method_3351().method_3335(this.state);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_4730 renderMaterial(class_2350 direction) {
        int index;
        int n = index = direction == null ? 0 : direction.ordinal() + 1;
        if (this.materials[index] == null) {
            class_2960 particleIcon;
            class_1087 model = this.model();
            class_5819 random = class_5819.method_43047();
            random.method_43052(42L);
            class_2960 sprite = particleIcon = model.method_4711().method_4598();
            if (this.state.method_26204() == class_2246.field_10219) {
                direction = class_2350.field_11036;
            }
            if (direction != null) {
                class_777 quad;
                List quads = model.method_4707(this.state, direction, random);
                if (quads.isEmpty()) {
                    quads = model.method_4707(this.state, null, random);
                }
                Iterator iterator = quads.iterator();
                while (iterator.hasNext() && !(sprite = (quad = (class_777)iterator.next()).method_35788().method_4598()).equals((Object)particleIcon)) {
                }
            }
            this.materials[index] = new class_4730(class_1059.field_5275, sprite);
        }
        return this.materials[index];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean canRenderInLayer(class_1921 layer) {
        return class_4696.method_23683((class_2680)this.state, (boolean)false) == layer;
    }

    @Override
    public boolean canOcclude() {
        return this.state.method_26225();
    }

    @Override
    public void save(class_2487 tag) {
        tag.method_10566(TYPE, (class_2520)class_2512.method_10686((class_2680)this.state));
    }

    public String toString() {
        return this.state.toString();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int getColor(class_2680 blockState, class_1920 level, class_2338 worldPosition, int index) {
        return class_310.method_1551().method_1505().method_1697(this.state, level, worldPosition, index);
    }

    @Override
    public class_2561 getDescription() {
        return this.state.method_26204().method_9518();
    }

    @Override
    public void place(class_1937 level, class_2338 pos) {
        class_2680 state = this.state;
        if (state.method_28498((class_2769)class_2741.field_12548)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false));
        }
        level.method_8501(pos, state);
    }

    @Override
    public class_1799 createItem(class_239 target, class_1922 world, class_2338 pos, class_1657 player) {
        if (this.state.method_26204() instanceof BlockPickInteractionAware) {
            return ((BlockPickInteractionAware)this.state.method_26204()).getPickedStack(this.state, world, pos, player, target);
        }
        return this.state.method_26204().method_9574(world, pos, this.state);
    }

    @Override
    public class_2680 getBlockState() {
        return this.state;
    }

    @Override
    public class_2498 getSoundType() {
        return this.state.method_26231();
    }

    public static void reload() {
        for (SimpleBlockDefinition supplier : MAP.values()) {
            Arrays.fill(supplier.materials, null);
        }
    }

    static {
        MethodHandle m = null;
        try {
            String methodName = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_1747", "method_7707", "(Lnet/minecraft/class_1750;)Lnet/minecraft/class_2680;");
            m = MethodHandles.lookup().unreflect(class_1747.class.getDeclaredMethod(methodName, class_1750.class));
        }
        catch (Exception e) {
            throw new RuntimeException("Report this to author", e);
        }
        GET_STATE_FOR_PLACEMENT = m;
        MAP = Maps.newIdentityHashMap();
    }

    public static enum Factory implements BlockDefinition.Factory<SimpleBlockDefinition>
    {
        INSTANCE;


        @Override
        public SimpleBlockDefinition fromNBT(class_2487 tag) {
            class_2680 state = class_2512.method_10681((class_2487)tag.method_10562(SimpleBlockDefinition.TYPE));
            if (state.method_26215()) {
                return null;
            }
            return SimpleBlockDefinition.of(state);
        }

        @Override
        public SimpleBlockDefinition fromBlock(class_2680 state, class_2586 blockEntity, class_4538 level, class_2338 pos) {
            return SimpleBlockDefinition.of(state);
        }

        @Override
        public SimpleBlockDefinition fromItem(class_1799 stack, class_1750 context) {
            if (!(stack.method_7909() instanceof class_1747)) {
                return null;
            }
            class_1747 blockItem = (class_1747)stack.method_7909();
            if (context == null) {
                return SimpleBlockDefinition.of(blockItem.method_7711().method_9564());
            }
            if ((context = blockItem.method_16356(context)) == null) {
                return null;
            }
            class_2680 state = SimpleBlockDefinition.getStateForPlacement(blockItem, context);
            if (state == null) {
                return null;
            }
            return SimpleBlockDefinition.of(state);
        }

        @Override
        public String getId() {
            return SimpleBlockDefinition.TYPE;
        }
    }
}

