/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import snownee.kiwi.config.ClothConfigIntegration;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;

public class ModMenuIntegration
implements ModMenuApi {
    private Map<String, ConfigScreenFactory<?>> cachedFactories;

    public Map<String, ConfigScreenFactory<?>> factories() {
        if (this.cachedFactories == null) {
            if (Platform.isModLoaded("cloth-config")) {
                Set mods = KiwiConfigManager.allConfigs.stream().map($ -> $.getModId()).collect(Collectors.toSet());
                HashMap factories = Maps.newHashMap();
                for (String mod : mods) {
                    factories.put(mod, $ -> ClothConfigIntegration.create($, mod));
                }
                this.cachedFactories = ImmutableMap.copyOf((Map)factories);
            } else {
                this.cachedFactories = ImmutableMap.of();
            }
        }
        return this.cachedFactories;
    }

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return this.factories().getOrDefault("kiwi", screen -> null);
    }

    public Map<String, ConfigScreenFactory<?>> getProvidedConfigScreenFactories() {
        return this.factories();
    }
}

