/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.block.entity.RetextureBlockEntity;
import snownee.kiwi.data.DataModule;
import snownee.kiwi.recipe.FullBlockIngredient;
import snownee.kiwi.recipe.crafting.DynamicShapedRecipe;

public class RetextureRecipe
extends DynamicShapedRecipe {
    private Char2ObjectMap<String[]> textureKeys;

    public RetextureRecipe(class_2960 idIn) {
        super(idIn);
    }

    @Override
    public boolean matches(class_1715 inv, int x, int y, int rx, int ry) {
        class_1799 stack = inv.method_5438(x + y * inv.method_17398());
        return (this.getEmpty().test(stack) || FullBlockIngredient.isTextureBlock(stack)) && super.matches(inv, x, y, rx, ry);
    }

    @Override
    public class_1799 assemble(class_1715 inv) {
        int[] pos = this.search(inv);
        if (pos == null) {
            return class_1799.field_8037;
        }
        class_1799 stack = this.recipeOutput.method_7972();
        HashMap map = Maps.newHashMap();
        for (Char2ObjectMap.Entry e : this.textureKeys.char2ObjectEntrySet()) {
            class_1799 item = this.item(e.getCharKey(), inv, pos);
            BlockDefinition def = BlockDefinition.fromItem(item, null);
            for (String k : (String[])e.getValue()) {
                map.put(k, def);
            }
        }
        RetextureBlockEntity.writeTextures(map, stack.method_7911("BlockEntityTag"));
        return stack;
    }

    @Override
    public class_1865<?> method_8119() {
        return DataModule.RETEXTURE.get();
    }

    public static class Serializer
    extends DynamicShapedRecipe.Serializer<RetextureRecipe> {
        public RetextureRecipe fromJson(class_2960 pRecipeId, JsonObject pSerializedRecipe) {
            RetextureRecipe recipe = new RetextureRecipe(pRecipeId);
            Serializer.fromJson(recipe, pSerializedRecipe);
            JsonObject o = pSerializedRecipe.getAsJsonObject("texture");
            recipe.textureKeys = new Char2ObjectArrayMap(o.size());
            for (Map.Entry e : o.entrySet()) {
                JsonArray jsonArray = ((JsonElement)e.getValue()).getAsJsonArray();
                String[] keys = new String[jsonArray.size()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = jsonArray.get(i).getAsString();
                }
                recipe.textureKeys.put(((String)e.getKey()).charAt(0), (Object)keys);
            }
            return recipe;
        }

        public RetextureRecipe fromNetwork(class_2960 pRecipeId, class_2540 pBuffer) {
            RetextureRecipe recipe = new RetextureRecipe(pRecipeId);
            Serializer.fromNetwork(recipe, pBuffer);
            int size = pBuffer.method_10816();
            recipe.textureKeys = new Char2ObjectArrayMap(size);
            for (int i = 0; i < size; ++i) {
                char ch = pBuffer.readChar();
                int size2 = pBuffer.method_10816();
                String[] arr = new String[size2];
                for (int j = 0; j < size2; ++j) {
                    arr[j] = pBuffer.method_10800(16);
                }
                recipe.textureKeys.put(ch, (Object)arr);
            }
            return recipe;
        }

        @Override
        public void toNetwork(class_2540 buffer, RetextureRecipe recipe) {
            super.toNetwork(buffer, recipe);
            buffer.method_10804(recipe.textureKeys.size());
            for (Char2ObjectMap.Entry e : recipe.textureKeys.char2ObjectEntrySet()) {
                buffer.writeChar((int)e.getCharKey());
                buffer.method_10804(((String[])e.getValue()).length);
                for (String s : (String[])e.getValue()) {
                    buffer.method_10788(s, 16);
                }
            }
        }
    }
}

