/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.util.EnumUtil;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.EntitySnowLayerBlock;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowFenceGateBlock;
import snownee.snow.block.SnowSlabBlock;
import snownee.snow.block.SnowStairsBlock;
import snownee.snow.block.SnowWallBlock;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.block.entity.SnowCoveredBlockEntity;
import snownee.snow.client.FallingSnowRenderer;
import snownee.snow.client.SnowClient;
import snownee.snow.datagen.SnowBlockTagsProvider;
import snownee.snow.entity.FallingSnowEntity;
import snownee.snow.loot.NormalLootEntry;
import snownee.snow.mixin.BlockAccess;
import snownee.snow.mixin.IntegerValueAccess;

@KiwiModule
@KiwiModule.Subscriber(modBus=true)
public class CoreModule
extends AbstractModule {
    public static final TagKey<Block> BOTTOM_SNOW = CoreModule.blockTag((String)"snowrealmagic", (String)"bottom_snow");
    public static final TagKey<Block> CONTAINABLES = CoreModule.blockTag((String)"snowrealmagic", (String)"containables");
    public static final TagKey<Block> NOT_CONTAINABLES = CoreModule.blockTag((String)"snowrealmagic", (String)"not_containables");
    public static final TagKey<Block> OFFSET_Y = CoreModule.blockTag((String)"snowrealmagic", (String)"offset_y");
    public static final TagKey<Block> CANNOT_ACCUMULATE_ON = CoreModule.blockTag((String)"snowrealmagic", (String)"cannot_accumulate_on");
    @KiwiModule.NoItem
    @KiwiModule.Name(value="snow")
    public static final KiwiGO<EntitySnowLayerBlock> TILE_BLOCK = CoreModule.go(() -> new EntitySnowLayerBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50125_).m_60988_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> FENCE = CoreModule.go(() -> new SnowFenceBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50132_).m_155949_(MaterialColor.f_76406_).m_60977_().m_60988_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> FENCE2 = CoreModule.go(() -> new SnowFenceBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50198_).m_155949_(MaterialColor.f_76406_).m_60977_().m_60988_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> STAIRS = CoreModule.go(() -> new SnowStairsBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50086_).m_155949_(MaterialColor.f_76406_).m_60977_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> SLAB = CoreModule.go(() -> new SnowSlabBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50398_).m_155949_(MaterialColor.f_76406_).m_60977_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> FENCE_GATE = CoreModule.go(() -> new SnowFenceGateBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50192_).m_155949_(MaterialColor.f_76406_).m_60977_().m_60988_()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> WALL = CoreModule.go(() -> new SnowWallBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50274_).m_155949_(MaterialColor.f_76406_).m_60977_().m_60988_()));
    @KiwiModule.Name(value="snow")
    public static final KiwiGO<BlockEntityType<SnowBlockEntity>> TILE = CoreModule.blockEntity(SnowBlockEntity::new, null, (Supplier[])new Supplier[]{TILE_BLOCK});
    public static final KiwiGO<BlockEntityType<SnowCoveredBlockEntity>> TEXTURE_TILE = CoreModule.blockEntity(SnowCoveredBlockEntity::new, null, (Supplier[])new Supplier[]{FENCE, FENCE2, STAIRS, SLAB, FENCE_GATE, WALL});
    @KiwiModule.Name(value="snow")
    public static final KiwiGO<EntityType<FallingSnowEntity>> ENTITY = CoreModule.go(() -> EntityType.Builder.m_20704_(FallingSnowEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory((spawnEntity, world) -> new FallingSnowEntity((Level)world)).m_20699_(0.98f, 0.001f).m_20712_("snowrealmagic.snow"));
    public static final KiwiGO<LootPoolEntryType> NORMAL = CoreModule.go(() -> new LootPoolEntryType((Serializer)new NormalLootEntry.Serializer()));
    public static final GameRules.Key<GameRules.IntegerValue> BLIZZARD_STRENGTH = GameRules.m_46189_((String)"snowrealmagic:blizzardStrength", (GameRules.Category)GameRules.Category.MISC, IntegerValueAccess.callCreate(0));
    public static final GameRules.Key<GameRules.IntegerValue> BLIZZARD_FREQUENCY = GameRules.m_46189_((String)"snowrealmagic:blizzardFrequency", (GameRules.Category)GameRules.Category.MISC, IntegerValueAccess.callCreate(10000));

    public CoreModule() {
        this.decorators.remove(ForgeRegistries.BLOCKS);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ENTITY.get(), FallingSnowRenderer::new);
    }

    protected void init(InitEvent event) {
        ModUtil.init();
        event.enqueueWork(() -> {
            BlockBehaviour.StateArgumentPredicate predicate = (blockState, blockGetter, blockPos, entityType) -> (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61417_) <= SnowCommonConfig.mobSpawningMaxLayers;
            ((BlockAccess)Blocks.f_50125_).getProperties().m_60922_(predicate);
            ((BlockAccess)TILE_BLOCK.get()).getProperties().m_60922_(predicate);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientInit(ClientInitEvent event) {
        Predicate<RenderType> blockRenderTypes = EnumUtil.BLOCK_RENDER_TYPES::contains;
        for (Supplier supplier : List.of(TILE_BLOCK, FENCE, FENCE2, FENCE_GATE, SLAB, STAIRS, WALL)) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)supplier.get()), blockRenderTypes);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerExtraModel(ModelEvent.RegisterAdditional event) {
        event.register(SnowClient.OVERLAY_MODEL);
    }

    protected void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        SnowBlockTagsProvider blockTagsProvider = new SnowBlockTagsProvider(generator.getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
    }
}

