/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.KiwiGO;
import snownee.snow.CoreModule;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.network.SSnowLandEffectPacket;

public final class Hooks {
    private Hooks() {
    }

    public static boolean canGrassSurvive(BlockState blockState, LevelReader viewableWorld, BlockPos blockPos) {
        BlockPos blockPos2 = blockPos.m_7494_();
        BlockState blockState2 = viewableWorld.m_8055_(blockPos2);
        if (blockState2.m_204336_(CoreModule.BOTTOM_SNOW)) {
            if (blockState2.m_60713_(Blocks.f_50125_)) {
                return SnowCommonConfig.sustainGrassIfLayerMoreThanOne || (Integer)blockState2.m_61143_((Property)SnowLayerBlock.f_56581_) == 1;
            }
            return true;
        }
        int i = LayerLightEngine.m_75667_((BlockGetter)viewableWorld, (BlockState)blockState, (BlockPos)blockPos, (BlockState)blockState2, (BlockPos)blockPos2, (Direction)Direction.UP, (int)blockState2.m_60739_((BlockGetter)viewableWorld, blockPos2));
        return i < viewableWorld.m_7469_();
    }

    public static boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel worldgenlevel = ctx.m_159774_();
        BlockPos blockpos = ctx.m_159777_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos belowPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                BlockState blockstate;
                int k = blockpos.m_123341_() + i;
                int l = blockpos.m_123343_() + j;
                int i1 = worldgenlevel.m_6924_(Heightmap.Types.MOTION_BLOCKING, k, l);
                pos.m_122178_(k, i1, l);
                belowPos.m_122190_((Vec3i)pos).m_122175_(Direction.DOWN, 1);
                Biome biome = (Biome)worldgenlevel.m_204166_((BlockPos)pos).m_203334_();
                if (biome.m_47480_((LevelReader)worldgenlevel, (BlockPos)belowPos, false)) {
                    worldgenlevel.m_7731_((BlockPos)belowPos, Blocks.f_50126_.m_49966_(), 2);
                }
                if (biome.m_47519_((LevelReader)worldgenlevel, (BlockPos)pos)) {
                    worldgenlevel.m_7731_((BlockPos)pos, Blocks.f_50125_.m_49966_(), 2);
                    blockstate = worldgenlevel.m_8055_((BlockPos)belowPos);
                    if (!blockstate.m_61138_((Property)SnowyDirtBlock.f_56637_)) continue;
                    worldgenlevel.m_7731_((BlockPos)belowPos, (BlockState)blockstate.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
                    continue;
                }
                if (!SnowCommonConfig.replaceWorldFeature || !SnowCommonConfig.placeSnowInBlockNaturally || !SnowCommonConfig.canPlaceSnowInBlock() || biome.m_198906_((BlockPos)pos) || worldgenlevel.m_45517_(LightLayer.BLOCK, (BlockPos)pos) >= 10 || !Blocks.f_50125_.m_49966_().m_60710_((LevelReader)worldgenlevel, (BlockPos)pos) || !Hooks.convert((LevelAccessor)worldgenlevel, (BlockPos)pos, blockstate = worldgenlevel.m_8055_((BlockPos)pos), 1, 2, true) || !(blockstate = worldgenlevel.m_8055_((BlockPos)belowPos)).m_61138_((Property)SnowyDirtBlock.f_56637_)) continue;
                worldgenlevel.m_7731_((BlockPos)belowPos, (BlockState)blockstate.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return true;
    }

    public static boolean canSnowSurvive(BlockState state, BlockGetter worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.m_8055_(pos.m_7495_());
        if (blockstate.m_204336_(BlockTags.f_215833_)) {
            return false;
        }
        if (blockstate.m_204336_(BlockTags.f_215834_)) {
            return true;
        }
        return Block.m_49918_((VoxelShape)blockstate.m_60812_(worldIn, pos.m_7495_()), (Direction)Direction.UP) || blockstate.m_60734_() instanceof SnowLayerBlock && (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_) == 8;
    }

    public static boolean canContainState(BlockState state) {
        if (!SnowCommonConfig.canPlaceSnowInBlock() || state.m_155947_() || !state.m_60819_().m_76178_()) {
            return false;
        }
        Block block = state.m_60734_();
        if (state.m_204336_(CoreModule.NOT_CONTAINABLES)) {
            return false;
        }
        if (state.m_204336_(CoreModule.CONTAINABLES) || block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof MushroomBlock || block instanceof SweetBerryBushBlock) {
            return true;
        }
        if (block instanceof FenceBlock && state.m_204336_(BlockTags.f_13039_)) {
            return Hooks.hasAllProperties(state, CoreModule.FENCE.defaultBlockState());
        }
        if (block instanceof FenceGateBlock && state.m_204336_(BlockTags.f_13055_)) {
            return Hooks.hasAllProperties(state, CoreModule.FENCE_GATE.defaultBlockState());
        }
        if (block instanceof WallBlock && state.m_204336_(BlockTags.f_13032_)) {
            return Hooks.hasAllProperties(state, CoreModule.WALL.defaultBlockState());
        }
        if (block instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM && state.m_204336_(BlockTags.f_13031_)) {
            return true;
        }
        if (block instanceof StairBlock && state.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM && state.m_204336_(BlockTags.f_13030_)) {
            return Hooks.hasAllProperties(state, CoreModule.STAIRS.defaultBlockState());
        }
        return false;
    }

    public static boolean convert(LevelAccessor world, BlockPos pos, BlockState state, int layers, int flags, boolean canConvert) {
        if (!SnowCommonConfig.canPlaceSnowInBlock() || state.m_155947_()) {
            return false;
        }
        if (state.m_60795_()) {
            world.m_7731_(pos, (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers)), flags);
            return true;
        }
        if (!canConvert) {
            return false;
        }
        Block block = state.m_60734_();
        if (state.m_204336_(CoreModule.CONTAINABLES) || block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof MushroomBlock || block instanceof SweetBerryBushBlock) {
            world.m_7731_(pos, (BlockState)CoreModule.TILE_BLOCK.defaultBlockState().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers)), flags);
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof SnowBlockEntity) {
                ((SnowBlockEntity)tile).setState(state);
            }
            return true;
        }
        BlockPos posDown = pos.m_7495_();
        BlockState stateDown = world.m_8055_(posDown);
        if (block instanceof StairBlock && !CoreModule.STAIRS.is(state) && state.m_204336_(BlockTags.f_13030_)) {
            newState = CoreModule.STAIRS.defaultBlockState();
            newState = Hooks.copyProperties(state, newState);
            world.m_7731_(pos, newState, flags);
        } else if (block instanceof SlabBlock && !CoreModule.SLAB.is(state) && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM && state.m_204336_(BlockTags.f_13031_)) {
            world.m_7731_(pos, CoreModule.SLAB.defaultBlockState(), flags);
        } else if (block instanceof FenceBlock && block.getClass() != SnowFenceBlock.class && state.m_204336_(BlockTags.f_13039_)) {
            KiwiGO<Block> newBlock = state.m_204336_(BlockTags.f_13098_) ? CoreModule.FENCE : CoreModule.FENCE2;
            BlockState newState = newBlock.defaultBlockState();
            newState = Hooks.copyProperties(state, newState);
            newState = newState.m_60728_(Direction.DOWN, stateDown, world, pos, posDown);
            world.m_7731_(pos, newState, flags);
        } else if (block instanceof FenceGateBlock && !CoreModule.FENCE_GATE.is(state) && state.m_204336_(BlockTags.f_13055_)) {
            newState = CoreModule.FENCE_GATE.defaultBlockState();
            newState = Hooks.copyProperties(state, newState);
            newState = newState.m_60728_(Direction.DOWN, stateDown, world, pos, posDown);
            world.m_7731_(pos, newState, flags);
        } else if (block instanceof WallBlock && !CoreModule.WALL.is(state) && state.m_204336_(BlockTags.f_13032_)) {
            newState = CoreModule.WALL.defaultBlockState();
            newState = Hooks.copyProperties(state, newState);
            newState = newState.m_60728_(Direction.DOWN, stateDown, world, pos, posDown);
            world.m_7731_(pos, newState, flags);
        } else {
            return false;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof SnowBlockEntity) {
            ((SnowBlockEntity)tile).setState(state);
        }
        return true;
    }

    private static <T extends Comparable<T>> boolean hasAllProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : newState.m_61148_().entrySet()) {
            Property property = (Property)entry.getKey();
            if (oldState.m_61138_(property)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> BlockState copyProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : oldState.m_61148_().entrySet()) {
            Property property = (Property)entry.getKey();
            if (!newState.m_61138_(property)) continue;
            newState = (BlockState)newState.m_61124_(property, (Comparable)property.m_61709_().cast(entry.getValue()));
        }
        return newState;
    }

    public static boolean placeLayersOn(Level world, BlockPos pos, int layers, boolean fallingEffect, BlockPlaceContext useContext, boolean playSound, boolean canConvert) {
        layers = Mth.m_14045_((int)layers, (int)1, (int)8);
        BlockState state = world.m_8055_(pos);
        int originLayers = 0;
        if (state.m_60734_() instanceof SnowLayerBlock) {
            originLayers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(Mth.m_14045_((int)(originLayers + layers), (int)1, (int)8))));
        } else if (canConvert && Hooks.canContainState(state) && state.m_60710_((LevelReader)world, pos)) {
            Hooks.convert((LevelAccessor)world, pos, state, Mth.m_14045_((int)layers, (int)1, (int)8), 3, canConvert);
        } else if (Hooks.canSnowSurvive(state, (BlockGetter)world, pos) && world.m_8055_(pos).m_60629_(useContext)) {
            world.m_46597_(pos, (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(Mth.m_14045_((int)layers, (int)1, (int)8))));
        } else {
            return false;
        }
        Block.m_49897_((BlockState)state, (BlockState)world.m_8055_(pos), (LevelAccessor)world, (BlockPos)pos);
        if (fallingEffect) {
            SSnowLandEffectPacket.send(world, pos, originLayers, layers);
        } else if (playSound) {
            SoundType soundtype = Blocks.f_50125_.m_49962_(Blocks.f_50125_.m_49966_());
            world.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        }
        if (originLayers + layers > 8) {
            pos = pos.m_7494_();
            if (Hooks.canSnowSurvive(Blocks.f_50125_.m_49966_(), (BlockGetter)world, pos) && world.m_8055_(pos).m_60629_(useContext)) {
                Hooks.placeLayersOn(world, pos, layers - (8 - originLayers), fallingEffect, useContext, playSound, canConvert);
            }
        }
        return true;
    }

    public static boolean canFallThrough(BlockState state, Level worldIn, BlockPos pos) {
        if (state.m_60812_((BlockGetter)worldIn, pos).m_83281_() && FallingBlock.m_53241_((BlockState)state) && state.m_60812_((BlockGetter)worldIn, pos).m_83281_()) {
            return true;
        }
        return state.m_60734_() instanceof SnowLayerBlock && (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) < 8;
    }

    public static void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockPos height;
        boolean melt;
        if (ModUtil.terraforged) {
            return;
        }
        if (random.m_188503_(8) > 0) {
            return;
        }
        Holder biome = worldIn.m_204166_(pos);
        int layers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
        boolean meltByTemperature = false;
        boolean meltByBrightness = false;
        if (!SnowCommonConfig.snowNeverMelt) {
            BlockState upState;
            if (layers == 8 && (upState = worldIn.m_8055_(pos.m_7494_())).m_60734_() instanceof SnowLayerBlock) {
                return;
            }
            meltByTemperature = ModUtil.shouldMelt((Level)worldIn, pos, (Holder<Biome>)biome, layers);
            meltByBrightness = worldIn.m_45517_(LightLayer.BLOCK, pos) > 11;
        }
        boolean bl = melt = meltByTemperature || meltByBrightness;
        if (!melt) {
            if (!SnowCommonConfig.snowAccumulationDuringSnowfall && !SnowCommonConfig.snowAccumulationDuringSnowstorm) {
                return;
            }
            if (SnowCommonConfig.accumulationWinterOnly && !ModUtil.isWinter((Level)worldIn, pos, (Holder<Biome>)biome)) {
                return;
            }
        }
        if (!meltByBrightness && (height = worldIn.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos)).m_123342_() > pos.m_123342_()) {
            return;
        }
        boolean accumulate = false;
        if (!meltByBrightness && worldIn.m_46471_() && ModUtil.coldEnoughToSnow((Level)worldIn, pos, (Holder<Biome>)biome)) {
            if (SnowCommonConfig.snowAccumulationDuringSnowfall) {
                accumulate = true;
            } else if (SnowCommonConfig.snowAccumulationDuringSnowstorm && worldIn.m_46470_()) {
                accumulate = true;
            }
        }
        if (accumulate) {
            if (layers < SnowCommonConfig.snowAccumulationMaxLayers) {
                Hooks.accumulate((Level)worldIn, pos, state, (w, p) -> (SnowCommonConfig.snowAccumulationMaxLayers > 8 || !(w.m_8055_(p.m_7495_()).m_60734_() instanceof SnowLayerBlock)) && w.m_45517_(LightLayer.BLOCK, p) <= 10, true);
            }
        } else if (melt) {
            if (layers == 1) {
                SnowVariant snow = (SnowVariant)state.m_60734_();
                worldIn.m_46597_(pos, snow.getRaw(state, (BlockGetter)worldIn, pos));
            } else {
                Hooks.accumulate((Level)worldIn, pos, state, (w, p) -> !(w.m_8055_(p.m_7494_()).m_60734_() instanceof SnowLayerBlock), false);
            }
        }
    }

    private static void accumulate(Level world, BlockPos pos, BlockState centerState, BiPredicate<LevelAccessor, BlockPos> filter, boolean accumulate) {
        int i = (Integer)centerState.m_61143_((Property)SnowLayerBlock.f_56581_);
        for (int j = 0; j < 8; ++j) {
            int l;
            int k = j / 2;
            Direction direction = Direction.m_122407_((int)k);
            BlockPos pos2 = pos.m_121945_(direction);
            if (j % 2 == 1) {
                pos2 = pos2.m_121945_(Direction.m_122407_((int)(k + 1)));
            }
            if (!world.m_46749_(pos2) || !filter.test((LevelAccessor)world, pos2)) continue;
            BlockState state = world.m_8055_(pos2);
            BlockPos height = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos2);
            if (height.m_123342_() != pos2.m_123342_() || !Hooks.canSnowSurvive(state, (BlockGetter)world, pos2)) continue;
            if (state.m_60734_() instanceof SnowLayerBlock) {
                l = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
                if (accumulate && state.m_204336_(CoreModule.CANNOT_ACCUMULATE_ON)) {
                    continue;
                }
            } else {
                l = 0;
            }
            if (!(accumulate ? i > l : i < l)) continue;
            if (accumulate) {
                Hooks.placeLayersOn(world, pos2, 1, false, (BlockPlaceContext)new DirectionalPlaceContext(world, pos2, Direction.UP, ItemStack.f_41583_, Direction.DOWN), false, SnowCommonConfig.placeSnowInBlockNaturally);
            } else {
                world.m_46597_(pos2, (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(l - 1)));
            }
            return;
        }
        if (accumulate) {
            Hooks.placeLayersOn(world, pos, 1, false, (BlockPlaceContext)new DirectionalPlaceContext(world, pos, Direction.UP, ItemStack.f_41583_, Direction.DOWN), false, SnowCommonConfig.placeSnowInBlockNaturally);
        } else {
            world.m_46597_(pos, (BlockState)centerState.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(i - 1)));
        }
    }
}

