/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.compat.sodium;

import java.util.List;
import java.util.function.Supplier;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import snownee.snow.client.RenderAPI;
import snownee.snow.mixin.sodium.BlockRendererAccess;

public class RubidiumRenderAPI
implements RenderAPI {
    private final BlockRendererAccess blockRenderer;
    private final ModelData modelData;
    private final long seed;
    private final LightPipelineProvider lighters;
    private final BlockOcclusionCache occlusionCache;
    private final BlockPos origin;
    private final ChunkModelBuilder buffers;

    public RubidiumRenderAPI(BlockRendererAccess blockRenderer, ModelData modelData, long seed, LightPipelineProvider lighters, BlockOcclusionCache occlusionCache, BlockPos origin, ChunkModelBuilder buffers) {
        this.blockRenderer = blockRenderer;
        this.modelData = modelData;
        this.seed = seed;
        this.lighters = lighters;
        this.occlusionCache = occlusionCache;
        this.origin = origin;
        this.buffers = buffers;
    }

    @Override
    public boolean translateYAndRender(BlockAndTintGetter world, BlockState state, BlockPos pos, @Nullable RenderType layer, Supplier<RandomSource> randomSupplier, boolean cullSides, BakedModel model, double yOffset) {
        RandomSource random = randomSupplier.get();
        if (layer != null && !model.getRenderTypes(state, random, this.modelData).contains(layer)) {
            return false;
        }
        Vec3 offset = state.m_60824_((BlockGetter)world, pos);
        if (yOffset != 0.0) {
            offset = offset.m_82520_(0.0, yOffset, 0.0);
            cullSides = false;
        }
        LightPipeline lighter = this.lighters.getLighter(this.blockRenderer.callGetLightingMode(state, model));
        boolean rendered = false;
        for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
            random.m_188584_(this.seed);
            List sided = model.getQuads(state, dir, random, this.modelData, layer);
            if (sided.isEmpty() || cullSides && !this.occlusionCache.shouldDrawSide(state, (BlockGetter)world, pos, dir)) continue;
            this.blockRenderer.callRenderQuadList(world, state, pos, this.origin, lighter, offset, this.buffers, sided, dir);
            rendered = true;
        }
        random.m_188584_(this.seed);
        List all = model.getQuads(state, null, random, this.modelData, layer);
        if (!all.isEmpty()) {
            this.blockRenderer.callRenderQuadList(world, state, pos, this.origin, lighter, offset, this.buffers, all, null);
            rendered = true;
        }
        return rendered;
    }
}

