/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import snownee.snow.CoreModule;
import snownee.snow.Hooks;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.entity.FallingSnowEntity;

@Mixin(value={SnowLayerBlock.class})
public class SnowLayerBlockMixin
extends Block
implements SnowVariant {
    private static final VoxelShape[] SNOW_SHAPES_MAGIC = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.001, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0)};
    @Shadow
    private static VoxelShape[] f_56582_;

    public SnowLayerBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Overwrite
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (ModUtil.terraforged || !SnowCommonConfig.thinnerBoundingBox) {
            return f_56582_[(Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) - 1];
        }
        int layers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
        if (layers == 8) {
            return Shapes.m_83144_();
        }
        return SNOW_SHAPES_MAGIC[layers - 1];
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (SnowCommonConfig.snowGravity) {
            worldIn.m_186460_(pos, (Block)this, this.tickRate());
        }
    }

    @Overwrite
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (SnowCommonConfig.snowGravity) {
            worldIn.m_186460_(currentPos, (Block)this, this.tickRate());
            return stateIn;
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Overwrite
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return Hooks.canSnowSurvive(state, (BlockGetter)worldIn, pos);
    }

    protected int tickRate() {
        return 2;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        this.checkFallable((Level)worldIn, pos, state);
    }

    @Overwrite
    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        Hooks.randomTick(state, worldIn, pos, random);
    }

    protected boolean checkFallable(Level worldIn, BlockPos pos, BlockState state) {
        BlockPos posDown = pos.m_7495_();
        if (Hooks.canFallThrough(worldIn.m_8055_(posDown), worldIn, posDown)) {
            if (!worldIn.f_46443_) {
                worldIn.m_46597_(pos, this.getRaw(state, (BlockGetter)worldIn, pos));
                FallingSnowEntity entity = new FallingSnowEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() + 0.5, (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_));
                worldIn.m_7967_((Entity)entity);
            }
            return true;
        }
        return false;
    }

    @Overwrite
    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        int i = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
        if (useContext.m_43722_().m_150930_(Blocks.f_50125_.m_5456_()) && i < 8) {
            if (useContext.m_7058_() && state.m_60713_(Blocks.f_50125_)) {
                return useContext.m_43719_() == Direction.UP;
            }
            return true;
        }
        return SnowCommonConfig.snowAlwaysReplaceable && (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) < 8 || i == 1;
    }

    @Override
    public BlockState onShovel(BlockState state, Level world, BlockPos pos) {
        int layers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) - 1;
        if (layers > 0) {
            return (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers));
        }
        return this.getRaw(state, (BlockGetter)world, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockState state2;
        BlockPlaceContext context;
        Block block;
        BlockState stateDown;
        if (player.m_21205_().m_41619_() && player.m_21206_().m_41619_() && !((stateDown = worldIn.m_8055_(pos.m_7495_())).m_60734_() instanceof SnowLayerBlock) && !stateDown.m_61138_((Property)BlockStateProperties.f_61451_)) {
            BlockEntity blockEntity;
            if (state.m_60713_(Blocks.f_50125_)) {
                worldIn.m_7731_(pos, Hooks.copyProperties(state, CoreModule.TILE_BLOCK.defaultBlockState()), 48);
            }
            if ((blockEntity = worldIn.m_7702_(pos)) instanceof SnowBlockEntity) {
                SnowBlockEntity snowTile = (SnowBlockEntity)blockEntity;
                if (CoreModule.TILE_BLOCK.is(state) && snowTile.getState().m_60795_()) {
                    worldIn.m_7731_(pos, Hooks.copyProperties(state, Blocks.f_50125_.m_49966_()), 48);
                } else {
                    boolean bl = snowTile.options.renderOverlay = !snowTile.options.renderOverlay;
                    if (worldIn.f_46443_) {
                        worldIn.m_7260_(pos, state, state, 11);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (state.m_60713_(Blocks.f_50125_) && (block = Block.m_49814_((Item)(context = new BlockPlaceContext(player, handIn, player.m_21120_(handIn), hit)).m_43722_().m_41720_())) != null && block != Blocks.f_50016_ && context.m_7058_() && (state2 = block.m_5573_(context)) != null && Hooks.canContainState(state2) && state2.m_60710_((LevelReader)worldIn, pos)) {
            if (!worldIn.f_46443_) {
                worldIn.m_7731_(pos, state2, 48);
                block.m_6402_(worldIn, pos, state, (LivingEntity)player, context.m_43722_());
                int i = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
                if (Hooks.placeLayersOn(worldIn, pos, i, false, context, true, true) && !player.m_7500_()) {
                    context.m_43722_().m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    @Overwrite
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60734_() instanceof SnowLayerBlock) {
            int i = (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_);
            return (BlockState)blockstate.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        ItemStack stack = context.m_43722_();
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag != null && "snowrealmagic:snow".equals(tag.m_128461_("id"))) {
            return CoreModule.TILE_BLOCK.defaultBlockState();
        }
        return this.m_49966_();
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (SnowCommonConfig.snowReduceFallDamage) {
            if (!state.m_60713_((Block)this)) {
                return;
            }
            if (state.m_60713_(Blocks.f_50125_) || CoreModule.TILE_BLOCK.is(state)) {
                entityIn.m_142535_(fallDistance, 0.2f, DamageSource.f_19315_);
                return;
            }
            state = worldIn.m_8055_(pos);
            entityIn.m_142535_(fallDistance, 1.0f - (float)((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_)).intValue() * 0.1f, DamageSource.f_19315_);
            return;
        }
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance);
    }

    public void m_141947_(Level worldIn, BlockPos pos, BlockState state, Entity entityIn) {
        double d0;
        if (!SnowCommonConfig.thinnerBoundingBox || !state.m_60713_((Block)this)) {
            return;
        }
        int layers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) - 2;
        if (layers > 0 && (d0 = Math.abs(entityIn.m_20184_().f_82480_)) < 0.1 && !entityIn.m_20161_()) {
            double d1 = 1.0f - (float)layers * 0.05f;
            entityIn.m_20256_(entityIn.m_20184_().m_82542_(d1, 1.0, d1));
        }
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = this.getRaw(state, world, pos).getCloneItemStack(target, world, pos, player);
        return stack.m_41619_() ? new ItemStack((ItemLike)Items.f_41979_) : stack;
    }

    @Override
    public int layers(BlockState state, BlockGetter world, BlockPos pos) {
        return (Integer)state.m_61143_((Property)BlockStateProperties.f_61417_);
    }
}

