/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import me.shedaniel.clothconfig2.impl.builders.TextDescriptionBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModList;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.ConfigUI;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.util.LocalizableItem;
import snownee.kiwi.util.Util;

public class ClothConfigIntegration {
    private static final Component requiresRestart = Component.m_237115_((String)"kiwi.config.requiresRestart").m_130940_(ChatFormatting.RED);

    public static Screen create(Screen parent, String namespace) {
        ConfigBuilder builder = ConfigBuilder.create();
        builder.setParentScreen(parent);
        List<ConfigHandler> configs = KiwiConfigManager.allConfigs.stream().filter($ -> $.getModId().equals(namespace)).toList();
        Joiner joiner = Joiner.on((char)'.');
        for (ConfigHandler config : configs) {
            String titleKey = config.getFileName().equals(config.getModId() + "-" + config.getType().extension()) ? config.getType().extension() : (config.getFileName().equals(config.getModId() + "-modules") ? "modules" : config.getFileName());
            MutableComponent title = I18n.m_118936_((String)("kiwi.config." + titleKey)) ? Component.m_237115_((String)("kiwi.config." + titleKey)) : Component.m_237113_((String)Util.friendlyText(titleKey));
            ConfigCategory category = builder.getOrCreateCategory((Component)title);
            HashMap subCatsMap = Maps.newHashMap();
            ArrayList subCats = Lists.newArrayList();
            subCatsMap.put("", arg_0 -> ((ConfigCategory)category).addEntry(arg_0));
            for (ConfigHandler.Value<?> value : config.valueMap.values()) {
                ConfigUI.ItemType itemType;
                ConfigUI.Hide hide = value.getAnnotation(ConfigUI.Hide.class);
                if (hide != null) continue;
                ArrayList path = Lists.newArrayList((Object[])value.path.split("\\."));
                String key = config.getModId() + ".config." + value.translation;
                title = I18n.m_118936_((String)key) ? Component.m_237115_((String)key) : Component.m_237113_((String)Util.friendlyText((String)path.get(path.size() - 1)));
                ConfigEntryBuilder entryBuilder = builder.entryBuilder();
                path.remove(path.size() - 1);
                String subCatKey = joiner.join((Iterable)path);
                Consumer subCat = subCatsMap.computeIfAbsent(subCatKey, $ -> {
                    String key0 = config.getModId() + ".config." + $;
                    MutableComponent title0 = I18n.m_118936_((String)key0) ? Component.m_237115_((String)key0) : Component.m_237113_((String)Util.friendlyText((String)path.get(path.size() - 1)));
                    SubCategoryBuilder builder0 = entryBuilder.startSubCategory((Component)title0);
                    builder0.setExpanded(true);
                    subCats.add(builder0);
                    return arg_0 -> ((SubCategoryBuilder)builder0).add(arg_0);
                });
                ConfigUI.TextDescription description = value.field == null ? null : value.field.getAnnotation(ConfigUI.TextDescription.class);
                ClothConfigIntegration.putDescription(subCat, entryBuilder, description, false);
                BooleanListEntry entry = null;
                Class<?> type = value.getType();
                if (type == Boolean.TYPE) {
                    BooleanToggleBuilder toggle = entryBuilder.startBooleanToggle((Component)title, ((Boolean)value.value).booleanValue());
                    toggle.setTooltip(ClothConfigIntegration.createComment(value));
                    toggle.setSaveConsumer($ -> value.accept($, config.onChanged));
                    toggle.setDefaultValue((Object)((Boolean)value.defValue));
                    entry = toggle.build();
                } else if (type == Integer.TYPE) {
                    ConfigUI.Color color = value.getAnnotation(ConfigUI.Color.class);
                    if (color != null) {
                        field = entryBuilder.startAlphaColorField((Component)title, ((Integer)value.value).intValue());
                        field.setAlphaMode(color.alpha());
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        field.setDefaultValue((Object)((Integer)value.defValue));
                        entry = field.build();
                    } else if (value.getAnnotation(ConfigUI.Slider.class) != null) {
                        field = entryBuilder.startIntSlider((Component)title, ((Integer)value.value).intValue(), (int)value.min, (int)value.max);
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        field.setDefaultValue((Object)((Integer)value.defValue));
                        entry = field.build();
                    } else {
                        field = entryBuilder.startIntField((Component)title, ((Integer)value.value).intValue());
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        if (!Double.isNaN(value.min)) {
                            field.setMin((int)value.min);
                        }
                        if (!Double.isNaN(value.max)) {
                            field.setMax((int)value.max);
                        }
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        field.setDefaultValue((Object)((Integer)value.defValue));
                        entry = field.build();
                    }
                } else if (type == Double.TYPE) {
                    field = entryBuilder.startDoubleField((Component)title, ((Double)value.value).doubleValue());
                    field.setTooltip(ClothConfigIntegration.createComment(value));
                    if (!Double.isNaN(value.min)) {
                        field.setMin(value.min);
                    }
                    if (!Double.isNaN(value.max)) {
                        field.setMax(value.max);
                    }
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    field.setDefaultValue((Object)((Double)value.defValue));
                    entry = field.build();
                } else if (type == Float.TYPE) {
                    field = entryBuilder.startFloatField((Component)title, ((Float)value.value).floatValue());
                    field.setTooltip(ClothConfigIntegration.createComment(value));
                    if (!Double.isNaN(value.min)) {
                        field.setMin((float)value.min);
                    }
                    if (!Double.isNaN(value.max)) {
                        field.setMax((float)value.max);
                    }
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    field.setDefaultValue((Object)((Float)value.defValue));
                    entry = field.build();
                } else if (type == Long.TYPE) {
                    if (value.getAnnotation(ConfigUI.Slider.class) != null) {
                        field = entryBuilder.startLongSlider((Component)title, ((Long)value.value).longValue(), (long)value.min, (long)value.max);
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        field.setDefaultValue((Object)((Long)value.defValue));
                        entry = field.build();
                    } else {
                        field = entryBuilder.startLongField((Component)title, ((Long)value.value).longValue());
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        if (!Double.isNaN(value.min)) {
                            field.setMin((long)value.min);
                        }
                        if (!Double.isNaN(value.max)) {
                            field.setMax((long)value.max);
                        }
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        field.setDefaultValue((Object)((Long)value.defValue));
                        entry = field.build();
                    }
                } else if (type == String.class) {
                    field = entryBuilder.startTextField((Component)title, (String)value.value);
                    field.setTooltip(ClothConfigIntegration.createComment(value));
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    field.setDefaultValue((String)value.defValue);
                    entry = field.build();
                } else if (Enum.class.isAssignableFrom(type)) {
                    field = entryBuilder.startEnumSelector((Component)title, type, (Enum)value.value);
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    field.setDefaultValue((Enum)value.defValue);
                    field.setEnumNameProvider($ -> {
                        if ($ instanceof LocalizableItem) {
                            LocalizableItem item = (LocalizableItem)((Object)$);
                            return item.getDisplayName().m_6881_();
                        }
                        return Component.m_237113_((String)$.name());
                    });
                    field.setTooltipSupplier($ -> {
                        ArrayList tooltip = Lists.newArrayList();
                        if ($ instanceof LocalizableItem) {
                            LocalizableItem item = (LocalizableItem)((Object)$);
                            tooltip.add(item.getDisplayName().m_6881_().m_130946_(" - ").m_7220_(item.getDescription()));
                        }
                        ClothConfigIntegration.createComment(value).map(Arrays::asList).ifPresent(tooltip::addAll);
                        return tooltip.isEmpty() ? Optional.empty() : Optional.of((Component[])tooltip.toArray(Component[]::new));
                    });
                    entry = field.build();
                } else if (List.class.isAssignableFrom(type) && (itemType = value.field.getAnnotation(ConfigUI.ItemType.class)).value() == String.class) {
                    field = entryBuilder.startStrList((Component)title, (List)value.value);
                    field.setTooltip(ClothConfigIntegration.createComment(value));
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    field.setDefaultValue((List)value.defValue);
                    entry = field.build();
                }
                if (entry != null) {
                    entry.setRequiresRestart(value.requiresRestart);
                    subCat.accept(entry);
                }
                ClothConfigIntegration.putDescription(subCat, entryBuilder, description, true);
            }
            subCats.forEach($ -> category.addEntry((AbstractConfigListEntry)$.build()));
        }
        builder.setSavingRunnable(() -> configs.forEach(ConfigHandler::save));
        return builder.build();
    }

    private static void putDescription(Consumer<AbstractConfigListEntry<?>> subCat, ConfigEntryBuilder entryBuilder, ConfigUI.TextDescription description, boolean after) {
        if (description == null || description.after() != after) {
            return;
        }
        MutableComponent component = I18n.m_118936_((String)description.value()) ? Component.m_237115_((String)description.value()) : Component.m_237113_((String)description.value());
        TextDescriptionBuilder builder = entryBuilder.startTextDescription((Component)component);
        subCat.accept((AbstractConfigListEntry<?>)builder.build());
    }

    private static Optional<Component[]> createComment(ConfigHandler.Value<?> value) {
        ArrayList tooltip = Lists.newArrayList();
        if (value.comment != null) {
            for (String comment : value.comment) {
                tooltip.add(Component.m_237113_((String)comment));
            }
        }
        if (value.requiresRestart) {
            tooltip.add(requiresRestart);
        }
        return tooltip.isEmpty() ? Optional.empty() : Optional.of((Component[])tooltip.toArray(Component[]::new));
    }

    static void init() {
        List<String> mods = KiwiConfigManager.allConfigs.stream().map(ConfigHandler::getModId).distinct().toList();
        for (String mod : mods) {
            ModList.get().getModContainerById(mod).ifPresent($ -> $.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> ClothConfigIntegration.create(screen, mod))));
        }
    }
}

