/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen.provider;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import snownee.kiwi.Kiwi;
import snownee.kiwi.mixin.BlockAccess;

public abstract class KiwiBlockTagsProvider
extends BlockTagsProvider {
    public KiwiBlockTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, ExistingFileHelper existingFileHelper) {
        super(packOutput, lookupProvider, modId, existingFileHelper);
    }

    public void processTools(Block block) {
        this.processTools(block, true);
    }

    public void processTools(Block block, boolean addParentInstead) {
        if (block instanceof BannerBlock) {
            this.m_206424_(BlockTags.f_13028_).m_255245_((Object)block);
            return;
        }
        Material material = ((BlockAccess)block).getMaterial();
        if (material == Material.f_76274_) {
            this.m_206424_(BlockTags.f_144281_).m_255245_((Object)block);
        } else if (material == Material.f_76320_ || material == Material.f_76321_) {
            if (addParentInstead) {
                if (block instanceof WallSignBlock) {
                    this.m_206424_(BlockTags.f_13067_).m_255245_((Object)block);
                    return;
                }
                if (block instanceof StandingSignBlock) {
                    this.m_206424_(BlockTags.f_13066_).m_255245_((Object)block);
                    return;
                }
                if (block instanceof ButtonBlock) {
                    this.m_206424_(BlockTags.f_13092_).m_255245_((Object)block);
                    return;
                }
                if (block instanceof DoorBlock) {
                    this.m_206424_(BlockTags.f_13095_).m_255245_((Object)block);
                    return;
                }
                if (block instanceof FenceBlock) {
                    this.m_206424_(BlockTags.f_13098_).m_255245_((Object)block);
                    return;
                }
                if (block instanceof StairBlock) {
                    this.m_206424_(BlockTags.f_13096_).m_255245_((Object)block);
                    return;
                }
                if (block instanceof SlabBlock) {
                    this.m_206424_(BlockTags.f_13097_).m_255245_((Object)block);
                    return;
                }
                if (block instanceof PressurePlateBlock) {
                    this.m_206424_(BlockTags.f_13100_).m_255245_((Object)block);
                    return;
                }
                if (block instanceof TrapDoorBlock) {
                    this.m_206424_(BlockTags.f_13102_).m_255245_((Object)block);
                    return;
                }
            }
            this.m_206424_(BlockTags.f_144280_).m_255245_((Object)block);
        } else if (material == Material.f_76300_ || material == Material.f_76302_ || material == Material.f_76285_) {
            if (addParentInstead && block instanceof SaplingBlock) {
                this.m_206424_(BlockTags.f_13104_).m_255245_((Object)block);
                return;
            }
            this.m_206424_(BlockTags.f_144280_).m_255245_((Object)block);
        } else if (material == Material.f_76278_ || material == Material.f_76279_ || material == Material.f_76281_) {
            if (addParentInstead) {
                if (block instanceof WallBlock) {
                    this.m_206424_(BlockTags.f_13032_).m_255245_((Object)block);
                    return;
                }
                if (block instanceof BaseRailBlock) {
                    this.m_206424_(BlockTags.f_144282_).m_255245_((Object)block);
                    return;
                }
            }
            this.m_206424_(BlockTags.f_144282_).m_255245_((Object)block);
        } else if (material == Material.f_76317_ || material == Material.f_76313_ || material == Material.f_76314_ || material == Material.f_76280_) {
            this.m_206424_(BlockTags.f_144283_).m_255245_((Object)block);
        } else {
            Kiwi.logger.info("Unhandled block: {}", (Object)block);
        }
    }

    public TagsProvider.TagAppender<Block> tag(String name) {
        return this.m_206424_(BlockTags.create((ResourceLocation)new ResourceLocation(this.modId, name)));
    }
}

