/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.GroupSetting;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.ModContext;
import snownee.kiwi.NamedEntry;
import snownee.kiwi.block.IKiwiBlock;
import snownee.kiwi.item.ItemCategoryFiller;
import snownee.kiwi.item.ModBlockItem;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.ClientInitEvent;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.loader.event.ServerInitEvent;

public class ModuleInfo {
    public final AbstractModule module;
    public final ModContext context;
    public GroupSetting groupSetting;
    final RegistryHolder registries = new RegistryHolder();
    final Map<class_2248, class_1792.class_1793> blockItemBuilders = Maps.newHashMap();
    final Set<Object> noCategories = Sets.newHashSet();
    final Set<class_2248> noItems = Sets.newHashSet();

    public ModuleInfo(class_2960 rl, AbstractModule module, ModContext context) {
        this.module = module;
        this.context = context;
        module.uid = rl;
    }

    public void register(Object object, class_2960 name, class_2378<?> registry, @Nullable Field field) {
        KiwiModule.Category group;
        NamedEntry<Object> entry = new NamedEntry<Object>(name, object, registry, field);
        this.registries.put(entry);
        if (field != null && (group = field.getAnnotation(KiwiModule.Category.class)) != null) {
            entry.groupSetting = GroupSetting.of(group, this.groupSetting);
        }
    }

    public <T> void handleRegister(Object registry) {
        this.context.setActiveContainer();
        Collection<NamedEntry<NamedEntry>> entries = this.registries.get((class_2378)registry);
        BiConsumer<ModuleInfo, Object> decorator = this.module.decorators.getOrDefault(registry, (a, b) -> {});
        if (registry == class_7923.field_41178) {
            this.registries.get(class_7923.field_41175).forEach(e -> {
                if (this.noItems.contains(e.entry)) {
                    return;
                }
                class_1792.class_1793 builder = this.blockItemBuilders.get(e.entry);
                if (builder == null) {
                    builder = new class_1792.class_1793();
                }
                Object item = e.entry instanceof IKiwiBlock ? ((IKiwiBlock)e.entry).createItem(builder) : new ModBlockItem((class_2248)e.entry, builder);
                if (this.noCategories.contains(e.entry)) {
                    this.noCategories.add(item);
                }
                NamedEntry<class_1747> itemEntry = new NamedEntry<class_1747>(e.name, (class_1747)item, (class_2378<class_1747>)((class_2378)registry), null);
                itemEntry.groupSetting = e.groupSetting;
                entries.add(itemEntry);
            });
            entries.forEach(e -> {
                if (!this.noCategories.contains(e.entry)) {
                    ItemCategoryFiller filler = e.entry instanceof ItemCategoryFiller ? (ItemCategoryFiller)e.entry : (tab, flags, hasPermissions, items) -> items.add(new class_1799((class_1935)((class_1792)e.entry)));
                    if (e.groupSetting != null) {
                        e.groupSetting.apply(filler);
                    } else if (this.groupSetting != null) {
                        this.groupSetting.apply(filler);
                    }
                }
            });
        }
        entries.forEach(e -> {
            decorator.accept(this, e.entry);
            class_2378.method_10230(e.registry, (class_2960)e.name, e.entry);
        });
        if (registry == class_7923.field_41175 && Platform.isPhysicalClient() && !Platform.isDataGen()) {
            class_1921 solid = class_1921.method_23577();
            HashMap cache = Maps.newHashMap();
            entries.stream().forEach(e -> {
                class_1921 type;
                KiwiModule.RenderLayer layer;
                class_2248 block = (class_2248)e.entry;
                if (e.field != null && (layer = e.field.getAnnotation(KiwiModule.RenderLayer.class)) != null && (type = (class_1921)layer.value().value) != solid && type != null) {
                    BlockRenderLayerMap.INSTANCE.putBlock(block, type);
                    return;
                }
                Class<?> klass = block.getClass();
                type = cache.computeIfAbsent(klass, k -> {
                    KiwiModule.RenderLayer layer = null;
                    while (k != class_2248.class) {
                        layer = k.getDeclaredAnnotation(KiwiModule.RenderLayer.class);
                        if (layer != null) {
                            return (class_1921)layer.value().value;
                        }
                        k = k.getSuperclass();
                    }
                    return solid;
                });
                if (type != solid && type != null) {
                    BlockRenderLayerMap.INSTANCE.putBlock(block, type);
                }
            });
        }
    }

    public void preInit() {
        KiwiModules.ALL_USED_REGISTRIES.addAll(this.registries.registries.keySet());
        this.context.setActiveContainer();
        this.module.preInit();
        KiwiModules.ALL_USED_REGISTRIES.forEach(this::handleRegister);
    }

    public void init(InitEvent event) {
        this.context.setActiveContainer();
        this.module.init(event);
    }

    public void clientInit(ClientInitEvent event) {
        this.context.setActiveContainer();
        this.module.clientInit(event);
    }

    public void serverInit(ServerInitEvent event) {
        this.context.setActiveContainer();
        this.module.serverInit(event);
    }

    public void postInit(PostInitEvent event) {
        this.context.setActiveContainer();
        this.module.postInit(event);
    }

    public <T> List<T> getRegistries(class_2378<T> registry) {
        return this.registries.get(registry).stream().map($ -> $.entry).toList();
    }

    public static final class RegistryHolder {
        final Multimap<class_2378<?>, NamedEntry<?>> registries = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().linkedListValues().build();

        <T> void put(NamedEntry<T> entry) {
            this.registries.put(entry.registry, entry);
        }

        <T> Collection<NamedEntry<T>> get(class_2378<T> registry) {
            return this.registries.get(registry);
        }
    }
}

