/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.mixin.ShapedRecipeAccess;

public abstract class DynamicShapedRecipe
extends class_1852 {
    private int width;
    private int height;
    private class_2371<class_1856> recipeItems;
    public String pattern;
    public boolean differentInputs;
    public class_1799 recipeOutput;
    private String group;

    public DynamicShapedRecipe(class_2960 idIn, class_7710 category) {
        super(idIn, category);
    }

    public boolean matches(class_1715 inv, class_1937 worldIn) {
        return this.search(inv) != null;
    }

    @Nullable
    public int[] search(class_1715 inv) {
        for (int x = 0; x <= inv.method_17398() - this.getRecipeWidth(); ++x) {
            for (int y = 0; y <= inv.method_17397() - this.getRecipeHeight(); ++y) {
                if (!this.checkMatch(inv, x, y) || !this.checkEmpty(inv, x, y)) continue;
                return new int[]{x, y};
            }
        }
        return null;
    }

    public class_1799 item(char key, class_1715 inv, int[] matchPos) {
        int i = this.pattern.indexOf(key);
        if (i != -1) {
            int x = matchPos[0] + i % this.width;
            int y = matchPos[1] + i / this.width;
            return inv.method_5438(x + y * inv.method_17398());
        }
        return class_1799.field_8037;
    }

    public List<class_1799> items(char key, class_1715 inv, int[] matchPos) {
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < this.pattern.length(); ++i) {
            if (key != this.pattern.charAt(i)) continue;
            int x = matchPos[0] + i % this.width;
            int y = matchPos[1] + i / this.width;
            items.add(inv.method_5438(x + y * inv.method_17398()));
        }
        return items;
    }

    public abstract class_1799 assemble(class_1715 var1, class_5455 var2);

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }

    public boolean method_8113(int width, int height) {
        return width >= this.getRecipeWidth() && height >= this.getRecipeHeight();
    }

    public String method_8112() {
        return this.group;
    }

    public class_2371<class_1856> method_8117() {
        return this.recipeItems;
    }

    public abstract class_1865<?> method_8119();

    protected boolean checkMatch(class_1715 inv, int startX, int startY) {
        Char2ObjectArrayMap ingredientsArrayMap = null;
        if (!this.differentInputs) {
            ingredientsArrayMap = new Char2ObjectArrayMap();
        }
        for (int y = startY; y < startY + this.getRecipeHeight(); ++y) {
            for (int x = startX; x < startX + this.getRecipeWidth(); ++x) {
                int i;
                char key;
                int rx = x - startX;
                int ry = y - startY;
                if (!this.matches(inv, x, y, rx, ry)) {
                    return false;
                }
                if (this.differentInputs || (key = this.pattern.charAt(i = rx + ry * this.getRecipeWidth())) == ' ') continue;
                class_1799 stack0 = inv.method_5438(x + y * inv.method_17398());
                class_1799 stack1 = (class_1799)ingredientsArrayMap.get(key);
                if (stack1 == null) {
                    ingredientsArrayMap.put(key, (Object)stack0);
                    continue;
                }
                if (class_1799.method_31577((class_1799)stack1, (class_1799)stack0)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matches(class_1715 inv, int x, int y, int rx, int ry) {
        class_1856 ingredient = (class_1856)this.recipeItems.get(rx + ry * this.getRecipeWidth());
        return ingredient.method_8093(inv.method_5438(x + y * inv.method_17398()));
    }

    protected boolean checkEmpty(class_1715 inv, int startX, int startY) {
        for (int y = 0; y < inv.method_17397(); ++y) {
            int subY = y - startY;
            for (int x = 0; x < inv.method_17398(); ++x) {
                int subX = x - startX;
                if (subX >= 0 && subY >= 0 && subX < this.getRecipeWidth() && subY < this.getRecipeHeight() || this.getEmpty().test(inv.method_5438(x + y * inv.method_17398()))) continue;
                return false;
            }
        }
        return true;
    }

    protected Predicate<class_1799> getEmpty() {
        return class_1856.field_9017;
    }

    public static abstract class Serializer<T extends DynamicShapedRecipe>
    implements class_1865<T> {
        public static void fromJson(DynamicShapedRecipe recipe, JsonObject json) {
            recipe.group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            Map<String, class_1856> ingredientMap = ShapedRecipeAccess.callKeyFromJson(class_3518.method_15296((JsonObject)json, (String)"key"));
            CharSequence[] pattern = ShapedRecipeAccess.callShrink(ShapedRecipeAccess.callPatternFromJson(class_3518.method_15261((JsonObject)json, (String)"pattern")));
            recipe.pattern = String.join((CharSequence)"", pattern);
            recipe.width = ((String)pattern[0]).length();
            recipe.height = pattern.length;
            recipe.recipeItems = ShapedRecipeAccess.callDissolvePattern((String[])pattern, ingredientMap, recipe.width, recipe.height);
            recipe.recipeOutput = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            recipe.differentInputs = class_3518.method_15258((JsonObject)json, (String)"differentInputs", (boolean)false);
        }

        public static void fromNetwork(DynamicShapedRecipe recipe, class_2540 buffer) {
            recipe.width = buffer.method_10816();
            recipe.height = buffer.method_10816();
            recipe.group = buffer.method_10800(256);
            int size = recipe.width * recipe.height;
            recipe.recipeItems = class_2371.method_10213((int)size, (Object)class_1856.field_9017);
            for (int k = 0; k < size; ++k) {
                recipe.recipeItems.set(k, (Object)class_1856.method_8086((class_2540)buffer));
            }
            recipe.recipeOutput = buffer.method_10819();
            recipe.pattern = buffer.method_10800(size);
            recipe.differentInputs = buffer.readBoolean();
        }

        public void toNetwork(class_2540 buffer, T recipe) {
            buffer.method_10804(((DynamicShapedRecipe)((Object)recipe)).getRecipeWidth());
            buffer.method_10804(((DynamicShapedRecipe)((Object)recipe)).getRecipeHeight());
            buffer.method_10788(((DynamicShapedRecipe)((Object)recipe)).method_8112(), 256);
            for (class_1856 ingredient : ((DynamicShapedRecipe)((Object)recipe)).method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(((DynamicShapedRecipe)((Object)recipe)).recipeOutput);
            buffer.method_10788(((DynamicShapedRecipe)((Object)recipe)).pattern, ((DynamicShapedRecipe)((Object)recipe)).method_8117().size());
            buffer.writeBoolean(((DynamicShapedRecipe)((Object)recipe)).differentInputs);
        }
    }
}

