/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import snownee.kiwi.util.Util;
import snownee.snow.CoreModule;
import snownee.snow.Hooks;
import snownee.snow.block.WatcherSnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;

public class SnowCoveredBlockEntity
extends SnowBlockEntity {
    public SnowCoveredBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CoreModule.TEXTURE_TILE.get(), pos, state);
        this.options.renderOverlay = true;
    }

    @Override
    public void loadState(CompoundTag data, boolean network) {
        boolean changed = false;
        if (!network && data.m_128441_("Items")) {
            Item item;
            String idStr = data.m_128469_("Items").m_128461_("0");
            ResourceLocation id = Util.RL((String)idStr);
            if (id != null && (item = (Item)BuiltInRegistries.f_257033_.m_7745_(id)) instanceof BlockItem) {
                Block block = ((BlockItem)item).m_40614_();
                changed |= this.setState(Hooks.copyProperties(this.m_58900_(), block.m_49966_()), network);
            }
        } else if (data.m_128441_("Block")) {
            ResourceLocation id = Util.RL((String)data.m_128461_("Block"));
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
            if (block != null && block != Blocks.f_50016_) {
                changed |= this.setState(Hooks.copyProperties(this.m_58900_(), block.m_49966_()), network);
            }
        } else {
            changed |= this.setState(NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)data.m_128469_("State")), network);
        }
        if (changed && network) {
            this.refresh();
        }
    }

    @Override
    public void saveState(CompoundTag data, boolean network) {
        data.m_128359_("Block", BuiltInRegistries.f_256975_.m_7981_((Object)this.getState().m_60734_()).toString());
    }

    public void m_155250_(BlockState blockState) {
        super.m_155250_(blockState);
        this.setState(Hooks.copyProperties(this.m_58900_(), this.state), false);
    }

    public void refresh() {
        super.refresh();
        if (this.m_58898_() && this.f_58857_.f_46443_) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
        }
    }

    public void onLoad() {
        if (!this.f_58857_.f_46443_ && this.m_58900_().m_60734_() instanceof WatcherSnowVariant) {
            SnowCoveredBlockEntity.updateOptions(this.f_58857_, this.f_58858_);
        }
        super.onLoad();
    }

    public static void updateOptions(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SnowCoveredBlockEntity) {
            SnowCoveredBlockEntity be = (SnowCoveredBlockEntity)blockEntity;
            BlockState state = be.m_58900_();
            ((WatcherSnowVariant)state.m_60734_()).updateOptions(state, (BlockGetter)level, pos, be.options);
        }
    }
}

