/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.compat.sodium;

import java.util.List;
import java.util.function.Supplier;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import snownee.snow.client.RenderAPI;
import snownee.snow.mixin.sodium.BlockRendererAccess;

public class RubidiumRenderAPI
implements RenderAPI {
    private final BlockRendererAccess blockRenderer;
    private final BlockRenderContext ctx;
    private final ChunkModelBuilder buffers;

    public RubidiumRenderAPI(BlockRendererAccess blockRenderer, BlockRenderContext ctx, ChunkModelBuilder buffers) {
        this.blockRenderer = blockRenderer;
        this.ctx = ctx;
        this.buffers = buffers;
    }

    @Override
    public boolean translateYAndRender(BlockAndTintGetter world, BlockState state, BlockPos pos, @Nullable RenderType layer, Supplier<RandomSource> randomSupplier, boolean cullSides, BakedModel model, double yOffset) {
        RandomSource random = randomSupplier.get();
        ModelData modelData = this.ctx.data();
        if (layer != null && !model.getRenderTypes(state, random, modelData).contains(layer)) {
            return false;
        }
        Vec3 offset = state.m_60824_((BlockGetter)world, pos);
        if (yOffset != 0.0) {
            offset = offset.m_82520_(0.0, yOffset, 0.0);
            cullSides = false;
        }
        LightPipeline lighter = this.blockRenderer.getLighters().getLighter(this.blockRenderer.callGetLightingMode(state, model, world, pos));
        boolean rendered = false;
        for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
            random.m_188584_(this.ctx.seed());
            List sided = model.getQuads(state, dir, random, modelData, layer);
            if (sided.isEmpty() || cullSides && !this.blockRenderer.getOcclusionCache().shouldDrawSide(state, (BlockGetter)world, pos, dir)) continue;
            this.blockRenderer.callRenderQuadList(this.ctx, lighter, offset, this.buffers, sided, dir);
            rendered = true;
        }
        random.m_188584_(this.ctx.seed());
        List all = model.getQuads(state, null, random, modelData, layer);
        if (!all.isEmpty()) {
            this.blockRenderer.callRenderQuadList(this.ctx, lighter, offset, this.buffers, all, null);
            rendered = true;
        }
        return rendered;
    }
}

