/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.mixin;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import snownee.snow.client.SnowClient;
import snownee.snow.client.SnowVariantMetadataSectionSerializer;
import snownee.snow.client.model.ModelDefinition;

@Mixin(value={ModelBakery.class})
public abstract class ModelBakeryMixin {
    @Shadow
    private Set<ResourceLocation> f_119210_;
    @Shadow
    private Map<ResourceLocation, UnbakedModel> f_119214_;
    private final Set<ResourceLocation> snowModels = Sets.newHashSet();

    @Inject(at={@At(value="TAIL")}, method={"loadBlockModel"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void srm_loadBlockModel(ResourceLocation resourceLocation, CallbackInfoReturnable<BlockModel> ci, String s, ResourceLocation resourceLocation2, BlockModel blockModel) throws IOException {
        if (blockModel == null) {
            return;
        }
        Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation2);
        if (resource.isEmpty()) {
            return;
        }
        ModelDefinition def = ((Resource)resource.get()).m_215509_().m_214059_((MetadataSectionSerializer)SnowVariantMetadataSectionSerializer.SERIALIZER).orElse(null);
        if (def != null && def.model != null) {
            this.f_119210_.add(def.model);
            this.snowModels.add(def.model);
            SnowClient.snowVariantMapping.put(resourceLocation, def);
        } else if (this.snowModels.contains(resourceLocation)) {
            this.f_119214_.put(resourceLocation, (UnbakedModel)blockModel);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void srm_clearSnowModels(CallbackInfo ci) {
        this.snowModels.clear();
    }
}

