/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2356;
import net.minecraft.class_2382;
import net.minecraft.class_2420;
import net.minecraft.class_2473;
import net.minecraft.class_2482;
import net.minecraft.class_2488;
import net.minecraft.class_2493;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2526;
import net.minecraft.class_2544;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2902;
import net.minecraft.class_2968;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3558;
import net.minecraft.class_3830;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import snownee.kiwi.KiwiGO;
import snownee.snow.CoreModule;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.network.SSnowLandEffectPacket;

public final class Hooks {
    private Hooks() {
    }

    public static boolean canGrassSurvive(class_2680 blockState, class_4538 viewableWorld, class_2338 blockPos) {
        class_2338 blockPos2 = blockPos.method_10084();
        class_2680 blockState2 = viewableWorld.method_8320(blockPos2);
        if (blockState2.method_26164(CoreModule.BOTTOM_SNOW)) {
            if (blockState2.method_27852(class_2246.field_10477)) {
                return SnowCommonConfig.sustainGrassIfLayerMoreThanOne || (Integer)blockState2.method_11654((class_2769)class_2488.field_11518) == 1;
            }
            return true;
        }
        int i = class_3558.method_20049((class_1922)viewableWorld, (class_2680)blockState, (class_2338)blockPos, (class_2680)blockState2, (class_2338)blockPos2, (class_2350)class_2350.field_11036, (int)blockState2.method_26193((class_1922)viewableWorld, blockPos2));
        return i < viewableWorld.method_8315();
    }

    public static boolean place(class_5821<class_3111> ctx) {
        class_5281 worldgenlevel = ctx.method_33652();
        class_2338 blockpos = ctx.method_33655();
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2338.class_2339 belowPos = new class_2338.class_2339();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                class_2680 blockstate;
                int k = blockpos.method_10263() + i;
                int l = blockpos.method_10260() + j;
                int i1 = worldgenlevel.method_8624(class_2902.class_2903.field_13197, k, l);
                pos.method_10103(k, i1, l);
                belowPos.method_10101((class_2382)pos).method_10104(class_2350.field_11033, 1);
                class_1959 biome = (class_1959)worldgenlevel.method_23753((class_2338)pos).comp_349();
                if (biome.method_8685((class_4538)worldgenlevel, (class_2338)belowPos, false)) {
                    worldgenlevel.method_8652((class_2338)belowPos, class_2246.field_10295.method_9564(), 2);
                }
                if (biome.method_8696((class_4538)worldgenlevel, (class_2338)pos)) {
                    worldgenlevel.method_8652((class_2338)pos, class_2246.field_10477.method_9564(), 2);
                    blockstate = worldgenlevel.method_8320((class_2338)belowPos);
                    if (!blockstate.method_28498((class_2769)class_2493.field_11522)) continue;
                    worldgenlevel.method_8652((class_2338)belowPos, (class_2680)blockstate.method_11657((class_2769)class_2493.field_11522, (Comparable)Boolean.valueOf(true)), 2);
                    continue;
                }
                if (!SnowCommonConfig.replaceWorldFeature || !SnowCommonConfig.placeSnowOnBlockNaturally || !SnowCommonConfig.canPlaceSnowInBlock() || biome.method_39927((class_2338)pos) || worldgenlevel.method_8314(class_1944.field_9282, (class_2338)pos) >= 10 || !class_2246.field_10477.method_9564().method_26184((class_4538)worldgenlevel, (class_2338)pos) || !Hooks.convert((class_1936)worldgenlevel, (class_2338)pos, blockstate = worldgenlevel.method_8320((class_2338)pos), 1, 2, true) || !(blockstate = worldgenlevel.method_8320((class_2338)belowPos)).method_28498((class_2769)class_2493.field_11522)) continue;
                worldgenlevel.method_8652((class_2338)belowPos, (class_2680)blockstate.method_11657((class_2769)class_2493.field_11522, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return true;
    }

    public static boolean canSnowSurvive(class_2680 state, class_1922 worldIn, class_2338 pos) {
        class_2680 blockstate = worldIn.method_8320(pos.method_10074());
        if (blockstate.method_26164(class_3481.field_39104)) {
            return false;
        }
        if (blockstate.method_26164(class_3481.field_39105)) {
            return true;
        }
        return class_2248.method_9501((class_265)blockstate.method_26220(worldIn, pos.method_10074()), (class_2350)class_2350.field_11036) || blockstate.method_26204() instanceof class_2488 && (Integer)blockstate.method_11654((class_2769)class_2488.field_11518) == 8;
    }

    public static boolean canContainState(class_2680 state) {
        if (!SnowCommonConfig.canPlaceSnowInBlock() || state.method_31709() || !state.method_26227().method_15769()) {
            return false;
        }
        class_2248 block = state.method_26204();
        if (state.method_26164(CoreModule.NOT_CONTAINABLES)) {
            return false;
        }
        if (state.method_26164(CoreModule.CONTAINABLES) || block instanceof class_2526 || block instanceof class_2320 || block instanceof class_2356 || block instanceof class_2473 || block instanceof class_2420 || block instanceof class_3830) {
            return true;
        }
        if (block instanceof class_2354 && state.method_26164(class_3481.field_16584)) {
            return Hooks.hasAllProperties(state, CoreModule.FENCE.defaultBlockState());
        }
        if (block instanceof class_2349 && state.method_26164(class_3481.field_25147)) {
            return Hooks.hasAllProperties(state, CoreModule.FENCE_GATE.defaultBlockState());
        }
        if (block instanceof class_2544 && state.method_26164(class_3481.field_15504)) {
            return Hooks.hasAllProperties(state, CoreModule.WALL.defaultBlockState());
        }
        if (block instanceof class_2482 && state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681 && state.method_26164(class_3481.field_15469)) {
            return true;
        }
        if (block instanceof class_2510 && state.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12617 && state.method_26164(class_3481.field_15459)) {
            return Hooks.hasAllProperties(state, CoreModule.STAIRS.defaultBlockState());
        }
        return false;
    }

    public static boolean convert(class_1936 world, class_2338 pos, class_2680 state, int layers, int flags, boolean canConvert) {
        if (state.method_26215()) {
            world.method_8652(pos, (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(layers)), flags);
            return true;
        }
        if (!SnowCommonConfig.canPlaceSnowInBlock() || state.method_31709()) {
            return false;
        }
        if (!canConvert) {
            return false;
        }
        class_2248 block = state.method_26204();
        if (state.method_26164(CoreModule.CONTAINABLES) || block instanceof class_2526 || block instanceof class_2320 || block instanceof class_2356 || block instanceof class_2473 || block instanceof class_2420 || block instanceof class_3830) {
            world.method_8652(pos, (class_2680)CoreModule.TILE_BLOCK.defaultBlockState().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(layers)), flags);
            class_2586 tile = world.method_8321(pos);
            if (tile instanceof SnowBlockEntity) {
                ((SnowBlockEntity)tile).setState(state);
            }
            return true;
        }
        class_2338 posDown = pos.method_10074();
        class_2680 stateDown = world.method_8320(posDown);
        if (block instanceof class_2510 && !CoreModule.STAIRS.is(state) && state.method_26164(class_3481.field_15459)) {
            newState = CoreModule.STAIRS.defaultBlockState();
            newState = Hooks.copyProperties(state, newState);
            world.method_8652(pos, newState, flags);
        } else if (block instanceof class_2482 && !CoreModule.SLAB.is(state) && state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681 && state.method_26164(class_3481.field_15469)) {
            world.method_8652(pos, CoreModule.SLAB.defaultBlockState(), flags);
        } else if (block instanceof class_2354 && block.getClass() != SnowFenceBlock.class && state.method_26164(class_3481.field_16584)) {
            KiwiGO<class_2248> newBlock = state.method_26164(class_3481.field_17619) ? CoreModule.FENCE : CoreModule.FENCE2;
            class_2680 newState = newBlock.defaultBlockState();
            newState = Hooks.copyProperties(state, newState);
            newState = newState.method_26191(class_2350.field_11033, stateDown, world, pos, posDown);
            world.method_8652(pos, newState, flags);
        } else if (block instanceof class_2349 && !CoreModule.FENCE_GATE.is(state) && state.method_26164(class_3481.field_25147)) {
            newState = CoreModule.FENCE_GATE.defaultBlockState();
            newState = Hooks.copyProperties(state, newState);
            newState = newState.method_26191(class_2350.field_11033, stateDown, world, pos, posDown);
            world.method_8652(pos, newState, flags);
        } else if (block instanceof class_2544 && !CoreModule.WALL.is(state) && state.method_26164(class_3481.field_15504)) {
            newState = CoreModule.WALL.defaultBlockState();
            newState = Hooks.copyProperties(state, newState);
            newState = newState.method_26191(class_2350.field_11033, stateDown, world, pos, posDown);
            world.method_8652(pos, newState, flags);
        } else {
            return false;
        }
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof SnowBlockEntity) {
            ((SnowBlockEntity)tile).setState(state);
        }
        return true;
    }

    private static <T extends Comparable<T>> boolean hasAllProperties(class_2680 oldState, class_2680 newState) {
        for (Map.Entry entry : newState.method_11656().entrySet()) {
            class_2769 property = (class_2769)entry.getKey();
            if (oldState.method_28498(property)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> class_2680 copyProperties(class_2680 oldState, class_2680 newState) {
        for (Map.Entry entry : oldState.method_11656().entrySet()) {
            class_2769 property = (class_2769)entry.getKey();
            if (!newState.method_28498(property)) continue;
            newState = (class_2680)newState.method_11657(property, (Comparable)property.method_11902().cast(entry.getValue()));
        }
        return newState;
    }

    public static boolean placeLayersOn(class_1937 world, class_2338 pos, int layers, boolean fallingEffect, class_1750 useContext, boolean playSound, boolean canConvert) {
        layers = class_3532.method_15340((int)layers, (int)1, (int)8);
        class_2680 state = world.method_8320(pos);
        int originLayers = 0;
        if (state.method_26204() instanceof class_2488) {
            originLayers = (Integer)state.method_11654((class_2769)class_2488.field_11518);
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(class_3532.method_15340((int)(originLayers + layers), (int)1, (int)8))));
        } else if (canConvert && Hooks.canContainState(state) && state.method_26184((class_4538)world, pos)) {
            Hooks.convert((class_1936)world, pos, state, class_3532.method_15340((int)layers, (int)1, (int)8), 3, canConvert);
        } else if (Hooks.canSnowSurvive(state, (class_1922)world, pos) && world.method_8320(pos).method_26166(useContext)) {
            world.method_8501(pos, (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(class_3532.method_15340((int)layers, (int)1, (int)8))));
        } else {
            return false;
        }
        class_2248.method_9582((class_2680)state, (class_2680)world.method_8320(pos), (class_1936)world, (class_2338)pos);
        if (fallingEffect) {
            SSnowLandEffectPacket.send(world, pos, originLayers, layers);
        } else if (playSound) {
            class_2498 soundtype = class_2246.field_10477.method_9573(class_2246.field_10477.method_9564());
            world.method_8396(null, pos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
        }
        if (originLayers + layers > 8) {
            pos = pos.method_10084();
            if (Hooks.canSnowSurvive(class_2246.field_10477.method_9564(), (class_1922)world, pos) && world.method_8320(pos).method_26166(useContext)) {
                Hooks.placeLayersOn(world, pos, layers - (8 - originLayers), fallingEffect, useContext, playSound, canConvert);
            }
        }
        return true;
    }

    public static boolean canFallThrough(class_2680 state, class_1937 worldIn, class_2338 pos) {
        if (state.method_26220((class_1922)worldIn, pos).method_1110() && class_2346.method_10128((class_2680)state) && state.method_26220((class_1922)worldIn, pos).method_1110()) {
            return true;
        }
        return state.method_26204() instanceof class_2488 && (Integer)state.method_11654((class_2769)class_2488.field_11518) < 8;
    }

    public static void randomTick(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 random) {
        class_2338 height;
        boolean melt;
        if (ModUtil.terraforged) {
            return;
        }
        if (random.method_43048(8) != 0) {
            return;
        }
        class_6880 biome = worldIn.method_23753(pos);
        int layers = (Integer)state.method_11654((class_2769)class_2488.field_11518);
        boolean meltByTemperature = false;
        boolean meltByBrightness = false;
        if (!SnowCommonConfig.snowNeverMelt) {
            class_2680 upState;
            if (layers == 8 && (upState = worldIn.method_8320(pos.method_10084())).method_26204() instanceof class_2488) {
                return;
            }
            meltByTemperature = ModUtil.shouldMelt((class_1937)worldIn, pos, (class_6880<class_1959>)biome, layers);
            meltByBrightness = worldIn.method_8314(class_1944.field_9282, pos) > 11;
        }
        boolean bl = melt = meltByTemperature || meltByBrightness;
        if (!melt) {
            if (!SnowCommonConfig.snowAccumulationDuringSnowfall && !SnowCommonConfig.snowAccumulationDuringSnowstorm) {
                return;
            }
            if (SnowCommonConfig.accumulationWinterOnly && !ModUtil.isWinter((class_1937)worldIn, pos, (class_6880<class_1959>)biome)) {
                return;
            }
        }
        if (!meltByBrightness && (height = worldIn.method_8598(class_2902.class_2903.field_13197, pos)).method_10264() > pos.method_10264()) {
            return;
        }
        boolean accumulate = false;
        if (!meltByBrightness && worldIn.method_8419() && ModUtil.coldEnoughToSnow((class_1937)worldIn, pos, (class_6880<class_1959>)biome)) {
            if (SnowCommonConfig.snowAccumulationDuringSnowfall) {
                accumulate = true;
            } else if (SnowCommonConfig.snowAccumulationDuringSnowstorm && worldIn.method_8546()) {
                accumulate = true;
            }
        }
        if (accumulate) {
            if (layers < SnowCommonConfig.snowAccumulationMaxLayers) {
                Hooks.accumulate((class_1937)worldIn, pos, state, (w, p) -> (SnowCommonConfig.snowAccumulationMaxLayers > 8 || !(w.method_8320(p.method_10074()).method_26204() instanceof class_2488)) && w.method_8314(class_1944.field_9282, p) <= 10, true);
            }
        } else if (melt) {
            if (layers == 1) {
                SnowVariant snow = (SnowVariant)state.method_26204();
                worldIn.method_8501(pos, snow.getRaw(state, (class_1922)worldIn, pos));
            } else {
                Hooks.accumulate((class_1937)worldIn, pos, state, (w, p) -> !(w.method_8320(p.method_10084()).method_26204() instanceof class_2488), false);
            }
        }
    }

    private static void accumulate(class_1937 world, class_2338 pos, class_2680 centerState, BiPredicate<class_1936, class_2338> filter, boolean accumulate) {
        int i = (Integer)centerState.method_11654((class_2769)class_2488.field_11518);
        for (int j = 0; j < 8; ++j) {
            int l;
            int k = j / 2;
            class_2350 direction = class_2350.method_10139((int)k);
            class_2338 pos2 = pos.method_10093(direction);
            if (j % 2 == 1) {
                pos2 = pos2.method_10093(class_2350.method_10139((int)(k + 1)));
            }
            if (!world.method_8477(pos2) || !filter.test((class_1936)world, pos2)) continue;
            class_2680 state = world.method_8320(pos2);
            class_2338 height = world.method_8598(class_2902.class_2903.field_13197, pos2);
            if (height.method_10264() != pos2.method_10264() || !Hooks.canSnowSurvive(state, (class_1922)world, pos2)) continue;
            if (state.method_26204() instanceof class_2488) {
                l = (Integer)state.method_11654((class_2769)class_2488.field_11518);
                if (accumulate && state.method_26164(CoreModule.CANNOT_ACCUMULATE_ON)) {
                    continue;
                }
            } else {
                l = 0;
            }
            if (!(accumulate ? i > l : i < l)) continue;
            if (accumulate) {
                Hooks.placeLayersOn(world, pos2, 1, false, (class_1750)new class_2968(world, pos2, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033), false, SnowCommonConfig.placeSnowOnBlockNaturally);
            } else {
                world.method_8501(pos2, (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(l - 1)));
            }
            return;
        }
        if (accumulate) {
            Hooks.placeLayersOn(world, pos, 1, false, (class_1750)new class_2968(world, pos, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033), false, SnowCommonConfig.placeSnowOnBlockNaturally);
        } else {
            world.method_8501(pos, (class_2680)centerState.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(i - 1)));
        }
    }
}

