/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import snownee.kiwi.Kiwi;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfig;

public class KiwiConfigManager {
    public static final List<ConfigHandler> allConfigs = Lists.newLinkedList();
    private static final Map<Class<?>, ConfigHandler> clazz2Configs = Maps.newHashMap();
    public static final Map<class_2960, ConfigHandler.Value<Boolean>> modules = Maps.newHashMap();

    public static synchronized void register(ConfigHandler configHandler) {
        allConfigs.add(configHandler);
        if (configHandler.getClass() != null) {
            clazz2Configs.put(configHandler.getClazz(), configHandler);
        }
    }

    public static void init() {
        Collections.sort(allConfigs, (a, b) -> a.getFileName().compareTo(b.getFileName()));
        HashSet settledMods = Sets.newHashSet();
        for (ConfigHandler config : allConfigs) {
            if (!config.hasModules()) continue;
            settledMods.add(config.getModId());
        }
        for (ConfigHandler config : allConfigs) {
            config.init();
        }
        for (class_2960 rl : Kiwi.defaultOptions.keySet()) {
            if (settledMods.contains(rl.method_12836())) continue;
            settledMods.add(rl.method_12836());
            ConfigHandler config = new ConfigHandler(rl.method_12836(), rl.method_12836() + "-modules", KiwiConfig.ConfigType.COMMON, null, true);
            config.init();
        }
    }

    public static void defineModules(String modId, ConfigHandler builder, boolean subcategory) {
        String prefix = subcategory ? "modules." : "";
        for (Map.Entry<class_2960, Boolean> entry : Kiwi.defaultOptions.entrySet()) {
            class_2960 rl = entry.getKey();
            if (!rl.method_12836().equals(modId)) continue;
            ConfigHandler.Value<Boolean> value = builder.define(prefix + rl.method_12832(), entry.getValue(), null, "%s.config.modules.%s".formatted(modId, rl.method_12832()));
            value.requiresRestart = true;
            modules.put(rl, value);
        }
    }

    public static void refresh() {
        allConfigs.forEach(ConfigHandler::refresh);
    }

    public static ConfigHandler getHandler(Class<?> clazz) {
        return clazz2Configs.get(clazz);
    }
}

